<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/guititle"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'settings'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="settings"/>
					<input type="hidden" name="function" value="display"/>
					<input type="hidden" name="display_type" value="gui"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">						
						<tr>
							<td colspan="2" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/changedsuccess"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tendersystemversion"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="settings/version"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/xslt"/>
							</td>
							<td align="left" class="t2">
								<select name="xslt" class="t2">
								<xsl:if test="sablotron">
									<option value="sablotron">
										<xsl:value-of select="$lng/sablotron"/>
									</option>
								</xsl:if>
								<xsl:if test="libxslt">
									<option value="libxslt">
										<xsl:if test="settings/xslt='libxslt'">
												<xsl:attribute name="selected">selected</xsl:attribute>
											</xsl:if>
										<xsl:value-of select="$lng/libxslt"/>
									</option>
								</xsl:if>
									<option value="client">
											<xsl:if test="settings/xslt='client'">
												<xsl:attribute name="selected">selected</xsl:attribute>
											</xsl:if>
											<xsl:value-of select="$lng/client"/>
									</option>
								<xsl:if test="libxslt or sablotron">
									<option value="browser">
											<xsl:if test="settings/xslt='browser'">
												<xsl:attribute name="selected">selected</xsl:attribute>
											</xsl:if>
											<xsl:value-of select="$lng/browser"/>
									</option>
								</xsl:if>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apiconnection"/> 
							</td>
							<td align="left" class="t2">
								<select name="apiconnection" class="t2">
									<option value="curl">
										<xsl:value-of select="$lng/curl"/>
									</option>
									<option value="module">
										<xsl:if test="settings/apiconnection='module'">
											<xsl:attribute name="selected">selected</xsl:attribute>
										</xsl:if>
										<xsl:value-of select="$lng/module"/>
									</option>
									<xsl:value-of select="' '"/><xsl:value-of select="$lng/userslogout"/> 
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apiserver"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="apiserver" size="40" maxlenght="60" class="t2" value="{settings/apiserver}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/guiusername"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="guiusername" size="15" maxlenght="60" class="t2" value="{settings/guiusername}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/guipassword"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="guipassword" size="15" maxlenght="60" class="t2" value="{settings/guipassword}"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/displaystrip"/>
							<xsl:with-param name="input_name" select="'displaystrip'"/>
							<xsl:with-param name="input_value" select="settings/displaystrip"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/displaygzip"/>
							<xsl:with-param name="input_name" select="'displaygzip'"/>
							<xsl:with-param name="input_value" select="settings/displaygzip"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/apidebug"/>
							<xsl:with-param name="input_name" select="'apidebug'"/>
							<xsl:with-param name="input_value" select="settings/apidebug"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/timer"/>
							<xsl:with-param name="input_name" select="'timer'"/>
							<xsl:with-param name="input_value" select="settings/timer"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/disclaimer"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="disclaimer" size="40" maxlenght="40" class="t2" value="{settings/disclaimer}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/privacy"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="privacy" size="40" maxlenght="40" class="t2" value="{settings/privacy}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/help"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="help" size="40" maxlenght="40" class="t2" value="{settings/help}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/faq"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="faq" size="40" maxlenght="40" class="t2" value="{settings/faq}"/>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="h1 t1">
								<xsl:value-of select="' '"/><xsl:value-of select="$lng/menugeneration"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/menucache"/>
							<xsl:with-param name="input_name" select="'menucache'"/>
							<xsl:with-param name="input_value" select="settings/menucache"/>
							<xsl:with-param name="true" select="$lng/cache"/>
							<xsl:with-param name="false" select="$lng/dynamic"/>
						</xsl:call-template>
					<xsl:if test="settings/menucache='TRUE'">
						<tr>
							<td align="left" class="t1"><br/></td>
							<td align="left" class="t2">
								<a href="main.php?module=menu&amp;function=clear_cache">
									<xsl:value-of select="$lng/clearmenucache"/>
								</a>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/menusort1"/>
							</td>
							<td align="left" class="t2">
								<select name="menusort1" class="t2">
									<option value=""><xsl:value-of select="$lng/none"/></option>
									<option value="ksort">
										<xsl:if test="settings/menusort1='ksort'"><xsl:attribute name="selected"/></xsl:if>
										<xsl:value-of select="$lng/tendersystems"/>
									</option>
									<option value="krsort">
										<xsl:if test="settings/menusort1='krsort'"><xsl:attribute name="selected"/></xsl:if>
										<xsl:value-of select="$lng/tendersystemr"/>
									</option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/menusort2"/>
							</td>
							<td align="left" class="t2">
								<select name="menusort2" class="t2">
									<option value=""><xsl:value-of select="$lng/none"/></option>
									<option value="krsort">
										<xsl:if test="settings/menusort2='krsort'"><xsl:attribute name="selected"/></xsl:if>
										<xsl:value-of select="$lng/tendersystems"/>
									</option>
									<option value="ksort">
										<xsl:if test="settings/menusort2='ksort'"><xsl:attribute name="selected"/></xsl:if>
										<xsl:value-of select="$lng/tendersystemr"/>
									</option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/menusort3"/>
							</td>
							<td align="left" class="t2">
								<select name="menusort3" class="t2">
									<option value=""><xsl:value-of select="$lng/none"/></option>
									<option value="ksort">
										<xsl:if test="settings/menusort3='ksort'"><xsl:attribute name="selected"/></xsl:if>
										<xsl:value-of select="$lng/tendersystems"/>
									</option>
									<option value="krsort">
										<xsl:if test="settings/menusort3='krsort'"><xsl:attribute name="selected"/></xsl:if>
										<xsl:value-of select="$lng/tendersystemr"/>
									</option>
								</select>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/leftmenuhtml"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/leftmenuhtml"/>
							</td>
							<td align="left" class="t2">	
								<textarea name="menuleft" rows="3" cols="50" class="t2" value="{settings/menuleft}">
									<xsl:value-of select="settings/menuleft"/>
								</textarea>
							</td>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
						<tr>
							<td colspan="2" class="h1 t1">
								TenderSystem<xsl:value-of select="' '"/><xsl:value-of select="$lng/staticmaintenancepage"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/staticmaintenancepage"/>
							<xsl:with-param name="input_name" select="'status'"/>
							<xsl:with-param name="input_value" select="settings/status"/>
							<xsl:with-param name="true" select="$lng/inactive"/>
							<xsl:with-param name="false" select="$lng/active"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/statusmessage"/>
							</td>
							<td align="left" class="t2">	
								<textarea name="statusmessage" rows="3" cols="50" class="t2" value="{settings/statusmessage}">
									<xsl:value-of select="settings/statusmessage"/>
								</textarea>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/input"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/inputtype"/>
							<xsl:with-param name="input_name" select="'inputtype'"/>
							<xsl:with-param name="input_value" select="settings/inputtype"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/inputformat"/>
							<xsl:with-param name="input_name" select="'inputformat'"/>
							<xsl:with-param name="input_value" select="settings/inputformat"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/inputphonemin"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="inputphonemin" size="4" class="t2" value="{settings/inputphonemin}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/inputphonemax"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="inputphonemax" size="4" class="t2" value="{settings/inputphonemax}"/>
							</td>
						</tr>
						<tr>
							<td colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/upload"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/uploadactive"/>
							<xsl:with-param name="input_name" select="'uploadactive'"/>
							<xsl:with-param name="input_value" select="settings/uploadactive"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/uploadpath"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="uploadpath" size="10" maxlenght="40" class="t2" value="{settings/uploadpath}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/uploadfilesize"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="uploadfilesize" size="4" maxlenght="40" class="t2" value="{settings/uploadfilesize}"/> KB
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/uploadany"/>
							<xsl:with-param name="input_name" select="'uploadany'"/>
							<xsl:with-param name="input_value" select="settings/uploadany"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td><br/></td>
							<td align="left" class="h1 t1">
								<xsl:value-of select="$lng/uploadfiletype"/>
							</td>
						</tr>
						<tr>
							<td></td>
							<td>
								<table border="0" align="center" cellpadding="2" cellspacing="0" width="200" bgcolor="FFFFFF">
									<tr>	
										<td align="left" valign="top" rowspan="3" class="t1">
											<xsl:value-of select="$lng/pictures"/>
										</td>
										<td align="left" valign="top" rowspan="3" class="t1">
											<input name="pictures" type="checkbox" onchange="CheckPictures()"/>
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypegif" type="checkbox">
												<xsl:if test="settings/uploadfiletypegif='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											gif
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypejpg" type="checkbox">
												<xsl:if test="settings/uploadfiletypejpg='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											jpg
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypejpeg" type="checkbox">
												<xsl:if test="settings/uploadfiletypejpeg='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											jpeg
										</td>
									</tr>
									<tr>
										<td align="left" class="t2">
											<input name="uploadfiletypetiff" type="checkbox">
												<xsl:if test="settings/uploadfiletypetiff='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											tiff
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypetif" type="checkbox">
												<xsl:if test="settings/uploadfiletypetif='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											tif
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypepng" type="checkbox">
												<xsl:if test="settings/uploadfiletypepng='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											png
										</td>
									</tr>
									<tr>
										<td align="left" colspan="3" class="t2">
											<input name="uploadfiletypebmp" type="checkbox">
												<xsl:if test="settings/uploadfiletypebmp='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											bmp
										</td>
									</tr>
									<tr>
										<td align="left" class="t1">
											<xsl:value-of select="$lng/spread"/>
										</td>
										<td align="left" class="t2">
											<input name="spread" type="checkbox" onchange="CheckSpread()"/>
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypexls" type="checkbox">
												<xsl:if test="settings/uploadfiletypexls='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											xls
										</td>
										<td align="left" class="t2" colspan="2">
											<input name="uploadfiletypesxc" type="checkbox">
												<xsl:if test="settings/uploadfiletypesxc='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											sxc
										</td>
									</tr>
									<tr>
										<td align="left" valign="top" rowspan="2" class="t1">
											<xsl:value-of select="$lng/documents"/>
										</td>
										<td align="left" valign="top" rowspan="2" class="t1">
											<input name="docs" type="checkbox" onchange="CheckDoc()"/>
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypedoc" rowspan="2" type="checkbox">
												<xsl:if test="settings/uploadfiletypedoc='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											doc
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypesxw" type="checkbox">
												<xsl:if test="settings/uploadfiletypesxw='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											sxw
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypepdf" type="checkbox">
												<xsl:if test="settings/uploadfiletypepdf='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											pdf
										</td>
									</tr>
									<tr>
										<td align="left" class="t2">
											<input name="uploadfiletypexml" type="checkbox">
												<xsl:if test="settings/uploadfiletypexml='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											xml
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypehtml" type="checkbox">
												<xsl:if test="settings/uploadfiletypehtml='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											html
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypetxt" type="checkbox">
												<xsl:if test="settings/uploadfiletypetxt='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											txt
										</td>
									</tr>		
									<tr>
										<td align="left" valign="top" rowspan="2" class="t1">
											<xsl:value-of select="$lng/archives"/>
										</td>
										<td align="left" valign="top" rowspan="2" class="t1">
											<input name="archives" type="checkbox" onchange="CheckArch()"/>
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypezip" type="checkbox">
												<xsl:if test="settings/uploadfiletypezip='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											zip
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypetar" type="checkbox">
												<xsl:if test="settings/uploadfiletypetar='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											tar
										</td>
										<td align="left" class="t2">
											<input name="uploadfiletypegz" type="checkbox">
												<xsl:if test="settings/uploadfiletypegz='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											gz
										</td>
									</tr>
									<tr>
										<td align="left" class="t2">
											<input name="uploadfiletypebz2" type="checkbox">
												<xsl:if test="settings/uploadfiletypebz2='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											bz2
										</td>
										<td align="left" class="t2" colspan="2">
											<input name="uploadfiletyperar" type="checkbox">
												<xsl:if test="settings/uploadfiletyperar='TRUE'">
													<xsl:attribute name="checked"/>
												</xsl:if>
											</input>
											rar
										</td>
									</tr>
								</table>
							</td>
						</tr>		
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/guiinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
				<div id="right_header">
					<xsl:value-of select="$lng/apiconnection"/>
				</div>
				<div id="right_content">
					<b><xsl:value-of select="$lng/curl"/></b>
					<br/>
					<img src="./theme/{$theme}/img/api.gif" border="0" alt="API"/>
					<br/><br/>
					<b><xsl:value-of select="$lng/module"/></b>
					<br/>
					<img src="./theme/{$theme}/img/module.gif" border="0" alt="Module"/>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function CheckPictures() {
			document.report.uploadfiletypegif.checked = document.report.pictures.checked;
			document.report.uploadfiletypejpg.checked = document.report.pictures.checked;
			document.report.uploadfiletypejpeg.checked = document.report.pictures.checked;
			document.report.uploadfiletypetiff.checked = document.report.pictures.checked;
			document.report.uploadfiletypetif.checked = document.report.pictures.checked;
			document.report.uploadfiletypepng.checked = document.report.pictures.checked;
			document.report.uploadfiletypebmp.checked = document.report.pictures.checked;
		}
		
		function CheckSpread() {
			document.report.uploadfiletypexls.checked = document.report.spread.checked;
			document.report.uploadfiletypesxc.checked = document.report.spread.checked;
		}
		
		function CheckDoc() {
			document.report.uploadfiletypedoc.checked = document.report.docs.checked;
			document.report.uploadfiletypesxw.checked = document.report.docs.checked;
			document.report.uploadfiletypepdf.checked = document.report.docs.checked;
			document.report.uploadfiletypexml.checked = document.report.docs.checked;
			document.report.uploadfiletypehtml.checked = document.report.docs.checked;
			document.report.uploadfiletypetxt.checked = document.report.docs.checked;
		}
		
		function CheckArch() {
			document.report.uploadfiletypezip.checked = document.report.archives.checked;
			document.report.uploadfiletypetar.checked = document.report.archives.checked;
			document.report.uploadfiletypebz2.checked = document.report.archives.checked;
			document.report.uploadfiletypegz.checked = document.report.archives.checked;
			document.report.uploadfiletyperar.checked = document.report.archives.checked;
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
