<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/changeholidaytitle"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'settings'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="settings"/>
					<input type="hidden" name="function" value="display"/>
					<input type="hidden" name="display_type" value="holiday"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="updated='1'">
						<tr>
							<td colspan="3" class="t1">
								<xsl:value-of select="$lng/changedsuccess"/>
							</td>
						</tr>
						</xsl:if>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/holiday"/>
							</td>
						</tr>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'0'"/>
							<xsl:with-param name="date" select="settings/holiday0date"/>
							<xsl:with-param name="name" select="settings/holiday0name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'1'"/>
							<xsl:with-param name="date" select="settings/holiday1date"/>
							<xsl:with-param name="name" select="settings/holiday1name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'2'"/>
							<xsl:with-param name="date" select="settings/holiday2date"/>
							<xsl:with-param name="name" select="settings/holiday2name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'3'"/>
							<xsl:with-param name="date" select="settings/holiday3date"/>
							<xsl:with-param name="name" select="settings/holiday3name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'4'"/>
							<xsl:with-param name="date" select="settings/holiday4date"/>
							<xsl:with-param name="name" select="settings/holiday4name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'5'"/>
							<xsl:with-param name="date" select="settings/holiday5date"/>
							<xsl:with-param name="name" select="settings/holiday5name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'6'"/>
							<xsl:with-param name="date" select="settings/holiday6date"/>
							<xsl:with-param name="name" select="settings/holiday6name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'7'"/>
							<xsl:with-param name="date" select="settings/holiday7date"/>
							<xsl:with-param name="name" select="settings/holiday7name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'8'"/>
							<xsl:with-param name="date" select="settings/holiday8date"/>
							<xsl:with-param name="name" select="settings/holiday8name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'9'"/>
							<xsl:with-param name="date" select="settings/holiday9date"/>
							<xsl:with-param name="name" select="settings/holiday9name"/>
						</xsl:call-template>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					<xsl:if test="settings/holiday9date!='' or settings/holiday8date!=''">
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'10'"/>
							<xsl:with-param name="date" select="settings/holiday10date"/>
							<xsl:with-param name="name" select="settings/holiday10name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'11'"/>
							<xsl:with-param name="date" select="settings/holiday11date"/>
							<xsl:with-param name="name" select="settings/holiday11name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'12'"/>
							<xsl:with-param name="date" select="settings/holiday12date"/>
							<xsl:with-param name="name" select="settings/holiday12name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'13'"/>
							<xsl:with-param name="date" select="settings/holiday13date"/>
							<xsl:with-param name="name" select="settings/holiday13name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'14'"/>
							<xsl:with-param name="date" select="settings/holiday14date"/>
							<xsl:with-param name="name" select="settings/holiday14name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'15'"/>
							<xsl:with-param name="date" select="settings/holiday15date"/>
							<xsl:with-param name="name" select="settings/holiday15name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'16'"/>
							<xsl:with-param name="date" select="settings/holiday16date"/>
							<xsl:with-param name="name" select="settings/holiday16name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'17'"/>
							<xsl:with-param name="date" select="settings/holiday17date"/>
							<xsl:with-param name="name" select="settings/holiday17name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'18'"/>
							<xsl:with-param name="date" select="settings/holiday18date"/>
							<xsl:with-param name="name" select="settings/holiday18name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'19'"/>
							<xsl:with-param name="date" select="settings/holiday19date"/>
							<xsl:with-param name="name" select="settings/holiday19name"/>
						</xsl:call-template>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="settings/holiday19date!='' or settings/holiday18date!=''">
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'20'"/>
							<xsl:with-param name="date" select="settings/holiday20date"/>
							<xsl:with-param name="name" select="settings/holiday20name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'21'"/>
							<xsl:with-param name="date" select="settings/holiday21date"/>
							<xsl:with-param name="name" select="settings/holiday21name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'22'"/>
							<xsl:with-param name="date" select="settings/holiday22date"/>
							<xsl:with-param name="name" select="settings/holiday22name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'23'"/>
							<xsl:with-param name="date" select="settings/holiday23date"/>
							<xsl:with-param name="name" select="settings/holiday23name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'24'"/>
							<xsl:with-param name="date" select="settings/holiday24date"/>
							<xsl:with-param name="name" select="settings/holiday24name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'25'"/>
							<xsl:with-param name="date" select="settings/holiday25date"/>
							<xsl:with-param name="name" select="settings/holiday25name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'26'"/>
							<xsl:with-param name="date" select="settings/holiday26date"/>
							<xsl:with-param name="name" select="settings/holiday26name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'27'"/>
							<xsl:with-param name="date" select="settings/holiday27date"/>
							<xsl:with-param name="name" select="settings/holiday27name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'28'"/>
							<xsl:with-param name="date" select="settings/holiday28date"/>
							<xsl:with-param name="name" select="settings/holiday28name"/>
						</xsl:call-template>
						<xsl:call-template name="holidaytemplate">
							<xsl:with-param name="num" select="'29'"/>
							<xsl:with-param name="date" select="settings/holiday29date"/>
							<xsl:with-param name="name" select="settings/holiday29name"/>
						</xsl:call-template>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</xsl:if>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/holidayinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

<xsl:template name="holidaytemplate">
	<xsl:param name="num" select="'0'"/>
	<xsl:param name="date" select="settings/holiday0date"/>
	<xsl:param name="name" select="settings/holiday0name"/>
	<tr>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/holiday"/>
		</td>
		<td align="left" class="t2">
			<input type="text" name="holiday{$num}date" id="holiday{$num}date" size="12" class="t2" value="{$date}"/>
<!--		<img src="./theme/{$theme}/icon/calendar.gif" style="cursor: pointer; border: 0px;" hspace="8" align="absmiddle">
				<xsl:attribute name="id">t_holiday<xsl:value-of select="$num"/>date</xsl:attribute>
			</img>
			<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
			<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
			<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>
			<script type="text/javascript">Calendar.setup({inputField:"holiday<xsl:value-of select="$num"/>date",ifFormat:"%m-%d",button:"t_holiday<xsl:value-of select="$num"/>date",singleClick:true});</script> -->
			<input type="text" name="holiday{$num}name" size="40" class="t2" value="{$name}"/>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
