<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer_left.xsl"/>

<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
		<style type="text/css">
			html, body {height: 98%; margin: 0; border: none; text-align: left; font-family: arial, helvetica, sans-serif;  font-size: 11px; color: #000066; white-space: nowrap;}
			#wrapper {height: 78%; background-color: #FFFFFF; align: left; padding-left: 2px; padding-top: 2px;}
		</style>
	</head>
<body>
	<table id="wrapper" height="100%" border="0" align="center" cellpadding="2" cellspacing="0" width="100">
		<tr>
			<td align="left" valign="top" width="100">
				<div id="left">
					<form enctype="multipart/form-data"    method="post" name="report">
						<table border="0" align="left" cellpadding="0" cellspacing="1" width="100%" bgcolor="FFFFFF">
							<tr>
								<td>
									<b><a href="left.php?module=settings&amp;main=frame" target="main"><xsl:value-of select="$lng/viewmain"/></a></b>
								</td>
							</tr>
							<tr>
								<td>
									<b><xsl:value-of select="$lng/admin"/></b>
									<ul>
										<li><b><a href="main.php?module=user&amp;function=create&amp;classification=3" target="main"><xsl:value-of select="$lng/createadmin"/></a></b></li>
										<li><a href="main.php?module=user&amp;function=search&amp;organisationid=1" target="main"><xsl:value-of select="$lng/viewadmin"/></a></li>
									</ul>
								</td>
							</tr>
							<tr>
								<td>
							<xsl:if test="settings">
									<b><xsl:value-of select="$lng/modulesettings"/></b>
									<ul>
									<xsl:for-each select="settings">
										<li>
											<a href="./{frame}.php?module={module}&amp;function={function}" target="{frame}">
												<xsl:value-of select="name"/>
											</a>
										</li>
									</xsl:for-each>
									</ul>
							</xsl:if>
							<xsl:if test="mainsettings">
									<b><xsl:value-of select="$lng/mainmodulesettings"/></b>
									<ul>
									<xsl:for-each select="mainsettings">
										<li>
											<a href="./{frame}.php?module={module}&amp;function={function}" target="{frame}">
												<xsl:value-of select="name"/>
											</a>
										</li>
									</xsl:for-each>
									</ul>
							</xsl:if>
									<b><xsl:value-of select="$lng/systemsettings"/></b>
									<ul>
										<xsl:variable name="mainlink" select="'./main.php?module=settings&amp;function=display&amp;display_type'"/>
										<li><a href="{$mainlink}=general" target="main"><xsl:value-of select="$lng/generalsettings"/></a></li>
										<li><a href="{$mainlink}=gui" target="main"><xsl:value-of select="$lng/guisettings"/></a></li>
										<li><a href="{$mainlink}=pop" target="main"><xsl:value-of select="$lng/popsettings"/></a></li>
										<li><a href="{$mainlink}=security" target="main"><xsl:value-of select="$lng/securitysettings"/></a></li>
										<li><a href="{$mainlink}=message" target="main"><xsl:value-of select="$lng/messagesettings"/></a></li>
										<li><a href="{$mainlink}=sms" target="main"><xsl:value-of select="$lng/smssettings"/></a></li>
										<li><a href="{$mainlink}=smtp" target="main"><xsl:value-of select="$lng/smtpsettings"/></a></li>
										<li><a href="{$mainlink}=time" target="main"><xsl:value-of select="$lng/timesettings"/></a></li>
										<li><a href="{$mainlink}=holiday" target="main"><xsl:value-of select="$lng/holidaysettings"/></a></li>
									</ul>
									<a href="./main.php?module=settings&amp;function=phpinfo" target="main"><xsl:value-of select="$lng/phpinfo"/></a>
								</td>
							</tr>
						</table>
					</form>
				</div>
			</td>
		</tr>
	</table>
	<xsl:call-template name="footer_left"/>
</body>
</html>
</xsl:template>
</xsl:stylesheet>