<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/module_name"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'settings'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td align="left" class="h t1" colspan="3">
								<b><xsl:value-of select="$lng/admin"/></b>
							</td>
						</tr>
						<tr>
							<td class="h2b t1">
								<a href="main.php?module=user&amp;function=create&amp;classification=3" target="main"><xsl:value-of select="$lng/createadmin"/></a>
							</td>
							<td class="h2c t1">
								<a href="main.php?module=user&amp;function=search&amp;organisationid=1" target="main"><xsl:value-of select="$lng/viewadmin"/></a>
							</td>
							<td class="h2c t1"><br/></td>
						</tr>
						<tr>
							<td colspan="3"><br/></td>
						</tr>
		<xsl:if test="settings">
						<tr>
							<td align="left" class="h t1" colspan="3">
								<b><xsl:value-of select="$lng/modulesettings"/></b>
							</td>
						</tr>
			<xsl:for-each select="settings[position() mod 3 = 1]">
						<tr>
				<xsl:for-each select=".|following-sibling::settings[position() &lt; 3]">
					<xsl:choose>
						<xsl:when test="position()=1">
							<td class="h2b t1">
								<a href="./{frame}.php?module={module}&amp;function={function}">
									<xsl:value-of select="name"/>
								</a>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td class="h2c t1">
								<a href="./{frame}.php?module={module}&amp;function={function}">
									<xsl:value-of select="name"/>
								</a>
							</td>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
						</tr>
			</xsl:for-each>
						<tr>
							<td colspan="3"><br/></td>
						</tr>
		</xsl:if>
		<xsl:if test="mainsettings">
						<tr>
							<td align="left" class="h t1" colspan="3">
								<b><xsl:value-of select="$lng/mainmodulesettings"/></b>
							</td>
						</tr>
			<xsl:for-each select="mainsettings[position() mod 3 = 1]">
						<tr>
				<xsl:for-each select=".|following-sibling::mainsettings[position() &lt; 3]">
					<xsl:choose>
						<xsl:when test="position()=1">
							<td class="h2b t1">
								<a href="./{frame}.php?module={module}&amp;function={function}">
									<xsl:value-of select="name"/>
								</a>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td class="h2c t1">
								<a href="./{frame}.php?module={module}&amp;function={function}">
									<xsl:value-of select="name"/>
								</a>
							</td>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
						</tr>
			</xsl:for-each>
						<tr>
							<td colspan="3"><br/></td>
						</tr>
		</xsl:if>
						<xsl:variable name="mainlink" select="'./main.php?module=settings&amp;function=display&amp;display_type'"/>
						<tr>
							<td align="left" class="h t1" colspan="3">
								<b><xsl:value-of select="$lng/systemsettings"/></b>
							</td>
						</tr>
						<tr>
							<td class="h2b t1">
								<a href="{$mainlink}=general" target="main"><xsl:value-of select="$lng/generalsettings"/></a>
							</td>
							<td class="h2c t1">
								<a href="{$mainlink}=gui" target="main"><xsl:value-of select="$lng/guisettings"/></a>
							</td>
							<td class="h2c t1">
								<a href="{$mainlink}=pop" target="main"><xsl:value-of select="$lng/popsettings"/></a>
							</td>
						</tr>
						<tr>
							<td class="h2b t1">
								<a href="{$mainlink}=security" target="main"><xsl:value-of select="$lng/securitysettings"/></a>
							</td>
							<td class="h2c t1">
								<a href="{$mainlink}=message" target="main"><xsl:value-of select="$lng/messagesettings"/></a>
							</td>
							<td class="h2c t1">
								<a href="{$mainlink}=sms" target="main"><xsl:value-of select="$lng/smssettings"/></a>
							</td>
						</tr>
						<tr>
							<td class="h2b t1">
								<a href="{$mainlink}=smtp" target="main"><xsl:value-of select="$lng/smtpsettings"/></a>
							</td>
							<td class="h2c t1">
								<a href="{$mainlink}=time" target="main"><xsl:value-of select="$lng/timesettings"/></a>
							</td>
							<td class="h2c t1">
								<a href="{$mainlink}=holiday" target="main"><xsl:value-of select="$lng/holidaysettings"/></a>
							</td>
						</tr>
						<tr>
							<td class="h2b t1">
								<a href="./main.php?module=settings&amp;function=phpinfo" target="main"><xsl:value-of select="$lng/phpinfo"/></a>
							</td>
							<td class="h2c t1" colspan="2"><br/></td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/selectsetting">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
