<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/changemessagetitle"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'settings'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="settings"/>
					<input type="hidden" name="function" value="display"/>
					<input type="hidden" name="display_type" value="message"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="updated='1'">
							<tr>
								<td colspan="2" class="t1">
									<xsl:value-of select="$lng/changedsuccess"/>	
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/messageschedulestatus"/>
							<xsl:with-param name="input_name" select="'messageschedulestatus'"/>
							<xsl:with-param name="input_value" select="settings/messageschedulestatus"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/messageschedulego"/>
							<xsl:with-param name="input_name" select="'messageschedulego'"/>
							<xsl:with-param name="input_value" select="settings/messageschedulego"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/messagescheduleattempts"/>
							</td>
							<td align="left" class="t2">
								<input name="messagescheduleattempts" value="{settings/messagescheduleattempts}" size="4" class="t2"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/messagescheduletime"/>
							</td>
							<td align="left" class="t2">
								<input name="messagescheduletime" value="{settings/messagescheduletime}" size="6" class="t2"/><xsl:value-of select="$lng/seconds"/>
							</td>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/messagechangeinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
