<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/changepoptitle"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'settings'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="settings"/>
					<input type="hidden" name="function" value="display"/>
					<input type="hidden" name="display_type" value="pop"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">						
						<tr>
							<td colspan="2" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/changedsuccess"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/popstatus"/>
							<xsl:with-param name="input_name" select="'popstatus'"/>
							<xsl:with-param name="input_value" select="settings/popstatus"/>
							<xsl:with-param name="true" select="$lng/active"/>
							<xsl:with-param name="false" select="$lng/inactive"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/popip"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="popserver" size="20" maxlenght="40" class="t2" value="{settings/popserver}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/popport"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="popport" size="4" maxlenght="40" class="t2" value="{settings/popport}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/poptenderusername"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="poptenderusername" size="25" maxlenght="40" class="t2" value="{settings/poptenderusername}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/poptenderpassword"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="poptenderpassword" size="25" maxlenght="40" class="t2" value="{settings/poptenderpassword}"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/popnotype"/>
							<xsl:with-param name="input_name" select="'popnotype'"/>
							<xsl:with-param name="input_value" select="settings/popnotype"/>
							<xsl:with-param name="true" select="$lng/active"/>
							<xsl:with-param name="false" select="$lng/inactive"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/poptest"/>
							</td>
							<td align="left" class="t2">
								<a href="./main.php?module=generic&amp;function=email" target="main"><xsl:value-of select="$lng/poptesthere"/></a>
							</td>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/popchangeinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
