<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/changesecuritytitle"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'settings'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="settings"/>
					<input type="hidden" name="function" value="display"/>
					<input type="hidden" name="display_type" value="security"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="updated='1'">
							<tr>
								<td colspan="2" class="t1">
									<xsl:value-of select="$lng/changedsuccess"/>								
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="password_renewed='1'">
							<tr>
								<td colspan="2" class="t1">
									<xsl:value-of select="$lng/userstostatustwo"/>								
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/errorfile"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="errorfile" size="20" maxlenght="40" class="t2" value="{settings/errorfile}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/erroremail"/>
							</td>
							<td align="left" class="t2">
								<select name="erroremail" class="t2">
									<option value="critical">
											<xsl:value-of select="$lng/critical"/>
									</option>
									<option value="serious">
											<xsl:if test="settings/erroremail='serious'">
												<xsl:attribute name="selected">selected</xsl:attribute>
											</xsl:if>
											<xsl:value-of select="$lng/serious"/>
									</option>
									<option value="all">
											<xsl:if test="settings/erroremail='all'">
												<xsl:attribute name="selected">selected</xsl:attribute>
											</xsl:if>
											<xsl:value-of select="$lng/all"/>
									</option>
									<option value="none">
											<xsl:if test="settings/erroremail='none'">
												<xsl:attribute name="selected">selected</xsl:attribute>
											</xsl:if>
											<xsl:value-of select="$lng/none"/>
									</option>
								</select>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/logstatus"/>
							<xsl:with-param name="input_name" select="'logstatus'"/>
							<xsl:with-param name="input_value" select="settings/logstatus"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/logfile"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="logfile" size="20" maxlenght="40" class="t2" value="{settings/logfile}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/logphp"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="logphp" size="20" maxlenght="40" class="t2" value="{settings/logphp}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/displaylogin"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="displaylogin" size="2" maxlenght="40" class="t2" value="{settings/displaylogin}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/displaylogs"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="displaylogs" size="2" maxlenght="40" class="t2" value="{settings/displaylogs}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/displaylimit"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="displaylimit" size="2" maxlenght="40" class="t2" value="{settings/displaylimit}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/passwordrenewal"/> 
							</td>
							<td align="left" class="t2">
								<input type="checkbox" name="passwordrenewal" class="t2"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/securityip_track"/>
							<xsl:with-param name="input_name" select="'securityip_track'"/>
							<xsl:with-param name="input_value" select="settings/securityip_track"/>
							<xsl:with-param name="true" select="$lng/enable"/>
							<xsl:with-param name="false" select="$lng/disable"/>
						</xsl:call-template>
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/securitycalldes"/> 
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/securitycall"/>
							<xsl:with-param name="input_name" select="'securitycall'"/>
							<xsl:with-param name="input_value" select="settings/securitycall"/>
							<xsl:with-param name="true" select="$lng/enable"/>
							<xsl:with-param name="false" select="$lng/disable"/>
						</xsl:call-template>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/securityip"/> 
							</td>
							<td align="left" class="t1">
								<input type="text" name="securityip0" size="18" maxlenght="40" class="t2 disabled" value="{settings/securityip0}" readonly="true" />
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/securityip"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="securityip1" size="18" maxlenght="40" class="t2" value="{settings/securityip1}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/securityip"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="securityip2" size="18" maxlenght="40" class="t2" value="{settings/securityip2}"/>
							</td>
						</tr>
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/apiauthenticate"/> 
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/apiauthenticate"/>
							<xsl:with-param name="input_name" select="'apiauthenticate'"/>
							<xsl:with-param name="input_value" select="settings/apiauthenticate"/>
							<xsl:with-param name="true" select="$lng/enable"/>
							<xsl:with-param name="false" select="$lng/disable"/>
						</xsl:call-template>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apiusername"/>[0]
							</td>
							<td align="left" class="t1">
								<input type="text" name="apiusername0" size="12" maxlenght="40" class="t2" value="{settings/apiusername0}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apipassword"/>[0]
							</td>
							<td align="left" class="t1">
								<input type="text" name="apipassword0" size="12" maxlenght="40" class="t2" value="{settings/apipassword0}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apiusername"/>[1]
							</td>
							<td align="left" class="t1">
								<input type="text" name="apiusername1" size="12" maxlenght="40" class="t2" value="{settings/apiusername1}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apipassword"/>[1]
							</td>
							<td align="left" class="t1">
								<input type="text" name="apipassword1" size="12" maxlenght="40" class="t2" value="{settings/apipassword1}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apiusername"/>[2]
							</td>
							<td align="left" class="t1">
								<input type="text" name="apiusername2" size="12" maxlenght="40" class="t2" value="{settings/apiusername2}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apipassword"/>[2]
							</td>
							<td align="left" class="t1">
								<input type="text" name="apipassword2" size="12" maxlenght="40" class="t2" value="{settings/apipassword2}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apiusername"/>[3]
							</td>
							<td align="left" class="t1">
								<input type="text" name="apiusername3" size="12" maxlenght="40" class="t2" value="{settings/apiusername3}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apipassword"/>[3]
							</td>
							<td align="left" class="t1">
								<input type="text" name="apipassword3" size="12" maxlenght="40" class="t2" value="{settings/apipassword3}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apiusername"/>[4]
							</td>
							<td align="left" class="t1">
								<input type="text" name="apiusername4" size="12" maxlenght="40" class="t2" value="{settings/apiusername4}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/apipassword"/>[4]
							</td>
							<td align="left" class="t1">
								<input type="text" name="apipassword4" size="12" maxlenght="40" class="t2" value="{settings/apipassword4}"/>
							</td>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/securityinst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
