<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="radio_true_false">
	<xsl:param name="setting_name" select="$lng/setting"/>
	<xsl:param name="input_name" select="''"/>
	<xsl:param name="input_value" select="''"/>
	<xsl:param name="true" select="$lng/true"/>
	<xsl:param name="false" select="$lng/false"/>
	<tr>
		<td class="t1">
			<xsl:value-of select="$setting_name"/>
		</td>
		<td class="t2">
			<input name="{$input_name}" value="TRUE" type="radio">
				<xsl:if test="$input_value='TRUE'">
					<xsl:attribute name="checked"/>
				</xsl:if>
			</input>
			<xsl:value-of select="$true"/>
			<input name="{$input_name}" value="FALSE" type="radio">
				<xsl:if test="$input_value='FALSE'">
					<xsl:attribute name="checked"/>
				</xsl:if>
			</input>
			<xsl:value-of select="$false"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="submit_button">
	<xsl:param name="readonly" select="'0'"/>
	<tr>
	<xsl:choose>
		<xsl:when test="$readonly='1' or $readonly='yes'">
			<td align="right" colspan="2" class="e">
				<xsl:value-of select="$lng/readonlymessage"/>	
			</td>
		</xsl:when>
		<xsl:otherwise>
			<td align="right" colspan="2">
				<input type="submit" name="action" class="t2" >
					<xsl:attribute name="value">
						<xsl:value-of select="$lng/submit"/>
					</xsl:attribute>
				</input>
			</td>
		</xsl:otherwise>
	</xsl:choose>
	</tr>
</xsl:template>

</xsl:stylesheet>