<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/countries.xsl"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/changesmstitle"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'settings'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="settings"/>
					<input type="hidden" name="function" value="display"/>
					<input type="hidden" name="display_type" value="sms"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="updated='1'">
							<tr>
								<td colspan="2" class="t1">
									<xsl:value-of select="$lng/changedsuccess"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="sentmessage='1'">
							<tr>
								<td colspan="2" class="t1">
									<xsl:value-of select="$lng/sentmessage"/>	
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/smsstatus"/>
							<xsl:with-param name="input_name" select="'smsstatus'"/>
							<xsl:with-param name="input_value" select="settings/smsstatus"/>
							<xsl:with-param name="true" select="$lng/enable"/>
							<xsl:with-param name="false" select="$lng/disable"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smscode"/>
							</td>
							<td align="left" class="t2">
								<xsl:call-template name="countries">
									<xsl:with-param name="selectname" select="'smscode'"/>
									<xsl:with-param name="message" select="$lng/dialcode"/>
									<xsl:with-param name="optionvalue" select="'dialcode'"/>
									<xsl:with-param name="optioncontent" select="'all'"/>
									<xsl:with-param name="optionselected" select="settings/smscode"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smsapiid"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smsapi_id" size="8" maxlenght="40" class="t2" value="{settings/smsapi_id}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smsuser"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smsuser" size="15" maxlenght="40" class="t2" value="{settings/smsuser}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smspassword"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smspassword" size="15" maxlenght="40" class="t2" value="{settings/smspassword}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smsurlsend"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smsurlsend" size="40" maxlenght="40" class="t2" value="{settings/smsurlsend}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smsreceipt"/>
							</td>
							<td align="left" class="t2">
								<input name="smsreceipt" value="FALSE" type="radio">
									<xsl:if test="settings/smsreceipt='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/disable"/>
								<input name="smsreceipt" value="query" type="radio">
									<xsl:if test="settings/smsreceipt='query'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/querymode"/>
								<input name="smsreceipt" value="callback" type="radio">
									<xsl:if test="settings/smsreceipt='callback'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/callbackmode"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smstest"/>
							</td>
							<td align="left" class="t2">
								<input type="checkbox" name="smstest" size="20" class="t2"/>
							</td>
						</tr>
					<xsl:if test="balance">
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/credits"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="balance"/>
							</td>
						</tr>
					</xsl:if>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">Clickatell SMS gateway</div>
				<div id="right_content">
					<xsl:for-each select="$lng/smsprovider">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
					<a href="http://www.clickatell.com/central/campaigns/redir.php?cid=1927" target="blank">
					<b><xsl:value-of select="$lng/clickatell"/></b>
					<br/>
					<img src="./theme/{$theme}/img/clickatell.gif" border="0" alt="Clickatell - Mobile Messaging"/>
					</a>
				</div>
				<div id="right_header"><xsl:value-of select="$lng/changesettings"/></div>
				<div id="right_content">
					<xsl:for-each select="$lng/smsinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
