<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/changesmtptitle"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'settings'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="settings"/>
					<input type="hidden" name="function" value="display"/>
					<input type="hidden" name="display_type" value="smtp"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="updated='1'">
							<tr>
								<td colspan="2" class="t1">
									<xsl:value-of select="$lng/changedsuccess"/>	
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="sentmessage='1'">
							<tr>
								<td colspan="2" class="t1">
									<xsl:value-of select="$lng/sentmessage"/>	
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/smtpstatus"/>
							<xsl:with-param name="input_name" select="'smtpstatus'"/>
							<xsl:with-param name="input_value" select="settings/smtpstatus"/>
							<xsl:with-param name="true" select="$lng/active"/>
							<xsl:with-param name="false" select="$lng/inactive"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpip"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtpserver" size="20" maxlenght="40" class="t2" value="{settings/smtpserver}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpport"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtpport" size="4" maxlenght="40" class="t2" value="{settings/smtpport}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpencoding"/>
							</td>
							<td align="left" class="t2">
								<select name="smtpencoding" class="t2">
									<option value="7bit">
										<xsl:if test="settings/smtpencoding='7bit'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="'7bit'"/>
									</option>
									<option value="8bit">
										<xsl:if test="settings/smtpencoding='8bit'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="'8bit'"/>
									</option>
									<option value="quoted-printable">
										<xsl:if test="settings/smtpencoding='quoted-printable'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="'quoted-printable'"/>
									</option>
									<option value="base64">
										<xsl:if test="settings/smtpencoding='base64'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="'base64'"/>
									</option>
								</select>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/smtpreceiptimgenable"/>
							<xsl:with-param name="input_name" select="'smtpreceiptimgenable'"/>
							<xsl:with-param name="input_value" select="settings/smtpreceiptimgenable"/>
							<xsl:with-param name="true" select="$lng/active"/>
							<xsl:with-param name="false" select="$lng/inactive"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtphelo"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtphelo" size="20" class="t2" value="{settings/smtphelo}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtptest"/>
							</td>
							<td align="left" class="t2">
								<input type="checkbox" name="smtptest" size="20" class="t2"/>
							</td>
						</tr>
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/auth"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/smtpauth"/>
							<xsl:with-param name="input_name" select="'smtpauth'"/>
							<xsl:with-param name="input_value" select="settings/smtpauth"/>
							<xsl:with-param name="true" select="$lng/active"/>
							<xsl:with-param name="false" select="$lng/inactive"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpuser"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtpuser" size="20" class="t2" value="{settings/smtpuser}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtppassword"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtppassword" size="20" class="t2" value="{settings/smtppassword}"/>
							</td>
						</tr>
						<tr>
							<td align="right" colspan="2">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/changesettings"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/mail"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpfrom"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtpfrom" size="25" maxlenght="40" class="t2" value="{settings/smtpfrom}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpsupportemail"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtpsupportemail" size="25" maxlenght="40" class="t2" value="{settings/smtpsupportemail}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpsupportpriority"/>
							</td>
							<td align="left" class="t2">
								<input name="smtpsupportpriority" value="TRUE" type="radio">
									<xsl:if test="settings/smtpsupportpriority='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/high"/>
								<input name="smtpsupportpriority" value="FALSE" type="radio">
									<xsl:if test="settings/smtpsupportpriority='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/normal"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtptenderemail"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtptenderemail" size="25" maxlenght="40" class="t2" value="{settings/smtptenderemail}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtptenderpriority"/>
							</td>
							<td align="left" class="t2">
								<input name="smtptenderpriority" value="TRUE" type="radio">
									<xsl:if test="settings/smtptenderpriority='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/high"/>
								<input name="smtptenderpriority" value="FALSE" type="radio">
									<xsl:if test="settings/smtptenderpriority='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/normal"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1" valign="top">
								<xsl:value-of select="$lng/smtpmessage"/>
							</td>
							<td align="left" class="t2">
								<textarea name="smtpmessage" rows="5" cols="50" class="t2">
									<xsl:value-of select="settings/smtpmessage"/>
								</textarea>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1" valign="top">
								<xsl:value-of select="$lng/smtpdisclaimer"/>
							</td>
							<td align="left" class="t2">
								<textarea name="smtpdisclaimer" rows="5" cols="50" class="t2">
									<xsl:value-of select="settings/smtpdisclaimer"/>
								</textarea>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1" valign="top">
								<xsl:value-of select="$lng/smtpsourceforge"/>
							</td>
							<td align="left" class="t2">
								<input name="smtpsourceforge" value="TRUE" type="radio">
									<xsl:if test="settings/smtpsourceforge='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/enable"/>
								<input name="smtpsourceforge" value="FALSE" type="radio">
									<xsl:if test="settings/smtpsourceforge='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/disable"/>
							</td>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/backup"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/smtpblob"/>
							<xsl:with-param name="input_name" select="'smtpblob'"/>
							<xsl:with-param name="input_value" select="settings/smtpblob"/>
							<xsl:with-param name="true" select="$lng/enable"/>
							<xsl:with-param name="false" select="$lng/disable"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/smtpbackupstatus"/>
							<xsl:with-param name="input_name" select="'smtpbackupstatus'"/>
							<xsl:with-param name="input_value" select="settings/smtpbackupstatus"/>
							<xsl:with-param name="true" select="$lng/enable"/>
							<xsl:with-param name="false" select="$lng/disable"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpbackupemail"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtpbackupemail" size="25" maxlenght="40" class="t2" value="{settings/smtpbackupemail}"/>
							</td>
						</tr>
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/postmasteremail"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpkeyword"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtpkeyword0" size="25" maxlenght="40" class="t2" value="{settings/smtpkeyword0}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpkeyword"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtpkeyword2" size="25" maxlenght="40" class="t2" value="{settings/smtpkeyword2}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/smtpkeyword"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="smtpkeyword1" size="25" maxlenght="40" class="t2" value="{settings/smtpkeyword1}"/>
							</td>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/smtpchangeinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
