<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/changetimetitle"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'settings'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="settings"/>
					<input type="hidden" name="function" value="display"/>
					<input type="hidden" name="display_type" value="time"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="2" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/changedsuccess"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/timeformat"/>
							</td>
							<td align="left" class="t2">
								<select class="t2" name="timeformatselector" onchange="changetimeformat()">
									<option>--</option>
									<option value="H:i:s">23:59:59</option>
									<option value="H:i">23:59</option>
									<option value="g:ia">11:59pm</option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1"></td>
							<td align="left" class="t2">
								<input type="text" name="timeformat" size="12" maxlenght="40" class="t2" value="{settings/timeformat}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/dateformat"/>
							</td>
							<td align="left" class="t2">
								<select class="t2" name="dateformatselector" onchange="changedateformat()">
									<option>--</option>
									<option value="Y-m-d">1999-12-31</option>
									<option value="F d Y">December 31 1999</option>
									<option value="m-d-Y">12-31-1999</option>
									<option value="d F Y">31 December 1999</option>
									<option value="d-m-Y">31-12-1999</option>
									<option value="D d M Y">Mon 31 Dec 1999</option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1"></td>
							<td align="left" class="t2">
								<input type="text" name="dateformat" size="12" maxlenght="40" class="t2" value="{settings/dateformat}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/localdisplay"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="localdisplay" size="4" maxlenght="40" class="t2" value="{settings/localdisplay}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/localduration"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="localduration" size="5" maxlenght="40" class="t2" value="{settings/localduration}"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/seconds"/>
							</td>
						</tr>
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/businesshours"/> 
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/day0"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="timeopen0" size="2" maxlenght="2" class="t2" value="{settings/timeopen0}"/> :00
								<input type="text" name="timeclose0" size="2" maxlenght="2" class="t2" value="{settings/timeclose0}"/> :00
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/day1"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="timeopen1" size="2" maxlenght="2" class="t2" value="{settings/timeopen1}"/> :00
								<input type="text" name="timeclose1" size="2" maxlenght="2" class="t2" value="{settings/timeclose1}"/> :00
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/day2"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="timeopen2" size="2" maxlenght="2" class="t2" value="{settings/timeopen2}"/> :00
								<input type="text" name="timeclose2" size="2" maxlenght="2" class="t2" value="{settings/timeclose2}"/> :00
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/day3"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="timeopen3" size="2" maxlenght="2" class="t2" value="{settings/timeopen3}"/> :00
								<input type="text" name="timeclose3" size="2" maxlenght="2" class="t2" value="{settings/timeclose3}"/> :00
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/day4"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="timeopen4" size="2" maxlenght="2" class="t2" value="{settings/timeopen4}"/> :00
								<input type="text" name="timeclose4" size="2" maxlenght="2" class="t2" value="{settings/timeclose4}"/> :00
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/day5"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="timeopen5" size="2" maxlenght="2" class="t2" value="{settings/timeopen5}"/> :00
								<input type="text" name="timeclose5" size="2" maxlenght="2" class="t2" value="{settings/timeclose5}"/> :00
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/day6"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="timeopen6" size="2" maxlenght="2" class="t2" value="{settings/timeopen6}"/> :00
								<input type="text" name="timeclose6" size="2" maxlenght="2" class="t2" value="{settings/timeclose6}"/> :00
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/lunchbreak"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="timelunchstarthour" size="1" maxlenght="2" class="t2" value="{settings/timelunchstarthour}"/>:
								<input type="text" name="timelunchstartmin" size="1" maxlenght="2" class="t2" value="{settings/timelunchstartmin}"/>
								<xsl:value-of select="' - '"/>
								<input type="text" name="timelunchendhour" size="1" maxlenght="2" class="t2" value="{settings/timelunchendhour}"/>:
								<input type="text" name="timelunchendmin" size="1" maxlenght="2" class="t2" value="{settings/timelunchendmin}"/>
							</td>
						</tr>
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/sessionvalid"/> 
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/loginagent"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="loginagent" size="4" maxlenght="40" class="t2" value="{settings/loginagent}"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/seconds"/> 
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/loginsubscriber"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="loginsubscriber" size="4" maxlenght="40" class="t2" value="{settings/loginsubscriber}"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/seconds"/> 
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/loginadmin"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="loginadmin" size="4" maxlenght="40" class="t2" value="{settings/loginadmin}"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/seconds"/> 
							</td>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/timeinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		document.onload = timeformat();
		function changetimeformat() {
			document.report.timeformat.value = document.report.timeformatselector.value;
		}

		function changedateformat() {
			document.report.dateformat.value = document.report.dateformatselector.value;
		}
		
		function timeformat() {
			if ((document.report.timelunchstartmin.value.length &lt; 2) &amp;&amp; (document.report.timelunchstartmin.value &lt; 10))
				document.report.timelunchstartmin.value = '0' + document.report.timelunchstartmin.value;
			if ((document.report.timelunchendmin.value.length &lt; 2) &amp;&amp; (document.report.timelunchendmin.value &lt; 10))
				document.report.timelunchendmin.value = '0' + document.report.timelunchendmin.value;				
		}
		
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
