<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+
/**
* Generate statistics
* @package TenderSystem
* @subpackage statistics
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'organisationid'	=> array(),
	'startdate'			=> array(),
	'enddate'			=> array(),
	'charttype'			=> array(),
	'usersid'			=> array(),
	'yaxis'				=> array(),
	'xaxis'				=> array()
);
get_request($fields_request,$info,$error,$cfg);
// user details to load with error codes if missing
$fields  = array(
	'organisationid'	=> "",
	'startdate'			=> "",
	'enddate'			=> "",
	'charttype'			=> "",
	'usersid'			=> "",
	'yaxis'				=> "",
	'xaxis'				=> ""
);
$params = array(
	'module'	=> 'statistics',
	'function'	=> 'generate',
	'info'		=> $info 
);
$cfg['api_request'] = TRUE;
// send the message to app
$xml = send_message($params,$cfg);
$coded_data = event_parser('<coded_data>','</coded_data>',$xml);
$coded_legend = event_parser('<coded_legend>','</coded_legend>',$xml);
$x_axis = event_parser('<xaxis>','</xaxis>',$xml);
$y_axis = event_parser('<yaxis>','</yaxis>',$xml);
$title = event_parser('<title>','</title>',$xml);
$file_format = event_parser('<file_format>','</file_format>',$xml);
$data = unserialize(base64_decode($coded_data));
$legend = unserialize(base64_decode($coded_legend));
//Include the code
require(getcwd().'/modules/statistics/phplot/phplot.php');
// get the max
foreach($data as $value) {
	foreach($value as $key1 => $value1) {
		if(is_numeric($value1)) {
			$values[] = $value1;
		}
	}
}
$max = max($values);
//Define the object
$graph =& new PHPlot();
// check for data
if(!$data) {
	$data = "No statistics to display.";
}
if(!isset($info['charttype'])) {
	$info['charttype'] = "bars";	
}
$graph->SetPlotType($info['charttype']);
if($info['charttype'] != "pie") {
	// not pie chart
	$graph->SetTitle($title);
	$graph->SetXTitle($x_axis);
	$graph->SetXLabelAngle(90);
	$graph->SetYTitle($y_axis);
	$graph->SetFileFormat($file_format);
	$graph->SetDataType("text-data");
	$graph->SetNumXTicks(1);
	// set the increment
	if($max < 10) {
		$graph->SetYTickIncrement(1);
	} else {
		$inc = intval($max/10) + 1;
		$graph->SetYTickIncrement($inc);
	}
	if($legend) {
		$graph->SetLegend($legend);
	}
	$graph->SetDataValues($data);
} else {
	// pie chart
	foreach($data as $key => $value) {
		foreach($value as $key1 => $value1) {
			$array[$key1][] = $value1;
		}
	}
	if($legend) {
		$graph->SetXTitle($legend[0]);	
	} else {
		$graph->SetXTitle($y_axis);
	}
	reset($array);
	$graph->SetLegend(current($array));
	$tmp = next($array) ;
	array_unshift($tmp,"0");
	$new_data = array($tmp);
	$graph->SetDataValues($new_data);
}
// draw it
$graph->DrawGraph();             
?>