<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<link rel="stylesheet" type="text/css" media="all" href="./theme/{$theme}/style_calendar.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/statistics"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'statistics'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="statistics"/>
					<input type="hidden" name="function" value="organisation"/>
					<input type="hidden" name="function" value="{organisationid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td class="h t1" colspan="4">
								<xsl:value-of select="$lng/statisticsinfo"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/startdate"/>
							</td>
							<td class="t2">
								<input type="text" name="startdate" id="startdate" value="{daysago3}" class="t2" size="10" maxlength="10"/>
								<xsl:value-of select="' '"/>
								<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_startdate" style="cursor: pointer; border: 0px;" alt="Date selector" />
							</td>
							<td class="t1">
								<xsl:value-of select="$lng/charttype"/>
							</td>
							<td class="t2">
								<select name="charttype" class="t2">
									<option value="bars"><xsl:value-of select="$lng/bars"/></option>
									<option value="pie"><xsl:value-of select="$lng/pie"/></option>
									<option value="lines"><xsl:value-of select="$lng/lines"/></option>
									<option value="linepoints"><xsl:value-of select="$lng/linepoints"/></option>
									<option value="area"><xsl:value-of select="$lng/area"/></option>
									<option value="points"><xsl:value-of select="$lng/points"/></option>
									<option value="thinbarline"><xsl:value-of select="$lng/thinbarline"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/enddate"/>
							</td>
							<td class="t2">
								<input type="text" name="enddate" id="enddate" value="{today}" class="t2" size="10" maxlength="10"/>
								<xsl:value-of select="' '"/>
								<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_enddate" style="cursor: pointer; border: 0px;" alt="Date selector" />
							</td>
							<td class="t1">
								<xsl:value-of select="$lng/tendersof"/>
							</td>
							<td class="t2">
								<select name="usersid" class="t2">
									<option value="0"><xsl:value-of select="$lng/allsubscriber"/></option>
									<xsl:for-each select="users">
										<option value="{usersid}"><xsl:value-of select="name"/><xsl:value-of select="' '"/><xsl:value-of select="surname"/></option>
									</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/yaxis"/>
							</td>
							<td class="t2">
								<select name="yaxis" class="t2" onchange="update_xaxis()">
									<option value="tender"><xsl:value-of select="$lng/tender"/></option>
									<option value="tenderitem"><xsl:value-of select="$lng/tenderitem"/></option>
									<option value="conversion_rate"><xsl:value-of select="$lng/conversion_rate"/></option>
									<option value="average_rfq"><xsl:value-of select="$lng/average_rfq"/></option>
									<option value="send"><xsl:value-of select="$lng/send"/></option>
								</select>
							</td>
							<td class="t1">
								<xsl:value-of select="$lng/xaxis"/>
							</td>
							<td class="t2">
								<select name="xaxis" class="t2"></select>
							</td>
						</tr>
						<tr>
							<td class="t2" colspan="4" align="right">
								<img src="./theme/{$theme}/icon/statistics.gif" alt="{$lng/statistics}" border="0" onclick="changeSRC()"/>
							</td>
						</tr>
						<tr>
							<td class="t2" colspan="4" align="center">
								<img src="./main.php?module=statistics&amp;function=generate&amp;organisationid={organisationid}" id="stats_img" alt="{$lng/statistics}" border="0"/>
							</td>
						</tr>
						<tr>
							<td class="t2" colspan="4" align="right">
								<a href="http://sourceforge.net/projects/phplot">Generated By Phplot</a>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>

	<script type="text/javascript">
		Calendar.setup({inputField:"startdate",ifFormat:"%Y-%m-%d",button:"trigger_startdate",singleClick:true});
		Calendar.setup({inputField:"enddate",ifFormat:"%Y-%m-%d",button:"trigger_enddate",singleClick:true});
		
		function changeSRC() {
			var variables = "&amp;charttype="+document.report.charttype.value;
			variables += "&amp;startdate="+document.report.startdate.value;
			variables += "&amp;enddate="+document.report.enddate.value;
			variables += "&amp;usersid="+document.report.usersid.value;
			variables += "&amp;yaxis="+document.report.yaxis.value;
			variables += "&amp;xaxis="+document.report.xaxis.value;
			<xsl:if test="organisationid and organisationid!=''">
				variables += "&amp;organisationid=<xsl:value-of select="organisationid"/>";
			</xsl:if>
			document.report.stats_img.src = "./main.php?module=statistics&amp;function=generate"+variables;	
		}
		function update_xaxis() {	
			var y_value = document.report.yaxis.value;
			var xaxisSelect = document.report.xaxis;
			var xaxisOptions = xaxisSelect.options;
			var counter = 0;
			xaxisSelect.length = 0;
			if (y_value == "tender"  || y_value == "tenderitem" || y_value == "send"  || y_value == "average_rfq" || y_value == "conversion_rate") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/monthly"/>","monthly");
			}
			if (y_value == "tender"  || y_value == "tenderitem" || y_value == "send" || y_value == "average_rfq") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/daily"/>","daily");
			}
			if (y_value == "tender"  || y_value == "tenderitem" || y_value == "send" || y_value == "average_rfq") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/hourly"/>","hourly");
			}
			if (y_value == "tender" || y_value == "tenderitem" || y_value == "send" || y_value == "average_rfq" || y_value == "conversion_rate") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/subscriber"/>","subscriber");
			}
			if (y_value == "tender" || y_value == "tenderitem" || y_value == "send" || y_value == "average_rfq" || y_value == "conversion_rate") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/branch"/>","branch");
			}
			<xsl:choose>
				<xsl:when test="organisationid and organisationid!=''"/>
				<xsl:otherwise>
					if (y_value == "tender" || y_value == "tenderitem" || y_value == "send" || y_value == "average_rfq" || y_value == "conversion_rate") {
						xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/organisation"/>","organisation");
					}
				</xsl:otherwise>
			</xsl:choose>
			if (y_value == "tender") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/transport"/>","transport");
			}
			if (y_value == "tender" || y_value == "tenderitem" || y_value == "average_rfq"  || y_value == "conversion_rate") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/state"/>","state");
			}
			if (y_value == "tender" || y_value == "tenderitem" || y_value == "average_rfq"  || y_value == "conversion_rate") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/area"/>","area");
			}
			if (y_value == "tenderitem" || y_value == "average_rfq" || y_value == "conversion_rate") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/category"/>","category");
			}
			if (y_value == "tenderitem" || y_value == "average_rfq" || y_value == "conversion_rate") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/category_sub"/>","category_sub");
			}
			if (y_value == "tenderitem" || y_value == "average_rfq" || y_value == "conversion_rate") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/brand"/>","brand");
			}
			if (y_value == "tenderitem" || y_value == "send" || y_value == "conversion_rate") {
				xaxisOptions[counter++] = new Option("<xsl:value-of select="$lng/supplier"/>","supplier");
			}
		}		
		update_xaxis();
		</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
