<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/statisticssettings"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'statistics'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="statistics"/>
					<input type="hidden" name="function" value="settings"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="updated='1'">
						<tr>
							<td colspan="4" class="t1">
								<xsl:value-of select="$lng/changedsuccess"/>
							</td>
						</tr>
						</xsl:if>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/statisticsenable"/>
							<xsl:with-param name="input_name" select="'statisticsenable'"/>
							<xsl:with-param name="input_value" select="settings/statisticsenable"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/statisticsimage"/>
							</td>
							<td align="left" class="t2">
								<input name="statisticsimage" value="png" type="radio">
									<xsl:if test="settings/statisticsimage='png'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/png"/>
								<input name="statisticsimage" value="gif" type="radio">
									<xsl:if test="settings/statisticsimage='gif'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/gif"/>
								<input name="statisticsimage" value="jpg" type="radio">
									<xsl:if test="settings/statisticsimage='jpg'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/jpg"/>
							</td>
						</tr>
						<tr>
							<td align="right" colspan="2">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/instruction">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>
	
<xsl:template name="radio_true_false">
	<xsl:param name="setting_name" select="$lng/setting"/>
	<xsl:param name="input_name" select="''"/>
	<xsl:param name="input_value" select="''"/>
	<xsl:param name="true" select="$lng/true"/>
	<xsl:param name="false" select="$lng/false"/>
	<tr>
		<td align="left" class="t1">
			<xsl:value-of select="$setting_name"/>
		</td>
		<td align="left" class="t2">
			<input name="{$input_name}" value="TRUE" type="radio">
				<xsl:if test="$input_value='TRUE'">
					<xsl:attribute name="checked"/>
				</xsl:if>
			</input>
			<xsl:value-of select="$true"/>
			<input name="{$input_name}" value="FALSE" type="radio">
				<xsl:if test="$input_value='FALSE'">
					<xsl:attribute name="checked"/>
				</xsl:if>
			</input>
			<xsl:value-of select="$false"/>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
