<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Module loader
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

if(!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	xml_generator("tender","error","e54",$params,$cfg);
}
// field request errors and type
// 1002 - Organisation ID must be a number
$fields_request = array (
	'additem'			=> array(),
	'organisationid'	=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"1002"),
	'upload'			=> array()		
);
if(!get_request($fields_request,$action,$error,$cfg)) {
	// display error
	xml_generator("tender","error",$error,$params,$cfg);
}
if($action['upload']) {
	$organisationid = $action['organisationid'];
	$file = $_FILES['file'];
	if ($file['name']) {
		// upload the file
		$upload_dest = upload_file($file,"tender",$cfg);
		// send to the app
		if (is_string($upload_dest)) {
			// read the excel spreadsheet
			$spreadsheet = read_excel($upload_dest,$cfg);
			$params = array(
				'module'			=> 'tender',
				'function'			=> 'add_item',
				'upload'			=> FALSE,
				'organisationid'	=> $organisationid
			);
			foreach($spreadsheet as $row => $values) {
				foreach($values as $col => $value) {
					if (!$value) {
						continue;
					}
					if($col == "0") {
						$params['insert'][$row]['category'] = $value;
					} elseif ($col =="1") {
						$params['insert'][$row]['category_sub'] = $value;
					} elseif ($col =="2") {
						$params['insert'][$row]['brand'] = $value;
					} elseif ($col =="3") {
						$params['insert'][$row]['model'] = $value;
					} elseif ($col =="4") {
						$params['insert'][$row]['description'] = $value;
					} elseif ($col =="5") {
						$params['insert'][$row]['stock'] = $value;
					} elseif ($col =="6") {
						$params['insert'][$row]['price'] = sprintf("%.2f",$value);
					}
				}
			}
			// send the message to app
			send_message($params,$cfg);
		} else {
			// display error
			xml_generator("tender","error",$upload_dest['error'],$params,$cfg);
		}
	} else {
		$params = array(
				'module'			=> 'tender',
				'function'			=> 'add_item',
				'upload'			=> TRUE,
				'organisationid'	=> $organisationid
		);
		// field request errors and type 
		// 1026 - Missing Sub Category ID
		// 1044 - Missing Brand
		// 1045 - Missing Model
		// 1046 - Missing Description
		// 1080 - Missing stock value
		// 1081 - Missing Price
		// 1082 - Missing Valid Until
		$fields_request = array (
			'itembrand'				=> array("1044"),
			'itemmodel'				=> array("1045"),
			'itemsubcategory'		=> array("1026"),
			'itemdescription'		=> array("1046"),
			'itemstock'				=> array("1080"),
			'itemprice'				=> array("1081"),
			'validuntil_all'			=> array("1082"),
			'ignoreitem'			=> array()				
		);
		get_request($fields_request,$info,$error,$cfg);
		$ignoreitem = $info['ignoreitem'];
		foreach($info['itembrand'] as $key => $value) {
			if(!$ignoreitem[$key]){
				// item info
				$item['supplier_id']  = $organisationid;
				$item['category_sub'] = $info['itemsubcategory'][$key];
				$item['brand'] = $info['itembrand'][$key];
				$item['model'] = $info['itemmodel'][$key];
				$item['description'] = $info['itemdescription'][$key];
				$item['stock'] = $info['itemstock'][$key];
				$item['valid_until'] = $info['validuntil_all'];
				$item['price'] = $info['itemprice'][$key];
				$item['status'] = "1";
				if($item['price']) {
					$params['insert'][] = $item;
				}
			}
		}
		if($error) {
			$params['error'] = $error;
		}
		// send the message to app
		send_message($params,$cfg);
	}
}elseif($action['additem']) {
	$organisationid = $action['organisationid'];
	// field request errors and type 
	// 1025 - Sub Category ID must be a number
	// 1026 - Missing Sub Category ID
	// 1044 - Missing Brand
	// 1045 - Missing Model
	// 1046 - Missing Description
	// 1080 - Missing stock value
	// 1081 - Missing Price
	// 1082 - Missing Valid until
	// 1083 - Stock must be number
	// 1084 - Price must be number
	// 1085 - Valid until must be date
	$fields_request = array (
		'itembrand'				=> array("1044"),
		'itemmodel'				=> array("1045"),
		'itemsubcategory'		=> array("1026",	REQUEST_NUMBER,	FORMAT_NONE,	"1025"),
		'itemdescription'		=> array("1046"),
		'itemstock'				=> array("1080",	REQUEST_NUMBER,	FORMAT_NONE,	"e70"),
		'itemprice'				=> array("1081",	REQUEST_MONEY,	FORMAT_NONE,	"e69"),
		'validuntil'			=> array("1082",	REQUEST_DATE,	FORMAT_NONE,	"e71")		
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		// item info
		$item[0]['supplier_id'] = $organisationid;
		$item[0]['category_sub'] = $info['itemsubcategory'];
		$item[0]['brand'] = $info['itembrand'];
		$item[0]['model'] = $info['itemmodel'];
		$item[0]['description'] = $info['itemdescription'];
		$item[0]['stock'] = $info['itemstock'];
		$item[0]['valid_until'] = $info['validuntil'];
		$item[0]['price'] = $info['itemprice'];
		$item[0]['status'] = "1";
		$insert[] = $item;
		$params = array(
			'module'			=> 'tender',
			'function'			=> 'add_item',
			'organisationid'	=> $organisationid,
			'upload'			=> TRUE,
			'insert'			=> $item
		);
		// send the message to app
		send_message($params,$cfg);
	} else {
		$currentinfo[0] = $info;
		$params = array(
			'module'			=> 'tender',
			'function'			=> 'add_item',
			'error'				=> $error,
			'organisationid'	=> $organisationid,
			'currentinfo'		=> $currentinfo
		);
		// send the message to app
		send_message($params,$cfg);
	}
} else {
	$params = array(
		'module'			=> 'tender',
		'function'			=> 'add_item',
		'organisationid'	=> $action['organisationid']
	);
	// send the message to app
	send_message($params,$cfg);
}
?>