<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Add quote
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

if(!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	xml_generator("tender","error","e54",$params,$cfg);
}
// field request errors and type 
$fields_request = array (
	'submit'	=> array()
);
get_request($fields_request,$action,$error,$cfg);
if ($action['submit']) {
	// field request errors and type 
	$fields_request = array (
		'usersid'			=> array("e49",	REQUEST_NUMBER,	FORMAT_NONE,	"e50"),
		'noquote'			=> array(),
		'ignore'			=> array(),
		'brand'				=> array(),
		'model'				=> array(),
		'description'		=> array(),
		'stock'				=> array(),
		'price'				=> array(),
		'valid'				=> array(),
		'tender'			=> array(),
		'category_subname'	=> array(),
		'classification'	=> array()
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		// set parameters
		$params = array(
			'module'	=> 'tender',
			'function'	=> 'add_quote',
			'usersid'	=> $info['usersid']
		);
		// loop through all items
		foreach($info['brand'] as $key => $value) {
			if(!$info['ignore'][$key]) {
				$item['id'] = $key;
				$item['tender'] = $info['tender'][$key];
				$item['brand'] = $info['brand'][$key];
				$item['model'] = $info['model'][$key];
				$item['description'] = $info['description'][$key];
				$item['stock'] = $info['stock'][$key];
				$item['classification'] = $info['classification'][$key];
				$item['valid'] = $info['valid'][$key];
				$item['category_subname'] = $info['category_subname'][$key];
				if(!$info['noquote'][$key]) {
					$item['price'] = $info['price'][$key];
				} else {
					$item['price'] = "0.00nq";
				}
				$params['item'][] = $item;
				unset($item);
			}
		}
		// loop through attachemts
		if($_FILES['file']) {
			// name
			foreach($_FILES['file']['name'] as $key => $value) {
				$files[$key]['name'] = $value;
			}
			// type
			foreach($_FILES['file']['type'] as $key => $value) {
				$files[$key]['classification'] = $value;
			}
			// error
			foreach($_FILES['file']['error'] as $key => $value) {
				$files[$key]['error'] = $value;
			}
			// size
			foreach($_FILES['file']['size'] as $key => $value) {
				$files[$key]['size'] = $value;
			}
			// tmp_name
			foreach($_FILES['file']['tmp_name'] as $key => $value) {
				$files[$key]['tmp_name'] = $value;			
			}
			// upload the file
			foreach($files as $key => $value) {
				if(!$value['error'] && !$info['ignore'][$key]) {
					$upload_dest = file_upload($value,"quote",$cfg);
					$value['content'] = base64_encode(file_get_contents($upload_dest));
					$params['file'][$key] = $value;
				}	
			}
		}
		// send the message to app
		send_message($params,$cfg);
	} else {
		// error
		xml_generator("tender","error",$errors,$params,$cfg);
	}
} else {
	// field request errors and type 
	$fields_request = array (
		'usersid'			=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e50"),
		'tenderitem'		=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e50"),
		'tenderid'			=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e44")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		$params = array(
			'module'		=> 'tender',
			'function'		=> 'add_quote',
			'id'			=> $info['tenderid'],
			'tenderitem'	=> $info['tenderitem'],
			'usersid'		=> $info['usersid']
		);
		// send the message to app
		send_message($params,$cfg);
	} else {
		// error
		xml_generator("tender","error",$errors,$params,$cfg);
	}
}
?>