<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Product
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

if(!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	xml_generator("tender","error","e54",$params,$cfg);
}
// Include General Procurement Functions and Settings
require(getcwd()."/modules/procure/config.inc.php");
require(getcwd()."/modules/procure/generic.php");
// field request errors and type 
$fields_request = array (
	'action'			=> array(),
	'tenderid'			=> array(),
	'usersid'			=> array(),
	'product'			=> array()
);
get_request($fields_request,$action,$error,$cfg);
// set the product type being requested
$product = $action['product'];
$tenderid = $action['tenderid'];
$userid = $action['usersid'];
if ($action['action'] != "additem") {
	// field request errors and type
	// 1023 - Category ID must be a number 
	// 1024 - Missing Category ID
	// 1025 - Sub Category ID must be a number 
	// 1026 - Missing Sub Category ID
	$fields_request = array (
		'category'			=> array("1024",	REQUEST_NUMBER,	FORMAT_NONE,	"1023"),
		'subcat'			=> array("1025",	REQUEST_NUMBER,	FORMAT_NONE,	"1026",	"category_sub"),
		'brand'				=> array("e4"),
		'model'				=> array("e5"),
		'description'		=> array("e6",	REQUEST_ANY,	FORMAT_NONE,	""),
		'add_des'			=> array(),
		'quote'				=> array("e15",	REQUEST_MONEY,	FORMAT_MONEY, 	"e24"),
		'budget'			=> array("",	REQUEST_MONEY,	FORMAT_MONEY,	"e25"),
		'quantity'			=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e26"),
		'quantitymessage'	=> array()
	);
	// determine if error occurred
	if(get_request($fields_request,$info,$error_code,$cfg)) {
		$tender_item['category'] = $info['category'];
		$tender_item['category_sub'] = $info['category_sub'];
		$tender_item['brand'] = $info['brand'];
		$tender_item['model'] = $info['model'];
		$tender_item['description'] = $info['description'];
		$tender_item['quote'] = $info['quote'];
		$tender_item['budget'] = $info['budget'];
		$tender_item['quantity'] = $info['quantity'];
		// if more than one
		if($tender_item['quantity'] && $tender_item['quantity'] > 1) {
			$tender_item['model'] = $tender_item['quantity']." X ".$tender_item['model'];
			$quantitymessage = str_replace("[#]",$tender_item['quantity'],$info['quantitymessage']);
			$tender_item['description'].=" (".$quantitymessage.")";
		}
		// if additional descriptions
		if(is_array($info['add_des'])) {
			foreach($info['add_des'] as $value) {
				if(is_array($value)) {
					$tmp_des = "";
					foreach($value as $value1) {
						$tmp_des.=$value1;
					}
					if($tmp_des) {
						$tender_item['description'].=", ".$tmp_des;
					}
				} else {
					if($tender_item['description'] && $value) {
						$tender_item['description'].=", ";
					}
					if($value) {
						$tender_item['description'].=" ".$value;
					}
				}
			}
		}
		// submit
		if ($action['action']['submit'] == "Submit") {
			// paramaters to send to the application server
			$params = array(
				'module'	=> 'tender',
				'function'	=> 'add_product',
				'tenderid'	=> $tenderid,
				'procure'	=> $tender_item
			);	

			// send the message to app
			send_message($params,$cfg);			
		} 
	} else { 
		// paramaters to send to the application server
		$params = array(
			'module'	=> 'tender',
			'function'	=> 'approve_add_product',
			'product'	=> 'product',
			'error'		=> $error_code
		);
		// insert tender information
		$params['procure'] = $info;
		$params['tenderid'] = $tenderid;
		$params['procure']['userid'] = $userid;
		// set that only info required and should not be displayed
		$cfg['api_request'] = TRUE;
		// send the message to app
		$xml = send_message($params,$cfg);
		// include inserted fields
		$xml.="<procure>\r\n";
		if ($info['category']) {
			$xml.="<category>".$info['category']."</category>\r\n";
		}
		if ($info['category_sub']) {
			$xml.="<subcat>".$info['category_sub']."</subcat>\r\n";
		}
		if ($info['brand']) {
			$xml.="<brand>".$info['brand']."</brand>\r\n";
		}
		if ($info['model']) {
			$xml.="<model>".$info['model']."</model>\r\n";
		}
		if ($info['description']) {
			$xml.="<description>".$info['description']."</description>\r\n";
		}
		if ($info['quote']) {
			$xml.="<quote>".$info['quote']."</quote>\r\n";
		}
		if ($info['budget']) {
			$xml.="<budget>".$info['budget']."</budget>\r\n";
		}
		if ($info['quantity']) {
			$xml.="<quantity>".$info['quantity']."</quantity>\r\n";
		}
		if (is_array($info['add_des'])) {
			foreach($info['add_des'] as $value) {
				if(is_array($value)) {
					foreach($value as $value1) {
						if($value1) {
							$xml.="<additional_des>".$value1."</additional_des>\r\n";
						}
					}
				} else {
					if($value) {
						$xml.="<additional_des>".$value."</additional_des>\r\n";
					}
				}
			}
		}
		$xml.="</procure>\r\n";
	}
} else {
	// paramaters to send to the application server
	$params = array(
		'module'	=> 'tender',
		'function'	=> 'approve_add_product',
		'product'	=> 'product'
	);
	// insert tender information
	$params['tenderid'] = $tenderid;
	$params['procure']['userid'] = $userid;	
	// set that only info required and should not be displayed
	$cfg['api_request'] = TRUE;
	// send the message to app
	
	$xml = send_message($params,$cfg);
}		

// display xml
display_response($xml,$cfg);
?>