<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Link generator
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

require(getcwd().'/modules/tender/config.inc.php');
if ($menu == "left" && $module == "settings"  && $_SESSION['ts_id']) {
	if($_SESSION['ts_classification'] == "3") {
		$xml = file_get_contents("modules/tender/language/".$language."/default.xml");
		$name = event_parser('<tender>','</tender>',$xml);
		$menu_item['settings'][] = array(
			'name'			=> $name,
			'module'		=> "tender",
			'function'		=> "settings",
			'frame'			=> "main"
		);
	}
}
	
if($cfg['tender']['enable']) {
	if ($menu == "top"  && $_SESSION['ts_id']) {
		$xml = file_get_contents("modules/tender/language/".$language."/default.xml");
		if($_SESSION['ts_classification'] == "2") {
			if($cfg['tender']['supplier']['search']['menu']) {
				// suppliers
				$name = event_parser('<suppliers>','</suppliers>',$xml);
				$menu_item['middle'][-15] = array(
					'name'		=> $name,
					'module'	=> "tender",
					'function'	=> "supplier_search",
					'frame'		=> "main"
				);
			}
			// tender request
			$name = event_parser('<tenderrequest>','</tenderrequest>',$xml);
			$menu_item['middle'][-30] = array(
				'name'		=> $name,
				'module'	=> "tender",
				'function'	=> "invitation",
				'frame'		=> "main"
			);
		}
		if($_SESSION['ts_classification'] == "1") {
			// submit quote
			$name = event_parser('<submitquote>','</submitquote>',$xml);
			$menu_item['middle'][] = array(
				'name'		=> $name,
				'module'	=> "tender",
				'function'	=> "quote",
				'frame'		=> "main"
			);
			if ($cfg['tender']['validity']['status']) {
				// view valid item
				$name = event_parser('<viewvalid>','</viewvalid>',$xml);
				$menu_item['middle'][] = array(
					'name'		=> $name,
					'module'	=> "tender",
					'function'	=> "view_item",
					'frame'		=> "main"
				);
				// submit valid item
				$name = event_parser('<uploadvalid>','</uploadvalid>',$xml);
				$menu_item['middle'][] = array(
					'name'		=> $name,
					'module'	=> "tender",
					'function'	=> "add_item",
					'frame'		=> "main"
				);
			}
		}
	}
}
?>