<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../category/templates/category_script.xsl"/>
<xsl:include href="../../procure/templates/procure_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<link rel="stylesheet" type="text/css" media="all" href="./theme/{$theme}/style_calendar.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/addvaliditem"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="add_item"/>
					<input type="hidden" name="organisationid" value="{organisationid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<xsl:if test="created='1'">
							<tr>
								<td colspan="4" class="t1">
									<xsl:value-of select="$lng/createditem"/>
									<xsl:if test="createdcount">
										<xsl:value-of select="' '"/>
										<xsl:value-of select="createdcount"/>
										<xsl:value-of select="'/'"/>
										<xsl:value-of select="itemcount"/>
									</xsl:if>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="show='1'">
						<tr>
							<td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/validitemsinfo"/>
							</td>
							<td class="ha t1" align="right">
								<input type="checkbox" class="t2" id="site" name="ignoreall" onchange="CheckAll(this)"/>
								<xsl:value-of select="$lng/ignore"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="t1">
								<xsl:value-of select="$lng/validuntil"/>
							</td>
							<td class="t1" align="left">
								<input type="text" class="t2" size="10">
									<xsl:attribute name="value"><xsl:value-of select="validuntil_all"/></xsl:attribute>
									<xsl:attribute name="name">validuntil_all</xsl:attribute>
									<xsl:attribute name="id">validuntil_all</xsl:attribute>
								</input>
								<img src="./theme/{$theme}/icon/calendar.gif" style="cursor: pointer; 	border: 0px;" alt="Date selector" >
									<xsl:attribute name="id">trigger_all</xsl:attribute>
								</img>
							</td>
						</tr>
						<tr><td><br/></td></tr>
							<xsl:for-each select="uploaditem">
							<tr>
								<td><br/></td>
								<td class="h1 t1">
									<xsl:value-of select="$lng/info"/>
								</td>
								<td class="h1a t1" align="right">
									<input type="checkbox" class="t2">
										<xsl:attribute name="name">ignoreitem[<xsl:value-of select="number"/>]</xsl:attribute>
									</input>
									<xsl:value-of select="$lng/ignore"/>
								</td>
							</tr>
							<xsl:call-template name="category_field">
								<xsl:with-param name="empty_td" select="'1'"/>
								<xsl:with-param name="selected" select="category"/>
								<xsl:with-param name="fieldname" select="concat('itemcategory[',number,']')"/>
								<xsl:with-param name="fieldid" select="concat('itemcategory',number)"/>
								<xsl:with-param name="onchange" select="concat('changesub',number,'();changebrand',number,'();')"/>
							</xsl:call-template>
							<xsl:call-template name="category_sub_field">
								<xsl:with-param name="empty_td" select="'1'"/>
								<xsl:with-param name="fieldname" select="concat('itemsubcategory[',number,']')"/>								
								<xsl:with-param name="fieldid" select="concat('itemsubcategory',number)"/>
							</xsl:call-template>
							<xsl:call-template name="brand_field">
								<xsl:with-param name="onchange" select="concat('brandupdate(itembrand',number,',this)')"/>
								<xsl:with-param name="empty_td" select="'1'"/>
								<xsl:with-param name="selectname" select="concat('itembrandselector[',number,']')"/>
								<xsl:with-param name="fieldname" select="concat('itembrand[',number,']')"/>
								<xsl:with-param name="fieldid" select="concat('itembrandselector',number)"/>
								<xsl:with-param name="inputid" select="concat('itembrand',number)"/>
								<xsl:with-param name="brand" select="brand"/>
							</xsl:call-template>
							<xsl:call-template name="model_field">
								<xsl:with-param name="empty_td" select="'1'"/>
								<xsl:with-param name="fieldname" select="concat('itemmodel[',number,']')"/>
								<xsl:with-param name="model" select="model"/>
							</xsl:call-template>
							<xsl:call-template name="description_field">
								<xsl:with-param name="empty_td" select="'1'"/>
								<xsl:with-param name="fieldname" select="concat('itemdescription[',number,']')"/>
								<xsl:with-param name="description" select="description"/>
							</xsl:call-template>
							<tr>
								<td><br/></td>
								<td class="t1">
									<xsl:value-of select="$lng/stock"/>
								</td>
								<td class="t2">
									<select class="t2">
										<xsl:attribute name="name">itemstock[<xsl:value-of select="number"/>]</xsl:attribute>
										<option value="0">
											<xsl:value-of select="$lng/available"/>
										</option>
										<option value="1">
											<xsl:if test="stock='1'"><xsl:attribute name="selected"/></xsl:if>
											<xsl:value-of select="$lng/oneday"/>
										</option>
										<option value="2">
											<xsl:if test="stock='2'"><xsl:attribute name="selected"/></xsl:if>
											<xsl:value-of select="$lng/twoday"/>
										</option>
										<option value="3">
											<xsl:if test="stock='3'"><xsl:attribute name="selected"/></xsl:if>
											<xsl:value-of select="$lng/threeday"/>
										</option>
										<option value="7">
											<xsl:if test="stock='7'"><xsl:attribute name="selected"/></xsl:if>
											<xsl:value-of select="$lng/week"/>
										</option>
									</select>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="t1">
									<xsl:value-of select="$lng/price"/>
								</td>
								<td class="t2">
									<xsl:value-of select="../localprecurrency"/>
									<input type="text" class="t2" size="8">
										<xsl:attribute name="value"><xsl:value-of select="price"/></xsl:attribute>
										<xsl:attribute name="name">itemprice[<xsl:value-of select="number"/>]</xsl:attribute>
									</input>
									<xsl:value-of select="../localpostcurrency"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
							</tr>
							</xsl:for-each>
							<tr>
								<td><br/></td>
								<td colspan="2" align="right" class="t1">
									<input type="submit" name="upload" class="t2">
										<xsl:attribute name="value"><xsl:value-of select="$lng/submit"/></xsl:attribute>
									</input>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="show='0'">
							<tr>
								<td><br/></td>
								<td colspan="6" class="h t1">
									<xsl:value-of select="$lng/validitemsinfo"/>
								</td>
							</tr>
							<xsl:call-template name="category_field">
								<xsl:with-param name="empty_td" select="'1'"/>
							</xsl:call-template>
							<xsl:call-template name="category_sub_field">
								<xsl:with-param name="empty_td" select="'1'"/>
								<xsl:with-param name="fieldname" select="'itemsubcategory'"/>
							</xsl:call-template>
							<xsl:call-template name="brand_field">
								<xsl:with-param name="onchange" select="'brandupdate(itembrand,this)'"/>
								<xsl:with-param name="empty_td" select="'1'"/>
								<xsl:with-param name="fieldname" select="'itembrand'"/>
								<xsl:with-param name="brand" select="currentinfo/itembrand"/>
							</xsl:call-template>
							<xsl:call-template name="model_field">
								<xsl:with-param name="empty_td" select="'1'"/>
								<xsl:with-param name="fieldname" select="'itemmodel'"/>
								<xsl:with-param name="model" select="currentinfo/itemmodel"/>
							</xsl:call-template>
							<xsl:call-template name="description_field">
								<xsl:with-param name="empty_td" select="'1'"/>
								<xsl:with-param name="fieldname" select="'itemdescription'"/>
								<xsl:with-param name="description" select="currentinfo/itemdescription"/>
							</xsl:call-template>
							<tr>
								<td ><br/></td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/stock"/>
								</td>
								<td align="left" colspan="2" class="t2">
									<select name="itemstock" class="t2">
										<option value="0">
											<xsl:value-of select="$lng/available"/>
										</option>
										<option value="1">
											<xsl:if test="currentinfo/itemstock='1'"><xsl:attribute name="selected"/></xsl:if>
											<xsl:value-of select="$lng/oneday"/>
										</option>
										<option value="2">
											<xsl:if test="currentinfo/itemstock='2'"><xsl:attribute name="selected"/></xsl:if>
											<xsl:value-of select="$lng/twoday"/>
										</option>
										<option value="3">
											<xsl:if test="currentinfo/itemstock='3'"><xsl:attribute name="selected"/></xsl:if>
											<xsl:value-of select="$lng/threeday"/>
										</option>
										<option value="7">
											<xsl:if test="currentinfo/itemstock='7'"><xsl:attribute name="selected"/></xsl:if>
											<xsl:value-of select="$lng/week"/>
										</option>
									</select>
								</td>
							</tr>
							<tr>
								<td ><br/></td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/validuntil"/>
								</td>
								<td align="left" class="t2">
									<input type="text" name="validuntil" id="validuntil" class="t2" value="{currentinfo/validuntil}" size="10"/>
									<xsl:value-of select="' '"/>
									<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_validuntil" style="cursor: pointer; border: 0px;" alt="Date selector" />
								</td>
							</tr>
							<tr>
								<td ><br/></td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/price"/>
								</td>
								<td align="left" colspan="2" class="t2">
									<xsl:value-of select="localprecurrency"/>
									<input type="text" name="itemprice" class="t2" value="0.00">
										<xsl:if test="currentinfo/itemprice">
											<xsl:attribute name="value"><xsl:value-of select="currentinfo/itemprice"/></xsl:attribute>
										</xsl:if>
									</input>
									<xsl:value-of select="localpostcurrency"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="right" colspan="2">
									<input type="submit" name="additem" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/submit"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td colspan="2" class="h t1">
									<xsl:value-of select="$lng/uploadfromafile"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="t1">
									<xsl:value-of select="$lng/upload"/>
								</td>
								<td class="t2" align="right">
									<input type="file" name="file" size="15" class="t2"/>
									<input type="submit" name="upload" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/submit"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
			<div id="right">
				<xsl:if test="show='0'">
					<div id="right_header">
						<xsl:value-of select="$lng/creatingitem"/>
					</div>
					<div id="right_content">
						<xsl:for-each select="$lng/itemcreateinst">
							<xsl:value-of select="."/><br/>
						</xsl:for-each>
					</div>
					<div id="right_header">
						<xsl:value-of select="$lng/uploaditems"/>
					</div>
					<div id="right_content">
						<xsl:for-each select="$lng/uploaditeminst">
							<xsl:value-of select="."/><br/>
						</xsl:for-each>
						<a href="./modules/tender/language/{$language}/spreadsheet/item_upload.xls">
							<img border="0" src="./theme/{$theme}/icon/xls.gif" alt=""/>
							<xsl:value-of select="$lng/download"/>
						</a>
					</div>
					<div id="right_header">
						<xsl:value-of select="$lng/downloadareas"/>
					</div>													
					<div id="right_content">
						<a href="main.php?module=tender&amp;function=download_areas&amp;type=delivery">
							<xsl:value-of select="$lng/delivery_spreadsheet"/>
						</a>
						<br/>
						<a href="main.php?module=tender&amp;function=download_areas&amp;type=installation">
							<xsl:value-of select="$lng/instal_spreadsheet"/>
						</a>						
					</div>							
				</xsl:if>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>

	<script type="text/javascript">
		<xsl:call-template name="brandupdate_script"/>
		<xsl:if test="show='0'">
			<xsl:call-template name="changebrand_script"/>
			<xsl:call-template name="category_script">
				<xsl:with-param name="functionname" select="'changesub'"/>
				<xsl:with-param name="selectcategory_sub" select="'itemsubcategory'"/>
			</xsl:call-template>
			changesub();
			changebrand();
			Calendar.setup({inputField:"validuntil",ifFormat:"%Y-%m-%d",button:"trigger_validuntil",singleClick:true});
		</xsl:if>	
		<xsl:if test="show='1'">
			<xsl:for-each select="uploaditem">
				<xsl:call-template name="changebrand_script">
					<xsl:with-param name="functionname" select="concat('changebrand',number)"/>
					<xsl:with-param name="brandfield" select="concat('itembrandselector',number)"/>
					<xsl:with-param name="categoryfield" select="concat('itemcategory',number)"/>
				</xsl:call-template>
				<xsl:call-template name="category_script">
					<xsl:with-param name="functionname" select="concat('changesub',number)"/>
					<xsl:with-param name="selectcategory" select="concat('itemcategory',number)"/>
					<xsl:with-param name="selectcategory_sub" select="concat('itemsubcategory',number)"/>
				</xsl:call-template>
				<xsl:value-of select="concat('changebrand',number,'();')"/>
				<xsl:value-of select="concat('changesub',number,'();')"/>
				<xsl:if test="category_sub &gt; 0">
	      		    document.report.itemsubcategory<xsl:value-of select="number"/>.value = <xsl:value-of select="category_sub"/>;
				</xsl:if>
			</xsl:for-each>
			Calendar.setup({inputField:"validuntil_all",ifFormat:"%Y-%m-%d",button:"trigger_all",singleClick:true});
			function CheckAll(parent) {
				var allChildren = document.getElementById(parent.id+'div').getElementsByTagName("input");
				for (var i = 0; i &lt; allChildren.length; i++) {
					allChildren[i].checked = parent.checked;
				}
			}
		</xsl:if>
	</script>
</body>
</html>
</xsl:template>

</xsl:stylesheet>
