<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderitem"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="add_product"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td class="t1">
							    <xsl:value-of select="$lng/itemadded"/>
							</td>
						</tr>
						<tr>
							<td class="t2">
								<input type="button" name="additem" onclick="gotoadditem()" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/additem"/>
									</xsl:attribute>
								</input>
							</td>
							<td class="t2">
								<input type="button" name="returntoappove" onclick="gotoapprovetender()" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/returntoapprove"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>	
						<tr>	
							<td><br/></td>
						</tr>	
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function gotoadditem() {
			var tender_id = <xsl:value-of select="tender/tenderid"/>;
			var user_id = <xsl:value-of select="tender/userid"/>;
			parent.main.location.href = "./main.php?module=tender&amp;function=approve_add_product&amp;tenderid=" + tender_id + "&amp;usersid=" + user_id + "&amp;action=additem&amp;product=additem";	
		}
		function gotoapprovetender() {
			var tender_id = <xsl:value-of select="tender/tenderid"/>;			
			parent.main.location.href = "./main.php?module=tender&amp;function=approve&amp;tenderid=" + tender_id;	
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
