<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<xsl:param name="display" select="/response/display"/>
<xsl:param name="more" select="/response/more"/>
<xsl:param name="type" select="/response/type"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/controlpanel"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/opentenders"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="module"/>
					<input type="hidden" name="function" value="function"/>
					<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="opentenders/name">
							<tr>
								<td><br/></td>
								<td class="h t1"><xsl:value-of select="$lng/rfqnumber"/></td>
								<td class="ha t1"><xsl:value-of select="$lng/subscriber"/></td>
								<td class="ha t1"><xsl:value-of select="$lng/items"/></td>
								<td class="ha t1"><xsl:value-of select="$lng/quotesyou"/></td>
								<td class="ha t1"><xsl:value-of select="$lng/area"/></td>
								<td class="ha t1"><xsl:value-of select="$lng/action"/></td>
							</tr>
							<xsl:for-each select="opentenders">
								<tr>
									<td><br/></td>
									<td class="h2b t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tenderid)"/>
											</xsl:attribute>
											<xsl:value-of select="rfq_number"/>
										</a>
									</td>
									<td class="h2c t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',usersid)"/>
											</xsl:attribute>
											<xsl:value-of select="name"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="surname"/>
										</a>
									</td>
									<td class="h2c t2"><xsl:value-of select="itemcount"/></td>
									<td class="h2c t2"><xsl:value-of select="quotecount"/></td>
									<td class="h2c t2"><xsl:value-of select="areaname"/></td>
									<td class="h2c t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=tender&amp;function=quote&amp;tenderid=',tenderid)"/>
											</xsl:attribute>
											<xsl:value-of select="$lng/quote"/>
										</a>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>