<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:param name="searchurl" select="/response/searchurl"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- area java script -->
<xsl:include href="../../area/templates/state_script.xsl"/>
<!-- category java script -->
<xsl:include href="../../category/templates/category_script.xsl"/>
<xsl:include href="../../tender/templates/approve_script.xsl"/>
	
<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<script type="text/javascript" src="./modules/tender/templates/liverequest1.js"></script>
	<xsl:if test="session">
			<script>
		<xsl:choose>
			<xsl:when test="offsite">
				window.location.href = "index.php";
			</xsl:when>
			<xsl:otherwise>
				parent.menu.location.reload();
			</xsl:otherwise>
		</xsl:choose>
			</script>
	</xsl:if>
	</head>
<body>
	<xsl:attribute name="onload">lsInit(<xsl:value-of select="tender/tenderid"/>, <xsl:value-of select="tender/organisationid"/>);</xsl:attribute>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderquote"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="approve"/>
					<input type="hidden" name="tenderid" value="{tender/tenderid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
					<xsl:if test="not(tender/tenderid)">
						<tr>
							<td><br/></td>
							<td class="t2">
								<xsl:value-of select="$lng/nothingtoquote"/>
							</td>
						</tr>
					</xsl:if>
					<!-- tenders to approve -->
					<xsl:if test="tender/tenderid">
						<tr>
							<td><br/></td>
							<td class="h t1" colspan="4">
								<xsl:value-of select="$lng/approvetender"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td class="h1c t2">
								<input name="rfq_number" value="{tender/rfq_number}" class="t2"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
							<td class="h1c t2">
								<input name="rfq_reference" value="{tender/rfq_reference}" class="t2"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/subscriber"/>
							</td>
							<td class="h1c t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',tender/usersid)"/>
									</xsl:attribute>
									<xsl:value-of select="tender/name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tender/surname"/>
								</a>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="tender/email"/>?subject=<xsl:value-of select="$lng/rfqnumber"/>: <xsl:value-of select="tender/rfq_number"/> (<xsl:value-of select="tender/rfq_reference"/>)</xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/company"/>
							</td>
							<td class="h1c t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',tender/organisationid)"/>
									</xsl:attribute>
									<xsl:value-of select="tender/organisationname"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td class="h1c t2">
								<select name="state" class="t2" onchange="update_state()">
									<option value="0"><xsl:value-of select="$lng/selectstate"/></option>
								<xsl:for-each select="state">
									<option value="{stateid}">
										<xsl:value-of select="statename"/>
									</option>
								</xsl:for-each>
								</select>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td class="h1c t2">
								<select name="area" id="area" class="t2" onchange="lsStart()">
									<option value=""><xsl:value-of select="$lng/selectarea"/></option>
								<xsl:for-each select="area">
									<option value="{areaid}">
									<xsl:if test="areaid=../tender/areaid">
										<xsl:attribute name="selected"/>
									</xsl:if>
										<xsl:value-of select="areaname"/>
									</option>
								</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="4" class="h2b">
								<table border="0" cellpadding="2" cellspacing="0" bgcolor="FFFFFF">
									<tr>
										<td class="h1 t1">
											#
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/category"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/category_sub"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/brand"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/model"/>
										</td>
										<td class="h1a t1" colspan="4">
											<xsl:value-of select="$lng/description"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/quote"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/budget"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/remove"/>
										</td>
									<xsl:if test="searchurl">
										<td class="h1a t1">
											<xsl:value-of select="$lng/search"/>
										</td>
									</xsl:if>
									</tr>
									<xsl:for-each select="tenderitem">
											<tr>
												<td class="h2b t1" valign="top">
													<xsl:value-of select="id"/>
												</td>
												<td class="h2c t2" valign="top">
													<xsl:choose>
														<xsl:when test="classification = 3">
															<xsl:value-of select="$lng/deliver"/>
														</xsl:when>
														<xsl:when test="classification = 4">
															<xsl:value-of select="$lng/install"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:call-template name="approve_category_field">
																<xsl:with-param name="empty_td" select="'1'"/>
																<xsl:with-param name="selected" select="categoryid"/>
																<xsl:with-param name="fieldname" select="concat('itemcategory[',id,']')"/>
																<xsl:with-param name="fieldid" select="concat('itemcategory',id)"/>
																<xsl:with-param name="onchange" select="concat('changesub',id,'();')"/>
															</xsl:call-template>
														</xsl:otherwise>
													</xsl:choose>
												</td>		
												<td class="h2c t2">									
													<xsl:choose>
														<xsl:when test="classification &lt; 3">
															<xsl:call-template name="approve_category_sub_field">
																<xsl:with-param name="empty_td" select="'1'"/>
																<xsl:with-param name="selected" select="category_subid"/>
																<xsl:with-param name="fieldname" select="concat('itemsubcategory[',id,']')"/>
																<xsl:with-param name="fieldid" select="concat('itemsubcategory',id)"/>
																<xsl:with-param name="onchange" select="'lsStart()'"/>
															</xsl:call-template>
														</xsl:when>
														<xsl:otherwise>
															<br/>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td class="h2c t2" valign="top">
													<xsl:if test="../brand/brandname">
														<select class="t2">
															<xsl:attribute name="name">brandselector[<xsl:value-of select="id"/>]</xsl:attribute>
															<xsl:attribute name="id">brandselector<xsl:value-of select="id"/></xsl:attribute>
															<xsl:attribute name="onchange">changebrand(brand<xsl:value-of select="id"/>,brandselector<xsl:value-of select="id"/>)</xsl:attribute>
															<option value="0"></option>
															<xsl:for-each select="../brand">
																<option>
																	<xsl:attribute name="value"><xsl:value-of select="brandname"/></xsl:attribute>
																	<xsl:value-of select="brandname"/>
																</option>
															</xsl:for-each>
														</select>
													</xsl:if>
													<input type="text" class="t2" size="10">
														<xsl:attribute name="value"><xsl:value-of select="brand"/></xsl:attribute>
														<xsl:attribute name="name">tenderitem[<xsl:value-of select="id"/>][brand]</xsl:attribute>
														<xsl:attribute name="id">brand<xsl:value-of select="id"/></xsl:attribute>
													</input>
												</td>
												<td class="h2c t2" valign="top">
													<input type="text" class="t2" size="10">
														<xsl:attribute name="value"><xsl:value-of select="model"/></xsl:attribute>
														<xsl:attribute name="name">tenderitem[<xsl:value-of select="id"/>][model]</xsl:attribute>
														<xsl:attribute name="id">model<xsl:value-of select="id"/></xsl:attribute>
													</input>
												</td>
												<td class="h2c t2" colspan="4" valign="top">
													<textarea class="t2" cols="25">
														<xsl:attribute name="name">tenderitem[<xsl:value-of select="id"/>][description]</xsl:attribute>
														<xsl:attribute name="id">description<xsl:value-of select="id"/></xsl:attribute>
														<xsl:value-of select="description"/>
													</textarea>
												</td>
												<td class="h2c t2" valign="top">
													<input type="text" class="t2" size="8" value="{quote}">
														<xsl:attribute name="name">tenderitem[<xsl:value-of select="id"/>][quote]</xsl:attribute>
													</input>
												</td>
												<td class="h2c t2" valign="top">
													<input type="text" class="t2" size="8" value="{budget}">
														<xsl:attribute name="name">tenderitem[<xsl:value-of select="id"/>][budget]</xsl:attribute>
													</input>
												</td>
												<td class="h2c t2" valign="top" align="center">
												<xsl:choose>
													<xsl:when test="classification = 1">
														<input type="checkbox" class="t2" value="0">
															<xsl:attribute name="name">tenderitem[<xsl:value-of select="id"/>][status]</xsl:attribute>
														</input>
													</xsl:when>
													<xsl:otherwise>
														<br/>
													</xsl:otherwise>												
												</xsl:choose>
												</td>
										<xsl:if test="/response/searchurl">
												<td class="h2c t2" valign="top" align="center">
													<xsl:if test="classification = 1">
														<xsl:variable name="brand" select="brand"/>
														<xsl:variable name="model" select="model"/>
														<a href="{$searchurl}{$brand}+{$model}" target="blank">
															<img src="./theme/{$theme}/icon/kappfinder.gif" border="0" alt="Search"/>
														</a>
													</xsl:if>
													<br/>
												</td>
										</xsl:if>
											</tr>
									</xsl:for-each>
								</table>
							</td>
						</tr>
						<tr>
							<td><br/><br/></td>
							<td colspan="5" class="t1" align="right">
								<input type="button" name="additem" onclick="gotoadditem()" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/additem"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/><br/></td>
							<table id="data1" border="0" cellpadding="2" cellspacing="0" bgcolor="FFFFFF"/>	
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="5" class="t1" align="right">
								<input type="submit" name="submit" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/approvetender"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:if>
					</table>
				</form>
			</div>
			<div id="right">
			</div>
		</div>
	</div>
	<script type="text/javascript">
		document.report.rfq_number.focus();
		<xsl:call-template name="state_script"/>
		var itemcatids = new Array();
		var itemsubcatids = new Array();
		var n = 0;
		<xsl:for-each select="tenderitem">
			<xsl:if test="(classification != 3) and (classification != 4)">
				<xsl:call-template name="category_script">
					<xsl:with-param name="functionname" select="concat('changesub',id)"/>
					<xsl:with-param name="selectcategory" select="concat('itemcategory',id)"/>
					<xsl:with-param name="selectcategory_sub" select="concat('itemsubcategory',id)"/>
				</xsl:call-template>
				itemcatids[n] = 'itemcategory' + <xsl:value-of select="id"/>;
				itemsubcatids[n] = 'itemsubcategory' + <xsl:value-of select="id"/>;
				n++;								
				<xsl:value-of select="concat('changesub',id)"/>
			</xsl:if>
		</xsl:for-each>			
		
		function gotoadditem() {
			var tender_id = <xsl:value-of select="tender/tenderid"/>;
			var user_id = <xsl:value-of select="tender/usersid"/>;
			parent.main.location.href = "./main.php?module=tender&amp;function=approve_add_product&amp;tenderid=" + tender_id + "&amp;usersid=" + user_id + "&amp;action=additem&amp;product=additem";	
		}
	</script>
	<xsl:call-template name="footer"/>
	
</body>
</html>

</xsl:template>

</xsl:stylesheet>
