<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Tender Scripts -->
<xsl:include href="../../procure/templates/procure_generic.xsl"/>
<xsl:include href="../../category/templates/category_script.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header"><xsl:value-of select="$lng/addproduct"/></div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
				<input type="hidden" name="module" value="tender"/>
				<input type="hidden" name="function" value="approve_add_product"/>
				<input type="hidden" name="tenderid" value="{tenderid}"/>
				<input type="hidden" name="usersid" value="{usersid}"/>
				<input type="hidden" name="product" value="{product_sel}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
					<xsl:if test="$lng/rfqnotice">
						<tr>
							<td colspan="2" class="h1 t1">
								<xsl:for-each select="$lng/rfqnotice">
									<xsl:value-of select="' '"/><xsl:value-of select="."/><br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
					</xsl:if>
						<!-- Templates are in procure/templates/procure_generic.xsl
							 and category/templates/category_script.xsl -->
						<xsl:call-template name="category_field"/>
						<xsl:call-template name="category_sub_field"/>
						<xsl:call-template name="brand_field"/>
			<xsl:choose>
					<xsl:when test="commodity/item">
						<xsl:call-template name="commodity_field"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="model_field"/>
						<xsl:if test="tenderquantity='1'">
							<xsl:call-template name="quantity_field"/>
						</xsl:if>
					</xsl:otherwise>
			</xsl:choose>
						<xsl:call-template name="description_field"/>
						<xsl:if test="add_des">
							<xsl:call-template name="add_description_field"/>
						</xsl:if>
						<xsl:call-template name="quote_field"/>
						<xsl:if test="tenderbudget='1'">
							<xsl:call-template name="budget_field"/>
						</xsl:if>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="showaddproduct" select="'no'"/>
						</xsl:call-template>	
					</table>
				</form>
			</div>
			<div id="right">
				<xsl:call-template name="right_intstruction"/>
			</div>
			<xsl:call-template name="basket"/>
		</div>
	</div>
	<script type="text/javascript">
		<xsl:call-template name="changebrand_script"/>
		<xsl:call-template name="brandupdate_script"/>
		<xsl:call-template name="category_script">
			<xsl:with-param name="functionname" select="'changesub'"/>
			<xsl:with-param name="selectcategory_sub" select="'subcat'"/>
		</xsl:call-template>
		changesub();
		changebrand();
	</script>
	<xsl:call-template name="footer"/>
</body>
</html>
</xsl:template>

</xsl:stylesheet>