<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="approve_category_field">
	<xsl:param name="onchange" select="'changesub();changebrand();'"/>
	<xsl:param name="fieldname" select="'category'"/>
	<xsl:param name="fieldid" select="''"/>
	<xsl:param name="zerooption" select="'yes'"/>
	<xsl:param name="selected" select="procure/category"/>
	<xsl:param name="category" select="category_hidden"/>
	<xsl:param name="empty_td" select="'no'"/>
	<xsl:choose>
		<xsl:when test="/response/category/categoryid">
			<xsl:if test="$empty_td='1' or empty_td='yes'">
				<br/>
			</xsl:if>
				<xsl:call-template name="category_select">
					<xsl:with-param name="onchange" select="$onchange"/>
					<xsl:with-param name="fieldname" select="$fieldname"/>
					<xsl:with-param name="fieldid" select="$fieldid"/>
					<xsl:with-param name="zerooption" select="$zerooption"/>
					<xsl:with-param name="selected" select="$selected"/>
				</xsl:call-template>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name="approve_category_sub_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'subcat'"/>
	<xsl:param name="fieldid" select="''"/>
	<xsl:param name="zerooption" select="'yes'"/>
	<xsl:param name="selected" select="procure/category_sub"/>
	<xsl:param name="category_sub" select="category_sub_hidden"/>
	<xsl:param name="empty_td" select="'no'"/>
	<select name="{$fieldname}" class="t2" onchange="{$onchange}">
		<xsl:if test="$fieldid!=''">
			<xsl:attribute name="id"><xsl:value-of select="$fieldid"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$zerooption='yes' or $zerooption='1'">
			<option><xsl:value-of select="$lng/selectsubcategory"/></option>
		</xsl:if>
		<xsl:for-each select="/response/subcategory">
			<option value="{subcategoryid}">
				<xsl:if test="subcategoryid=$selected">
					<xsl:attribute name="selected"/>						
				</xsl:if>
				<xsl:value-of select="subcategoryname"/>
			</option>
		</xsl:for-each>
	</select>
</xsl:template>

</xsl:stylesheet>