<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/awardtender"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="award"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="awardtender/id">
							<xsl:for-each select="awardtender">
								<xsl:if test="status='4'">
									<tr><td colspan="9"></td></tr>
									<tr>
										<td><br/></td>
										<td class="h t1" colspan="8" align="left">
											<xsl:value-of select="$lng/awarding"/>
											(<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./id)"/>
											</xsl:attribute>
											<xsl:value-of select="rfq_number"/>
											</a>)
										</td>
									</tr>
									<xsl:if test="../user/classification='3'">
									<tr>
										<td><br/></td>
										<td colspan="8" class="t1">
											<xsl:value-of select="$lng/onbehalf"/>
											<xsl:value-of select="' '"/>
											<select name="usersid[{id}]">
												<xsl:for-each select="users">
													<option value="{usersid}">
													<xsl:if test="usersid=../user_id">
														<xsl:attribute name="selected"/>
													</xsl:if>
														<xsl:value-of select="name"/>
														<xsl:value-of select="' '"/>
														<xsl:value-of select="surname"/>
													</option>
												</xsl:for-each>
											</select>
										</td>
									</tr>
									</xsl:if>
									<tr>
										<td></td>
										<td colspan="8">
											<table border="0" width="100%" align="center" cellpadding="2" cellspacing="0" bgcolor="FFFFFF">
									<xsl:for-each select="supplier">
											<tr>
												<td class="h1 t1" align="left">
													<xsl:value-of select="$lng/tenderitem"/>
												</td>
												<td class="h1a t1" align="left">
													<xsl:value-of select="$lng/brand"/>
												</td>
												<td class="h1a t1" align="left">
													<xsl:value-of select="$lng/model"/>
												</td>
												<td class="h1a t1" align="left">
													<xsl:value-of select="$lng/description"/>
												</td>
												<td class="h1a t1" align="left">
													<xsl:value-of select="$lng/price"/>
												</td>
											</tr>
										<xsl:variable name="supplier" select="name"/>
										<xsl:variable name="supplierid" select="id"/>
										<xsl:for-each select="agent">
											<xsl:for-each select="quote">
											<tr>
												<td class="h2b t2" align="left">
													<input type="hidden" name="award_item[{id}]" value="{../../../id}"/>
													<a target="main">
														<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./tender_item)"/></xsl:attribute>
														<xsl:value-of select="tender_item"/>
													</a>
												</td>
												<td class="h2c t2" align="left">
													<xsl:value-of select="brand"/>
												</td>
												<td class="h2c t2" align="left">
													<xsl:value-of select="model"/>
												</td>
												<td class="h2c t2" align="left">
													<textarea class="readonly t2" readonly="" cols="50"><xsl:value-of select="description"/></textarea>
												</td>
												<td class="h2c t2" align="right">
													<xsl:value-of select="/response/localprecurrency"/><xsl:value-of select="price"/><xsl:value-of select="/response/localpostcurrency"/>
												</td>
											</tr>
											</xsl:for-each>
											<tr>
												<td class="h1b t1" colspan="3">
													<a target="main">
														<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',$supplierid)"/></xsl:attribute>
														<xsl:value-of select="$supplier"/>
													</a>
													<xsl:value-of select="' '"/>
													<a target="main">
														<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/></xsl:attribute>
														<xsl:value-of select="'('"/>
														<xsl:value-of select="name"/>
														<xsl:value-of select="' '"/>
														<xsl:value-of select="surname"/>
														<xsl:value-of select="')'"/>
													</a>
												</td>
												<td class="h1c t1" align="right">
													<xsl:value-of select="$lng/total"/>
												</td>
												<td class="h1c t1" align="right">
													<xsl:value-of select="/response/localprecurrency"/><xsl:value-of select="sum"/><xsl:value-of select="/response/localpostcurrency"/>
												</td>
											</tr>
											<tr>
												<td class="h1b t1" colspan="3">
													<xsl:value-of select="$lng/suppliercomment"/>
												</td>
												<td class="h1c t1" colspan="3">
													<xsl:value-of select="branchcomment"/>
												</td>
											</tr>
										</xsl:for-each>
										<tr><td colspan="5"></td></tr>
									</xsl:for-each>
											<tr><td colspan="5"><br/></td></tr>
											<tr>
												<td class="h1 t1" colspan="4" align="right">
													<xsl:value-of select="$lng/grandtotal"/>
												</td>
												<td class="h1a t1" align="right">
													<xsl:value-of select="/response/localprecurrency"/><xsl:value-of select="sum"/><xsl:value-of select="/response/localpostcurrency"/>
												</td>
											</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td><br/></td>
										<td colspan="8"><br/></td>
									</tr>
									<xsl:choose>
										<xsl:when test="../awardtoself"/>
										<xsl:otherwise>
											<tr>
												<td><br/></td>
												<td class="h1 t1" colspan="8" align="left">
													<xsl:value-of select="$lng/clientinfo"/>
												</td>
											</tr>
											<tr>
												<td><br/></td>
												<td class="t1" align="right">
													<xsl:value-of select="$lng/title"/>
												</td>
												<td class="t2" colspan="8" align="left">
													<xsl:call-template name="client_title_select">
								 						<xsl:with-param name="onchange" select="'check_client_info()'"/>
														<xsl:with-param name="fieldname" select="concat('title[',id,']')"/>
														<xsl:with-param name="id" select="concat('title',id)"/>
													</xsl:call-template>
													<input type="text" class="readonly e" id="title_read{id}" readonly="" value=""/>
												</td>
											</tr>									
											<tr>
												<td><br/></td>
												<td class="t1" align="right">
													<xsl:value-of select="$lng/surname"/>
												</td>										
												<td class="t2" colspan="7" align="left">
													<input type="text" class="t2" name="surname[{id}]" id="surname{id}" onchange="check_client_info()" onkeypress="check_client_info()"/>
													<input type="text" class="readonly e" id="surname_read{id}" readonly="" value=""/>
												</td>
											</tr>
											<tr>
												<td><br/></td>
												<td class="t1" align="right">
													<xsl:value-of select="$lng/phonework"/>
												</td>
												<td class="t2" colspan="7" align="left">
													<input type="text" size="10" class="t2" name="phone_work[{id}]" id="phone_work{id}" onchange="check_client_info()" onkeypress="check_client_info()"/>
													<input type="text" class="readonly e" id="phone_work_read{id}" readonly="" value=""/>
													<xsl:value-of select="$lng/example"/>
													<xsl:value-of select="' '"/>
													0219343100
												</td>										
											</tr>
											<tr>
												<td><br/></td>
												<td class="t1" align="right">
													<xsl:value-of select="$lng/phonemobile"/>
												</td>
												<td class="t2" colspan="7" align="left">
													<input type="text" size="10" class="t2" name="phone_mobile[{id}]" id="phone_mobile{id}" onchange="check_client_info()" onkeypress="check_client_info()"/>
													<input type="text" class="readonly e" id="phone_mobile_read{id}" readonly="" value=""/>
													<xsl:value-of select="$lng/example"/>
													<xsl:value-of select="' '"/>
													0826640702
												</td>										
											</tr>
											<tr>
												<td><br/></td>
												<td class="t1" align="right">
													<xsl:value-of select="$lng/email"/>
												</td>
												<td class="t2" colspan="7" align="left">
													<input type="text" size="40" class="t2" name="email[{id}]" id="email{id}" onchange="check_client_info()" onkeypress="check_client_info()"/>
													<input type="text" class="readonly e" id="email_read{id}" readonly="" value=""/>
												</td>
											</tr>
											<tr>
												<td><br/></td>
												<td class="t1" align="right" valign="top">
													<xsl:value-of select="$lng/addressd"/>
													<xsl:value-of select="../address"/>
												</td>
												<td class="t2" colspan="7" align="left">
													<textarea cols="40" class="t2" rows="4" name="address[{id}]" id="address{id}" onkeypress="check_client_info()"/>
													<input type="text" class="readonly e" id="address_read{id}" readonly="" value=""/>
												</td>
											</tr>
											<tr>
												<td><br/></td>
												<td class="t1" align="right">
													<xsl:value-of select="$lng/sendnotify"/>
												</td>
												<td class="t2" colspan="7" align="left">
													<select class="t2" name="preference[{id}]" id="preference{id}" onchange="check_client_info()">
														<xsl:attribute name="name">preference[<xsl:value-of select="id"/>]</xsl:attribute>
														<option value="0">
															<xsl:value-of select="$lng/none"/>
														</option>
														<option value="m">
															<xsl:value-of select="$lng/email"/>
														</option>
														<option value="s">
															<xsl:value-of select="$lng/sms"/>
														</option>
														<option value="ms">
															<xsl:value-of select="$lng/email_sms"/>
														</option>
													</select>											
												</td>
											</tr>
											<tr>
												<td><br/></td>
												<td class="t1" align="right" valign="top">
													<xsl:value-of select="$lng/message"/>
												</td>
												<td class="t2" colspan="7" align="left">
													<textarea cols="50" class="t2" rows="4" name="message[{id}]" id="message{id}"/><br/>
													<xsl:value-of select="$lng/ccpoclient"/>
													<input type="checkbox" class="t2">
														<xsl:attribute name="name">ccpoclient[<xsl:value-of select="id"/>]</xsl:attribute>
													</input>
												</td>
											</tr>
											<tr>
												<td><br/></td>
												<td colspan="8"><br/></td>
											</tr>
											<tr>
												<td><br/></td>
												<td class="h1 t1" colspan="8" align="left">
													<xsl:value-of select="$lng/invoice"/>
												</td>
											</tr>
										</xsl:otherwise>
									</xsl:choose>														
								<xsl:if test="../tenderexcess = '1'">
									<tr>
										<td><br/></td>
										<td class="t1" align="right">
											<xsl:value-of select="$lng/excess"/>
										</td>
										<td class="t2" colspan="7" align="left">
											<xsl:value-of select="/response/localprecurrency"/>
											<input type="text" size="7" value="0.00" class="t2" onchange="check_client_info()">
												<xsl:attribute name="name">excess[<xsl:value-of select="id"/>]</xsl:attribute>
												<xsl:attribute name="id">excess<xsl:value-of select="id"/></xsl:attribute>
											</input>
											<xsl:value-of select="/response/localpostcurrency"/>
											<input type="text" class="readonly e" id="excess_read{id}" readonly="" value=""/>
										</td>
									</tr>
								</xsl:if>
									<tr>
										<td><br/></td>
										<td class="t1" align="right">
											<xsl:value-of select="$lng/reason"/>
										</td>
										<td class="t2" colspan="7" align="left">
											<textarea cols="50" class="t2">
												<xsl:attribute name="name">reason[<xsl:value-of select="id"/>]</xsl:attribute>
											</textarea>
										</td>
									</tr>
									<tr>
										<td><br/></td>
										<td class="t1" align="right">
											<xsl:value-of select="$lng/suppliercomment"/>
										</td>
										<td class="t2" colspan="7" align="left">
											<textarea cols="50" class="t2">
												<xsl:attribute name="name">comment[<xsl:value-of select="id"/>]</xsl:attribute>
											</textarea>
										</td>
									</tr>
								<xsl:if test="../tendersalvage='1'">
									<tr>
										<td><br/></td>
										<td class="t1" align="right">
											<xsl:value-of select="$lng/collectsalvage"/>
										</td>
										<td class="t2" colspan="7" align="left">
											<input type="checkbox">
												<xsl:attribute name="name">collectsalvage[<xsl:value-of select="id"/>]</xsl:attribute>
											</input>
										</td>
									</tr>
								</xsl:if>
								</xsl:if>
								<tr><td></td></tr>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="tender/id">
							<xsl:for-each select="tender">
								<xsl:if test="status='4'">
									<xsl:variable name="tenderid" select="id"/>
									<xsl:if test="../cashtender_item/tender=$tenderid">
										<tr><td></td></tr>
										<tr>
											<td></td>
											<td class="h t1" colspan="8" align="left">
												<xsl:value-of select="$lng/cashsettlement"/>
													(<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tender)"/>
													</xsl:attribute>
													<xsl:value-of select="rfq_number"/>
													</a>)
											</td>
										</tr>
										<tr>
											<td></td>
											<td colspan="8">
												<table border="0" width="100%" align="center" cellpadding="2" cellspacing="0" bgcolor="FFFFFF">
													<tr><td></td></tr>
													<tr>
														<td class="h1 t1" align="left">
															<xsl:value-of select="$lng/tenderitem"/>
														</td>
														<td class="h1a t1" align="left">
															<xsl:value-of select="$lng/brand"/>
														</td>
														<td class="h1a t1" align="left">
															<xsl:value-of select="$lng/model"/>
														</td>
														<td class="h1a t1" align="left">
															<xsl:value-of select="$lng/des"/>
														</td>
														<td class="h1a t1" colspan="2" align="right">
															<xsl:value-of select="$lng/amount"/>
														</td>
													</tr>
													<xsl:for-each select="../cashtender_item">
														<xsl:if test="$tenderid=tender">
															<input type="hidden" size="7" value="0.00" class="t2">
																<xsl:attribute name="name">cashtender_item[<xsl:value-of select="id"/>]</xsl:attribute>
																<xsl:attribute name="value"><xsl:value-of select="$tenderid"/></xsl:attribute>
															</input>
															<tr>
																<td class="h2b t2" align="left">
																	<xsl:value-of select="id"/>
																</td>
																<td class="h2c t2" align="left">
																	<xsl:value-of select="brand"/>
																</td>
																<td class="h2c t2" align="left">
																	<xsl:value-of select="model"/>
																</td>
																<td class="h2c t2" align="left">
																	<xsl:value-of select="description"/>
																</td>
																<td class="h2c t2" colspan="2" align="left">
																	<xsl:value-of select="/response/localprecurrency"/>
																	<input type="text" size="7" value="0.00" class="t2">
																		<xsl:attribute name="name">cashamount[<xsl:value-of select="id"/>]</xsl:attribute>
																	</input>
																	<xsl:value-of select="/response/localpostcurrency"/>
																</td>
															</tr>
														</xsl:if>
													</xsl:for-each>
													<tr><td colspan="2"><br/></td></tr>
													<tr>
														<td class="h1 t1" colspan="6" align="left">
															<xsl:value-of select="$lng/info"/>
														</td>
													</tr>
													<tr>
														<td class="t1" colspan="2" align="right">
															<xsl:value-of select="$lng/reason"/>
														</td>
														<td class="t2" colspan="5" align="left">
															<textarea cols="50" class="t2">
																<xsl:attribute name="name">cash[<xsl:value-of select="$tenderid"/>]</xsl:attribute>
															</textarea>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="../nontender_item/tender=$tenderid">
										<tr><td></td></tr>
										<tr>
											<td></td>
											<td class="h t1" colspan="8" align="left">
												<xsl:value-of select="$lng/nontender"/>
													(<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
													</xsl:attribute>
													<xsl:value-of select="rfq_number"/>
													</a>)
											</td>
										</tr>
										<tr>
											<td></td>
											<td colspan="8">
												<table border="0" width="100%" align="center" cellpadding="2" cellspacing="0" bgcolor="FFFFFF">
													<tr><td></td></tr>
													<tr>
														<td class="h1 t1" align="left">
															<xsl:value-of select="$lng/tenderitem"/>
														</td>
														<td class="h1a t1" align="left">
															<xsl:value-of select="$lng/brand"/>
														</td>
														<td class="h1a t1" align="left">
															<xsl:value-of select="$lng/model"/>
														</td>
														<td class="h1a t1" align="left">
															<xsl:value-of select="$lng/des"/>
														</td>
														<td class="h1a t1" colspan="2" align="right">
															<xsl:value-of select="$lng/suppliername"/>
														</td>
														<td class="h1a t1" colspan="2" align="right">
															<xsl:value-of select="$lng/amount"/>
														</td>
													</tr>
													<xsl:for-each select="../nontender_item">
														<xsl:if test="$tenderid=tender">
															<input type="hidden" size="7" value="0.00" class="t2">
																<xsl:attribute name="name">nontender_item[<xsl:value-of select="id"/>]</xsl:attribute>
																<xsl:attribute name="value"><xsl:value-of select="$tenderid"/></xsl:attribute>
															</input>
															<tr>
																<td class="h2b t2" align="left">
																	<xsl:value-of select="id"/>
																</td>
																<td class="h2c t2" align="left">
																	<xsl:value-of select="brand"/>
																</td>
																<td class="h2c t2" align="left">
																	<xsl:value-of select="model"/>
																</td>
																<td class="h2c t2" align="left">
																	<xsl:value-of select="description"/>
																</td>
																<td class="h2c t2" colspan="2" align="left">
																	<input type="text" size="10" value="" class="t2">
																		<xsl:attribute name="name">nontendername[<xsl:value-of select="id"/>]</xsl:attribute>
																	</input>
																</td>
																<td class="h2c t2" colspan="2" align="left">
																	<xsl:value-of select="/response/localprecurrency"/>
																	<input type="text" size="7" value="0.00" class="t2">
																		<xsl:attribute name="name">nontenderamount[<xsl:value-of select="id"/>]</xsl:attribute>
																	</input>
																	<xsl:value-of select="/response/localpostcurrency"/>
																</td>
															</tr>
														</xsl:if>
													</xsl:for-each>
													<tr><td colspan="2"><br/></td></tr>
													<tr>
														<td class="h1 t1" colspan="6" align="left">
															<xsl:value-of select="$lng/info"/>
														</td>
													</tr>
													<tr>
														<td class="t1" colspan="2" align="right">
															<xsl:value-of select="$lng/reason"/>
														</td>
														<td class="t2" colspan="5" align="left">
															<textarea cols="50" class="t2">
																<xsl:attribute name="name">nontender[<xsl:value-of select="$tenderid"/>]</xsl:attribute>
															</textarea>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="../invalidatetender_item/tender=$tenderid">
										<tr><td></td></tr>
										<tr>
											<td></td>
											<td class="h t1" colspan="8" align="left">
												<xsl:value-of select="$lng/invalidate"/>
												(<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
												</xsl:attribute>
												<xsl:value-of select="rfq_number"/>
												</a>)
											</td>
										</tr>
										<tr>
											<td></td>
											<td colspan="8">
												<table border="0" width="100%" align="center" cellpadding="2" cellspacing="0" bgcolor="FFFFFF">
													<tr><td></td></tr>
													<tr>
														<td class="h1 t1" align="left">
															<xsl:value-of select="$lng/tenderitem"/>
														</td>
														<td class="h1a t1" align="left">
															<xsl:value-of select="$lng/brand"/>
														</td>
														<td class="h1a t1" align="left">
															<xsl:value-of select="$lng/model"/>
														</td>
														<td class="h1a t1" align="left">
															<xsl:value-of select="$lng/des"/>
														</td>
													</tr>
													<xsl:for-each select="../invalidatetender_item">
														<xsl:if test="$tenderid=tender">
															<input type="hidden" size="7" value="0.00" class="t2">
																<xsl:attribute name="name">invalidatetender_item[<xsl:value-of select="id"/>]</xsl:attribute>
																<xsl:attribute name="value"><xsl:value-of select="$tenderid"/></xsl:attribute>
															</input>
															<tr>
																<td class="h2b t2" align="left">
																	<xsl:value-of select="id"/>
																</td>
																<td class="h2c t2" align="left">
																	<xsl:value-of select="brand"/>
																</td>
																<td class="h2c t2" align="left">
																	<xsl:value-of select="model"/>
																</td>
																<td class="h2c t2" align="left">
																	<xsl:value-of select="description"/>
																</td>
															</tr>
														</xsl:if>
													</xsl:for-each>
													<tr><td colspan="2"><br/></td></tr>
													<tr>
														<td class="h1 t1" colspan="6" align="left">
															<xsl:value-of select="$lng/info"/>
														</td>
													</tr>
													<tr>
														<td class="t1" colspan="2" align="right">
															<xsl:value-of select="$lng/reason"/>
														</td>
														<td class="t2" colspan="5" align="left">
															<textarea cols="50" class="t2">
																<xsl:attribute name="name">invalidate[<xsl:value-of select="$tenderid"/>]</xsl:attribute>
															</textarea>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</xsl:if>
									<tr><td></td></tr>
								</xsl:if>
							</xsl:for-each>
						</xsl:if>
						<tr>
							<td></td>
							<td align="right" colspan="8">
								<input type="text" name="display_text" class="readonly e" value="" readonly=""/>
								<input type="submit" name="award" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								<xsl:if test="tenderexcess='1'">
									<xsl:attribute name="onClick">return excessCheck();</xsl:attribute>
								</xsl:if>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
<xsl:if test="tenderexcess='1'">
		function excessCheck() {
	<xsl:if test="awardtender/id">
		<xsl:for-each select="awardtender">
			if (document.report.excess<xsl:value-of select="id"/>.value == '' || document.report.excess<xsl:value-of select="id"/>.value == '0.00' || document.report.excess<xsl:value-of select="id"/>.value == '0') {
				var conf=confirm("<xsl:value-of select="$lng/excesscheck"/>");
				if (conf) {
					return true ;
				} else {
					document.report.excess<xsl:value-of select="id"/>.focus();
					return false ;
				}
			}
			</xsl:for-each>
	</xsl:if>
		}
</xsl:if>
		
		function check_client_info() {
			var good = 1;
			<xsl:if test="awardtender/id">
				<xsl:for-each select="awardtender">
					<xsl:if test="../tenderexcess='1'">
						if(document.report.excess<xsl:value-of select="id"/>.value == '') {
							good = 0;
							document.report.excess_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/required"/>';
						} else if(document.report.excess<xsl:value-of select="id"/>.value > <xsl:value-of select="sum"/>) {
							good = 0;
							document.report.excess_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/morethangrandtotal"/>';
						} else {
							document.report.excess_read<xsl:value-of select="id"/>.value = '';
						}
					</xsl:if>
					<xsl:if test="awardtoself='1'">
						if(document.report.title<xsl:value-of select="id"/>.value == '') {
							good = 0;
							document.report.title_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/required"/>';
						} else {
							document.report.title_read<xsl:value-of select="id"/>.value = '';
						}
					</xsl:if>
					if(document.report.address<xsl:value-of select="id"/>.value == '') {
						good = 0;
						document.report.address_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/required"/>';
					} else {
						document.report.address_read<xsl:value-of select="id"/>.value = '';
					}
					if(document.report.surname<xsl:value-of select="id"/>.value == '') {
						good = 0;
						document.report.surname_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/required"/>';
					} else {
						document.report.surname_read<xsl:value-of select="id"/>.value = '';
					}
					if(document.report.phone_work<xsl:value-of select="id"/>.value == '') {
						good = 0;
						document.report.phone_work_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/required"/>';
					} else {
						document.report.phone_work_read<xsl:value-of select="id"/>.value = '';
						<xsl:if test="../constraints">
							if(document.report.phone_work<xsl:value-of select="id"/>.value.length &lt; <xsl:value-of select="../constraints/phonemin"/> ) {
								good = 0;
								document.report.phone_work_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/tooshort"/>';
							}
							if(document.report.phone_work<xsl:value-of select="id"/>.value.length &gt; <xsl:value-of select="../constraints/phonemax"/> ) {
								good = 0;
								document.report.phone_work_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/toolong"/>';
							}
						</xsl:if>
					}
					if(document.report.phone_mobile<xsl:value-of select="id"/>.value == '' &amp;&amp; 
					   (document.report.preference<xsl:value-of select="id"/>.value == 's' || document.report.preference<xsl:value-of select="id"/>.value == 'ms')) {
						good = 0;
						document.report.phone_mobile_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/required"/>';
					} else {
						document.report.phone_mobile_read<xsl:value-of select="id"/>.value = '';
						<xsl:if test="../constraints">
							if(document.report.phone_mobile<xsl:value-of select="id"/>.value.length &gt; 0) {
								if(document.report.phone_mobile<xsl:value-of select="id"/>.value.length &lt; <xsl:value-of select="../constraints/phonemin"/> ) {
									good = 0;
									document.report.phone_mobile_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/tooshort"/>';
								}
								if(document.report.phone_mobile<xsl:value-of select="id"/>.value.length &gt; <xsl:value-of select="../constraints/phonemax"/> ) {
									good = 0;
									document.report.phone_mobile_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/toolong"/>';
								}
							}
						</xsl:if>
					}
					if(document.report.email<xsl:value-of select="id"/>.value == '' &amp;&amp; 
					   (document.report.preference<xsl:value-of select="id"/>.value == 'm' || document.report.preference<xsl:value-of select="id"/>.value == 'ms')) {
						good = 0;
						document.report.email_read<xsl:value-of select="id"/>.value = '<xsl:value-of select="$lng/required"/>';
					} else {
						document.report.email_read<xsl:value-of select="id"/>.value = '';
					}
				</xsl:for-each>
			</xsl:if>
			if(good == 1) {
				document.report.award.disabled = 0;
				document.report.display_text.value = '';
			} else {
				document.report.award.disabled = 1;
				document.report.display_text.value = '<xsl:value-of select="$lng/missinginfo"/>';
			}
		}
		check_client_info();
		<xsl:if test="awardtender/id">
			<xsl:for-each select="awardtender">
				<xsl:variable name="mid" select="id"/>
		document.report.message<xsl:value-of select="$mid"/>.value = '<xsl:value-of select="$lng/rfq"/><xsl:value-of select="' '"/><xsl:value-of select="rfq_number"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/hasbeenapproved"/>.';
				<xsl:for-each select="supplier">
					<xsl:variable name="supplier" select="name"/>
					<xsl:variable name="supplierid" select="id"/>
						<xsl:for-each select="agent">
		document.report.message<xsl:value-of select="$mid"/>.value += '<xsl:value-of select="' '"/><xsl:value-of select="name"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/of"/><xsl:value-of select="' '"/><xsl:value-of select="$supplier"/>';
		document.report.message<xsl:value-of select="$mid"/>.value += '<xsl:value-of select="' ('"/><xsl:value-of select="phone_work"/><xsl:value-of select="')'"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/willhandlereplacement"/><xsl:value-of select="' '"/>';
						<xsl:for-each select="quote">
						<xsl:if test="classification='1'">
		document.report.message<xsl:value-of select="$mid"/>.value += '<xsl:value-of select="brand"/><xsl:value-of select="' '"/><xsl:value-of select="model"/>';
							<xsl:choose>
								<xsl:when test="position() = last()">
							
								</xsl:when>
								<xsl:when test="position() + 1 = last() and (../../../transport='d' or ../../../transport='i')">

								</xsl:when>
								<xsl:when test="position() + 1 = last() and ../../../transport!='d' and ../../../transport!='i'">
		document.report.message<xsl:value-of select="$mid"/>.value += '<xsl:value-of select="' '"/><xsl:value-of select="$lng/and"/><xsl:value-of select="' '"/>';
								</xsl:when>
								<xsl:when test="position() + 2 = last() and (../../../transport='d' or ../../../transport='i')">
		document.report.message<xsl:value-of select="$mid"/>.value += '<xsl:value-of select="' '"/><xsl:value-of select="$lng/and"/><xsl:value-of select="' '"/>';
								</xsl:when>
								
								<xsl:otherwise>
		document.report.message<xsl:value-of select="$mid"/>.value += '<xsl:value-of select="', '"/>';								
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
						</xsl:for-each>
		document.report.message<xsl:value-of select="$mid"/>.value += '.';
					</xsl:for-each>
				</xsl:for-each>
				
			</xsl:for-each>
		</xsl:if>
		
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
