<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/resulttender"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="award"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="purchase_order">
							<tr>
								<td><br/></td>
								<td class="h t1" align="left">
									<xsl:value-of select="$lng/rfqnumber"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/subscriber"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/agent"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/items"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/message"/>
								</td>
								<xsl:if test="tenderexcess='1'">
									<td class="ha t1" align="left">
										<xsl:value-of select="$lng/excess"/>
									</td>
								</xsl:if>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/purchaseorder"/>
								</td>
							</tr>
							<xsl:for-each select="purchase_order">
								<tr>
									<td><br/></td>
									<td class="h2b t2" align="left">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tender)"/>
											</xsl:attribute>
											<xsl:value-of select="rfq_number"/>
										</a>
									</td>
									<td class="h2c t2" align="left">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',agent/id)"/>
											</xsl:attribute>
											<xsl:value-of select="agent/name"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="agent/surname"/>
										</a>
									</td>
									<td class="h2c t2" align="left">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',subscriber/id)"/>
											</xsl:attribute>
											<xsl:value-of select="subscriber/name"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="subscriber/surname"/>
										</a>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="count"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="agent_message"/>
									</td>
									<xsl:if test="../tenderexcess='1'">
										<td class="h2c t2" align="left">
											<xsl:value-of select="/response/localprecurrency"/>
											<xsl:value-of select="client_excess"/>
											<xsl:if test="client_excess=''">
												<xsl:value-of select="'0.00'"/>
											</xsl:if>
											<xsl:value-of select="/response/localpostcurrency"/>
										</td>
									</xsl:if>
									<td class="h2c t2" align="left">
										<xsl:value-of select="id"/>
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=authenticate_purchase_order&amp;auth_string=',authentication,'&amp;tenderid=',tender,'&amp;language=',/response/user/language)"/>
											</xsl:attribute>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="$lng/clicktoview"/>
										</a>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
						<tr><td colspan="7"><br/></td></tr>
						<xsl:if test="invalidatetender_item or cashtender_item or nontender_item">
							<tr>
								<td><br/></td>
								<td class="h t1" align="left">
									<xsl:value-of select="$lng/status"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/tenderitem"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/brand"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/model"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/reason"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/amount"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/nontender"/>
								</td>
							</tr>
							<xsl:for-each select="nontender_item">
								<tr>
									<td><br/></td>
									<td class="h1b t2" align="left">
										<xsl:value-of select="$lng/nontender"/>
									</td>
									<td class="h2c t2" align="left">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',id)"/>
											</xsl:attribute>
											<xsl:value-of select="id"/>
										</a>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="brand"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="model"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="reason"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="cash"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="nontender"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:for-each select="cashtender_item">
								<tr>
									<td><br/></td>
									<td class="h1b t2" align="left">
										<xsl:value-of select="$lng/cash"/>
									</td>
									<td class="h2c t2" align="left">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',id)"/>
											</xsl:attribute>
											<xsl:value-of select="id"/>
										</a>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="brand"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="model"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="reason"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="cash"/>
									</td>
									<td class="h2c t2" align="left"></td>
								</tr>
							</xsl:for-each>
							<xsl:for-each select="invalidatetender_item">
								<tr>
									<td><br/></td>
									<td class="h1b t2" align="left">
										<xsl:value-of select="$lng/invalid"/>
									</td>
									<td class="h2c t2" align="left">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',id)"/>
											</xsl:attribute>
											<xsl:value-of select="id"/>
										</a>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="brand"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="model"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="reason"/>
									</td>
									<td class="h2c t2" align="left"></td>
									<td class="h2c t2" align="left"></td>
								</tr>
							</xsl:for-each>
						</xsl:if>
					</table>			
				<xsl:if test="opentenders/rfq_number">
					<br/><br/>
					<b><xsl:value-of select="$lng/awardother"/></b>
					<br/><br/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
						<xsl:if test="user/permission &gt; 1">
							<td class="ha t1">
								<xsl:value-of select="$lng/requestor"/>
							</td>
						</xsl:if>
							<td class="ha t1">
								<xsl:value-of select="$lng/location"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/trans"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/createdon"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/closedon"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/action"/>
							</td>
						</tr>
						<xsl:for-each select="opentenders">
							<tr>
								<td><br/></td>
								<td class="h2b t2" align="left">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
										</xsl:attribute>
										<xsl:value-of select="rfq_number"/>
									</a>
								</td>
								<td class="h2c t2" align="left">
									<xsl:value-of select="rfq_reference"/>
								</td>
							<xsl:if test="/response/user/permission&gt;1">
								<td class="h2c t2">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
										</xsl:attribute>
										<xsl:value-of select="name"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="surname"/>
									</a>
								</td>
							</xsl:if>
								<td class="h2c t2" align="left">
									<xsl:value-of select="statename"/>/<br/>
									<xsl:value-of select="areaname"/>
								</td>
								<td class="h2c t2" align="left">
									<xsl:choose>
										<xsl:when test="transport='c'">
											<xsl:value-of select="$lng/collect"/>
										</xsl:when>
										<xsl:when test="transport='d'">
											<xsl:value-of select="$lng/deliver"/>
										</xsl:when>
										<xsl:when test="transport='i'">
											<xsl:value-of select="$lng/install"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$lng/unknown"/>
											<xsl:value-of select="'('"/>
											<xsl:value-of select="transport"/>
											<xsl:value-of select="')'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="h2c t2" align="left">
									<xsl:value-of select="created_date"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="created_time"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="../localdisplay"/>
								</td>
								<td class="h2c t2" align="left">
									<xsl:value-of select="close_date"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="close_time"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="../localdisplay"/>
								</td>
								<td class="h2c t2" align="left">
							<xsl:choose>
								<xsl:when test="/response/subscriber_organisation_id">
									<a target="main">
										<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=report&amp;function=company&amp;tenderid=',./tenderid,'&amp;organisationid=',../subscriber_organisation_id,'&amp;reporttype=tender_group_by_quote')"/></xsl:attribute>
										<xsl:value-of select="$lng/award"/>
									</a>
								</xsl:when>
								<xsl:otherwise>
									<a target="main">
										<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=report&amp;function=company&amp;tenderid=',./tenderid,'&amp;reporttype=tender_group_by_quote')"/></xsl:attribute>
										<xsl:value-of select="$lng/award"/>
									</a>
								</xsl:otherwise>
							</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
					
					
					
					
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>