<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<xsl:param name="display" select="/response/display"/>
<xsl:param name="more" select="/response/more"/>
<xsl:param name="type" select="/response/type"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/controlpanel"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/controlpanel"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'user'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="module"/>
					<input type="hidden" name="function" value="function"/>
					<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>			
							<td align="left" colspan="5" class="t1">
								<xsl:value-of select="$lng/welcome"/><xsl:value-of select="' '"/><xsl:value-of select="user/name"/>
								<br/><br/>
							</td>
						</tr>
						<tr>
							<td><br/></td>			
							<td align="left" colspan="5" class="t">
								<xsl:for-each select="$lng/subscribermessage">
									<xsl:value-of select="."/><br/>
								</xsl:for-each>
								<br/>
							</td>
						</tr>
						<xsl:if test="opentenders/rfq_number">
							<tr>
								<td><br/></td>
								<td class="h t1">
									<xsl:value-of select="$lng/rfqnumber"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/rfqreference"/>
								</td>
							<xsl:if test="user/permission &gt; 1">
								<td class="ha t1">
									<xsl:value-of select="$lng/requestor"/>
								</td>
							</xsl:if>
								<td class="ha t1">
									<xsl:value-of select="$lng/area"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/transport"/>
								</td>
							</tr>
							<xsl:for-each select="opentenders">
								<tr>
									<td><br/></td>
									<td class="h2b t2" align="left">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
											</xsl:attribute>
											<xsl:value-of select="rfq_number"/>
										</a>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="rfq_reference"/>
									</td>
								<xsl:if test="../user/permission &gt; 1">
									<td class="h2c t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
											</xsl:attribute>
											<xsl:value-of select="name"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="surname"/>
										</a>
									</td>
								</xsl:if>
									<td class="h2c t2" align="left">
										<xsl:value-of select="areaname"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:choose>
											<xsl:when test="transport='c'">
												<xsl:value-of select="$lng/collect"/>
											</xsl:when>
											<xsl:when test="transport='d'">
												<xsl:value-of select="$lng/deliver"/>
											</xsl:when>
											<xsl:when test="transport='i'">
												<xsl:value-of select="$lng/install"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
						<tr><td><br/></td></tr>
						<xsl:if test="closetenders/rfq_number">
							<tr>
								<td><br/></td>
								<td class="h t1">
									<xsl:value-of select="$lng/rfqnumber"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/rfqreference"/>
								</td>
							<xsl:if test="user/permission &gt; 1">
								<td class="ha t1">
									<xsl:value-of select="$lng/requestor"/>
								</td>
							</xsl:if>
								<td class="ha t1">
									<xsl:value-of select="$lng/area"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/transport"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/award"/>
								</td>
							</tr>
							<xsl:for-each select="closetenders">
								<tr>
									<td><br/></td>
									<td class="h2b t2" align="left">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
											</xsl:attribute>
											<xsl:value-of select="rfq_number"/>
										</a>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="rfq_reference"/>
									</td>
								<xsl:if test="../user/permission &gt; 1">
									<td class="h2c t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
											</xsl:attribute>
											<xsl:value-of select="name"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="surname"/>
										</a>
									</td>
								</xsl:if>
									<td class="h2c t2" align="left">
										<xsl:value-of select="areaname"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:choose>
											<xsl:when test="transport='c'">
												<xsl:value-of select="$lng/collect"/>
											</xsl:when>
											<xsl:when test="transport='d'">
												<xsl:value-of select="$lng/deliver"/>
											</xsl:when>
											<xsl:when test="transport='i'">
												<xsl:value-of select="$lng/install"/>
											</xsl:when>
											<xsl:when test="transport='e'">
												<xsl:value-of select="$lng/email"/>
											</xsl:when>
											<xsl:when test="transport='f'">
												<xsl:value-of select="$lng/fax"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c t2" align="left">
										<a target="main">
											<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=report&amp;function=company&amp;tenderid=',./tenderid,'&amp;reporttype=quote')"/></xsl:attribute>
											<xsl:value-of select="$lng/award"/>
										</a>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/passwordchange"/>
				</div>
				<div id="right_content">
					<a href="main.php?module=password&amp;function=change">
						<xsl:value-of select="$lng/passwordchange"/>
					</a>
				</div>
				<div id="right_header">
					<xsl:value-of select="$lng/manual"/>
				</div>
				<div id="right_content">
					<a href="./manuals/{$language}/user_manual.pdf">
						<img src="./theme/{$theme}/icon/pdf.gif" border="0"/>
						<xsl:value-of select="' '"/><xsl:value-of select="$lng/subscribermanual"/>
					</a>
				</div>
				<div id="right_header">
					<xsl:value-of select="$lng/firefox"/>
				</div>
				<div id="right_content">
					<a href="javascript:addEngine()">
						<img src="./theme/{$theme}/icon/firefox.gif" border="0"/>
						<xsl:value-of select="' '"/><xsl:value-of select="$lng/firefoxclick"/>
					</a>
				</div>
			</div>
			<script language="javascript">
				function addEngine() {
					if (typeof window.sidebar == "object" &amp;&amp; typeof window.sidebar.addSearchEngine == "function") {
						url = window.location;
						window.sidebar.addSearchEngine(
				            "http://www.tendersystem.com/firefox/tendersystem.php/u/"+url+"/tendersystem.src",
				            "http://www.tendersystem.com/firefox/tendersystem.gif",
				            "TenderSystem",
				            "Web" 
						);
					} else {
						alert("<xsl:value-of select="$lng/pluginalert"/>");
					}
				}
			</script>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>