<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/groupbyitemreport"/><br/>
			<xsl:if test="startdate!=enddate">
				<xsl:value-of select="' '"/>
				<xsl:value-of select="startdate"/>
				<xsl:value-of select="' - '"/>
				<xsl:value-of select="enddate"/>
			</xsl:if>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="award"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:choose>	
							<xsl:when test="tender/tenderid">
								<tr>
									<td><br/></td>								
									<td class="h t1" align="right" colspan="8">
										<xsl:value-of select="$lng/selectotherreport"/><xsl:value-of select="': '"/>
		
										<select name="reporttype" class="t1" onchange="gotoreport()">
											<xsl:if test="reporttype">
												<xsl:for-each select="reporttype">
													<option value="{value}">
														<xsl:if test="value='tender_group_by_item'">
															<xsl:attribute name="selected"/>	
														</xsl:if>
														<xsl:value-of select="name"/>
													</option>
												</xsl:for-each>
											</xsl:if>
											<option value="audit"><xsl:value-of select="$lng/audittrail"/></option>
											<option value="close"><xsl:value-of select="$lng/closedtenders"/></option>
											<option value="awarded"><xsl:value-of select="$lng/awardedtenders"/></option>
											<option value="bordereaux"><xsl:value-of select="$lng/bordereaux"/></option>
											<option value="balance"><xsl:value-of select="$lng/balancescorecard"/></option>
											<option value="user_fees"><xsl:value-of select="$lng/fees"/></option>
										</select>

										<input name="print" type="button" value="{$lng/print}" onclick="window.print()" class="t2"/>
									</td>
								</tr>
									<xsl:for-each select="tender">
									<xsl:if test="status='4' or status='6'">
										<tr>
											<td><br/></td>
											<td class="hb t1">
												<xsl:value-of select="$lng/subscriber"/>
											</td>
											<td class="hc t2">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
													</xsl:attribute>
													<xsl:value-of select="name"/>
													<xsl:value-of select="' '"/>
													<xsl:value-of select="surname"/>
												</a>
											</td>
											<td class="hc t1">
												<xsl:value-of select="$lng/rfqnumber"/>
											</td>
											<td class="hc t2">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
													</xsl:attribute>
													<xsl:value-of select="rfq_number"/>
												</a>
											</td>
											<td class="hc t1">
												<xsl:value-of select="$lng/rfqreference"/>
											</td>
											<td class="hc t2">
												<xsl:value-of select="rfq_reference"/>
											</td>
											<td class="hc t1">
												<xsl:value-of select="$lng/area"/>
											</td>
											<td class="hc t2">
												<xsl:value-of select="areaname"/>
											</td>
										</tr>
										<tr>
											<td><br/></td>
											<td class="hb t1">
												<xsl:value-of select="$lng/email"/>
											</td>
											<td class="hc t2">
												<a>
													<xsl:attribute name="href">mailto:<xsl:value-of select="email"/></xsl:attribute>
													<xsl:value-of select="email"/>
												</a>
											</td>
											<td class="hc t1">
												<xsl:value-of select="$lng/phonework"/>
											</td>
											<td class="hc t2">
												<a>
													<xsl:attribute name="href">
														<xsl:value-of select="'callto://+'"/>
														<xsl:value-of select="phone_prefix"/>
														<xsl:number value="phone_work" format="1"/>
													</xsl:attribute>
													<xsl:value-of select="phone_work"/>
												</a>
											</td>
											<td class="hc t1">
												<xsl:value-of select="$lng/createdon"/>
											</td>
											<td class="hc t2">
												<xsl:value-of select="created_date"/>
												<xsl:value-of select="' '"/>
												<xsl:value-of select="created_time"/>
											</td>
											<td class="hc t1">
												<xsl:value-of select="$lng/closeon"/>
											</td>
											<td class="hc t2">
												<xsl:value-of select="close_date"/>
												<xsl:value-of select="' '"/>
												<xsl:value-of select="close_time"/>
											</td>
										</tr>
										<xsl:variable name="tenderid" select="tenderid"/>
										<xsl:variable name="tenderstatus" select="status"/>
										<xsl:if test="../tenderitem/tender">
										<tr>
										<td></td>
										<td colspan="8" class="h2b">
											<table border="0" width="100%" cellpadding="2" cellspacing="0" bgcolor="FFFFFF">
												<xsl:for-each select="../tenderitem">
													<xsl:if test="$tenderid=tender">
														<tr><td></td></tr>
														<tr>
															<td class="h1 t1">
																<xsl:value-of select="$lng/brand"/>
															</td>
															<td class="h1a t2">
																<xsl:value-of select="brand"/>
															</td>
															<td class="h1a t1">
																<xsl:value-of select="$lng/model"/>
															</td>
															<td class="h1a t2">
																<xsl:value-of select="model"/>
															</td>
														</tr>
														<tr>	
															<td class="h1b t1">
																<xsl:value-of select="$lng/description"/>
															</td>
															<td class="h1c t2" colspan="3">
																<xsl:value-of select="description"/>																
															</td>
														</tr>
														
															<tr>
																<td class="h2b" colspan="6">
																	<table border="0" cellpadding="2" width="100%" cellspacing="0" bgcolor="FFFFFF">
																		<tr>
																			<td class="h1 t1">
																				<xsl:value-of select="$lng/supplier"/>
																			</td>
																			<td class="h1a t1">
																				<xsl:value-of select="$lng/agent"/>
																			</td>
																			<td class="h1a t1">
																				<xsl:value-of select="$lng/brand"/>
																			</td>																			
																			<td class="h1a t1">
																				<xsl:value-of select="$lng/model"/>
																			</td>
																			<td class="h1a t1">
																				<xsl:value-of select="$lng/description"/>
																			</td>
																			<td class="h1a t1">
																				<xsl:value-of select="$lng/stock"/>
																			</td>
																			<td class="h1a t1">
																				<xsl:value-of select="$lng/position"/>
																			</td>
																			<td class="h1a t1">
																				<xsl:value-of select="$lng/price"/>
																			</td>
																			<td class="h1a t1">
																				<xsl:value-of select="$lng/award"/>
																			</td>
																			<td class="h1a t1" valign="top">
																				<xsl:if test="../tenderawardcashoption">
																					<xsl:value-of select="$lng/cashsettlement"/>
																				</xsl:if>
																			</td>
																			<td class="h1a t1" valign="top">
																				<xsl:if test="../tenderawardnontenderoption">
																					<xsl:value-of select="$lng/nontender"/>
																				</xsl:if>	
																			</td>
																			<td class="h1a t1" align="right" valign="top">
																				<xsl:if test="../tenderawardinvalidateoption">	
																					<xsl:value-of select="$lng/invalidate"/>
																				</xsl:if>
																			</td>	
																		</tr>
																		<xsl:variable name="itemid" select="tenderitemid"/>
																		<xsl:for-each select="../tenderquote">
																			<xsl:if test="($itemid=tender_item and $tenderid=tender) or (classification!='1' and $tenderid=tender)">
																				<tr>
																					<td class="h2b t2">
																						<a target="main">
																							<xsl:attribute name="href">
																								<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',./organisationid)"/>
																							</xsl:attribute>
																							<xsl:value-of select="organisationname"/>
																						</a>
																					</td>
																					<td class="h2c t2">
																						<a target="main">
																							<xsl:attribute name="href">
																								<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
																							</xsl:attribute>
																							<xsl:value-of select="name"/>
																							<xsl:value-of select="' '"/>
																							<xsl:value-of select="surname"/>
																						</a>
																					</td>
																					<td class="h2c t2" valign="top">
																						<xsl:value-of select="brand"/>
																					</td>
																					<td class="h2c t2" valign="top">
																						<xsl:value-of select="model"/>
																					</td>
																					<td class="h2c t2" valign="top">
																						<textarea readonly="" class="readonly t2" cols="35">
																							<xsl:value-of select="description"/>
																						</textarea>
																					</td>														
																					<td class="h2c t2" align="center" valign="top">
																						<xsl:choose>
																							<xsl:when test="type > 2">
																								<img src="./theme/{$theme}/icon/blank.gif">
																									<xsl:attribute name="alt"><xsl:value-of select="$lng/auto"/></xsl:attribute>
																									<xsl:attribute name="title"><xsl:value-of select="$lng/auto"/></xsl:attribute>
																								</img>
																							</xsl:when>
																							<xsl:when test="stock='0'">
																								<xsl:value-of select="$lng/available"/>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:value-of select="stock"/>
																								<xsl:value-of select="' '"/>
																								<xsl:value-of select="$lng/days"/>
																							</xsl:otherwise>
																						</xsl:choose>
																					</td>
																					<td class="h2c t2" valign="top">
																						<xsl:call-template name="position_icon">
																							<xsl:with-param name="position" select="quote_position"/>
																						</xsl:call-template>
																					</td>
																					<td class="h2c t2" valign="top">
																						<xsl:value-of select="/response/localprecurrency"/><xsl:value-of select="price"/><xsl:value-of select="/response/localpostcurrency"/>
																					</td>
																					<td class="h2c t2" valign="top">
																						<xsl:choose>
																							<xsl:when test="status='6' or $tenderstatus='6'">
																								<xsl:call-template name="tender_quote_icon">
																									<xsl:with-param name="classification" select="quoteclass"/>
																									<xsl:with-param name="status" select="status"/>
																									<xsl:with-param name="tenderclassification" select="tenderclassification"/>
																									<xsl:with-param name="itemclassification" select="classification"/>
																								</xsl:call-template>
																							</xsl:when>
																							<xsl:when test="classification != '1'">
																								<xsl:call-template name="tender_quote_icon">
																									<xsl:with-param name="classification" select="quoteclass"/>
																									<xsl:with-param name="status" select="'6'"/>
																									<xsl:with-param name="tenderclassification" select="tenderclassification"/>
																									<xsl:with-param name="itemclassification" select="classification"/>
																								</xsl:call-template>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:choose>
																									<xsl:when test="expire='1'">
																										<xsl:value-of select="$lng/expired"/>
																									</xsl:when>
																									<xsl:otherwise>
																										<input type="radio">
																											<xsl:attribute name="name">tender_item[<xsl:value-of select="tender_item"/>]</xsl:attribute>
																											<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
																										</input>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:otherwise>
																						</xsl:choose>
																					</td>			
																					<xsl:choose>
																						<xsl:when test="classification='3' and quotestatus &lt; '5' and $tenderstatus &lt; '5'">
																							<td class="h2c t1" valign="top" colspan="3">
																								<xsl:value-of select="$lng/dontdeliver"/><br/>
																								<input type="checkbox">
																									<xsl:attribute name="name">nodeliver[]</xsl:attribute>
																									<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
																								</input>
																							</td>
																						</xsl:when>
																						<xsl:when test="classification='4' and quotestatus &lt; '5' and $tenderstatus &lt; '5'">
																							<td class="h2c t1" valign="top" colspan="3">
																								<xsl:value-of select="$lng/dontinstall"/>
																								<input type="checkbox">
																									<xsl:attribute name="name">noinstall[]</xsl:attribute>
																									<xsl:attribute name="value"><xsl:value-of select="id"/></xsl:attribute>
																								</input>
																							</td>
																						</xsl:when>
																						<xsl:when test="classification='1' and status &lt; '5'">
																							<td class="h2c t2" valign="top">
																								<xsl:if test="../tenderawardcashoption">
																									<xsl:if test="classification &lt; '3' and status &lt; '5'">
																										<input type="radio" value="cash">
																											<xsl:attribute name="name">tender_item[<xsl:value-of select="tender_item"/>]</xsl:attribute>
																										</input>
																									</xsl:if>
																								</xsl:if>
																							</td>									
																							<td class="h2c t2" valign="top">
																								<xsl:if test="../tenderawardnontenderoption">	
																									<xsl:if test="classification &lt; '3' and status &lt; '5'">
																										<input type="radio" value="nontender">
																											<xsl:attribute name="name">tender_item[<xsl:value-of select="tender_item"/>]</xsl:attribute>
																										</input>
																									</xsl:if>		
																								</xsl:if>	
																							</td>	
																							<td class="h2c t2" valign="top">
																								<xsl:if test="../tenderawardinvalidateoption">
																									<xsl:if test="classification &lt; '3' and status &lt; '5'">
																										<input type="radio" value="invalidate">
																											<xsl:attribute name="name">tender_item[<xsl:value-of select="tender_item"/>]</xsl:attribute>
																										</input>
																									</xsl:if>
																								</xsl:if>		
																							</td>																				
																						</xsl:when>
																						<xsl:otherwise>
																							<td class="h2c t2" align="center" valign="top" colspan="3"><xsl:value-of select="$lng/completed"/></td>
																						</xsl:otherwise>
																					</xsl:choose>																		
																				</tr>	
																			</xsl:if>
																		</xsl:for-each>
																		</table>
																	</td>
																</tr>
															</xsl:if>
														</xsl:for-each>
													</table>
												</td>
											</tr>
										</xsl:if>
										<xsl:if test="status='4'">
											<tr>
												<td align="right" colspan="9">
													<input type="submit" name="submit" class="t2">
														<xsl:attribute name="value">
															<xsl:value-of select="$lng/submit"/>
														</xsl:attribute>
													</input>
												</td>
											</tr>
										</xsl:if>
										<tr><td><br/></td></tr>
									</xsl:if>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<xsl:for-each select="$lng/noquote">
									<xsl:value-of select="."/><br/>
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function gotoreport() {
			var otherreport = document.report.reporttype.value;
			var startdate = "<xsl:value-of select="reportinfo/startdate"/>";
			var enddate = "<xsl:value-of select="reportinfo/enddate"/>";
			var URL = "./main.php?module=report&amp;function=company&amp;reporttype=" + otherreport+"&amp;display=1"+"&amp;reportformat=online"+"&amp;startdate=" + startdate + "&amp;enddate=" + enddate;
			<xsl:if test="reportinfo/stateid != 0">
				URL += "&amp;stateid=" + <xsl:value-of select="reportinfo/stateid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/areaid != 0">
				URL += "&amp;areaid=" + <xsl:value-of select="reportinfo/areaid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/branchid != 0">
				URL += "&amp;branchid=" + <xsl:value-of select="reportinfo/branchid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/usersid != 0">
				URL += "&amp;usersid=" + <xsl:value-of select="reportinfo/usersid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/firstsort">
				URL += "&amp;firstsort=" + "<xsl:value-of select="reportinfo/firstsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/secondsort">
				URL += "&amp;secondsort=" + "<xsl:value-of select="reportinfo/secondsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/group">
				URL += "&amp;group=" + "<xsl:value-of select="reportinfo/group"/>";
			</xsl:if>
			<xsl:if test="reportinfo/organisationid">
				URL += "&amp;organisationid=" + <xsl:value-of select="reportinfo/organisationid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/rfqnumber">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqnumber"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/rfqreference">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqreference"/>";
			</xsl:if>
			parent.main.location.href = URL;
		}		
	</script>			
</body>
</html>

</xsl:template>

</xsl:stylesheet>
