<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- area java script -->
<xsl:include href="../../area/templates/state_script.xsl"/>
<xsl:include href="../../procure/templates/procure_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderinvitation"/>
			<xsl:if test="subscriber/usersid and subscriber/usersid!=user/usersid">
				<xsl:value-of select="' ('"/>
				<a target="main">
					<xsl:attribute name="href">
						<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',subscriber/usersid)"/>
					</xsl:attribute>
					<xsl:value-of select="subscriber/name"/>
					<xsl:value-of select="' '"/>
					<xsl:value-of select="subscriber/surname"/>
				</a>
				<xsl:value-of select="')'"/>
			</xsl:if>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="invitation"/>
					<table border="0" align="center" cellpadding="10" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td align="left" valign="top">
								<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
								<!-- These templates are in tender/templates/tender_generic.xsl  and area/templates/state_script.xsl
						     		 So that Other Modules can use them -->
									<xsl:call-template name="rfq_number_field"/>
									<xsl:call-template name="rfq_reference_field"/>
									<xsl:call-template name="state_field"/>
									<xsl:call-template name="area_field"/>
									<xsl:call-template name="attachment_field"/>
									<tr>
										<td colspan="2"><br/></td>
									</tr>
									<tr>
										<td align="right" class="t2" colspan="3">
											<input type="submit" name="action" value="{$lng/submit}" class="t2"/>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header"><xsl:value-of select="$lng/instheader"/></div>
				<div id="right_content">
					<xsl:for-each select="$lng/inst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<script type="text/javascript">
		document.report.rfq_number.focus();
		<xsl:call-template name="state_script"/>
		update_state();
	</script>
	<xsl:call-template name="footer"/>
</body>
</html>
</xsl:template>
</xsl:stylesheet>