<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- area java script -->
<xsl:include href="../../area/templates/state_script.xsl"/>
<xsl:include href="../../procure/templates/procure_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<link rel="stylesheet" type="text/css" media="all" href="./theme/{$theme}/style_calendar.css"/>		
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderinvitation"/>
			<xsl:if test="subscriber/usersid and subscriber/usersid!=user/usersid">
				<xsl:value-of select="' ('"/>
				<a target="main">
					<xsl:attribute name="href">
						<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',subscriber/usersid)"/>
					</xsl:attribute>
					<xsl:value-of select="subscriber/name"/>
					<xsl:value-of select="' '"/>
					<xsl:value-of select="subscriber/surname"/>
				</a>
				<xsl:value-of select="')'"/>
			</xsl:if>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="post_invitation"/>
					<table border="0" align="center" cellpadding="10" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td align="left" valign="top">
								<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
									<tr>
										<td class="h t1" colspan="2"><xsl:value-of select="$lng/tenderinfo"/></td>
									</tr>
								<xsl:if test="rfq_exists">
									<tr>
										<td class="t1" colspan="2"><br/></td>
									</tr>
									<tr>
										<td class="e" colspan="2"><xsl:value-of select="$lng/rfqexists"/></td>
									</tr>
									<tr>
										<td class="t1" colspan="2"><br/></td>
									</tr>								
								</xsl:if>
								<!-- These templates are in tender/templates/tender_generic.xsl  and area/templates/state_script.xsl
						     		 So that Other Modules can use them -->
						     		 
									<xsl:call-template name="rfq_number_field"/>
									<xsl:call-template name="rfq_reference_field"/>
									<tr>
										<td class="t1"><xsl:value-of select="$lng/tenderclosingdate"/></td>
										<td class="t2">
											<input type="text" name="closedate" id="closedate" value="{today}" class="t2" size="10" maxlength="10"/>
											<xsl:value-of select="' '"/>
											<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_startdate" style="cursor: pointer; border: 0px;" alt="Date selector" />
											<xsl:value-of select="'  '"/>
										</td>										
									</tr>
									<tr>
										<td class="t1"><xsl:value-of select="$lng/tenderclosingtime"/></td>
										<td class="t2">
											<input type="text" name="closehour" size="1" maxlenght="2" class="t2" value="{hour}"/>:
											<input type="text" name="closemin" size="1" maxlenght="2" class="t2" value="{min}"/>
										</td>										
									</tr>


									<tr>
										<td class="t1"><xsl:value-of select="$lng/trans"/></td>
										<td class="t2">
									<xsl:if test="collect='1'">
											<input type="radio" name="transport" value="c" class="t1">
										<xsl:if test="procure/transport='c'">
												<xsl:attribute name="checked"/>
										</xsl:if>
											</input>
											<xsl:value-of select="$lng/collect"/>
									</xsl:if>
											<input type="radio" name="transport" value="d" class="t1">
										<xsl:if test="procure/transport='d'">
												<xsl:attribute name="checked"/>
										</xsl:if>
											</input>
											<xsl:value-of select="$lng/deliver"/>
											<input type="radio" name="transport" value="i" class="t1">
										<xsl:if test="procure/transport='i'">
												<xsl:attribute name="checked"/>
										</xsl:if>
											</input><xsl:value-of select="$lng/install"/>
										</td>
									</tr>
									<tr>
										<td colspan="2"><br/></td>
									</tr>
									<xsl:call-template name="submit_button">
										<xsl:with-param name="submit" select="'no'"/>
									</xsl:call-template>
								</table>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header"><xsl:value-of select="$lng/instheader"/></div>
				<div id="right_content">
					<xsl:for-each select="$lng/postinst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
					<xsl:value-of select="$lng/instselect"/><br/>
					<ul>
						<li><xsl:value-of select="$lng/addproduct"/><br/></li>
					<xsl:for-each select="product">
						<li><xsl:value-of select="value"/><br/></li>
					</xsl:for-each>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<script type="text/javascript">
		document.report.rfq_number.focus();
		<xsl:call-template name="state_script"/>
		update_state();
	</script>
	<xsl:call-template name="footer"/>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>

	<script type="text/javascript">
		Calendar.setup({inputField:"closedate",ifFormat:"%Y-%m-%d",button:"trigger_startdate",singleClick:true});
	</script>		
</body>
</html>
</xsl:template>
</xsl:stylesheet>