<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderquote"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="quote"/>
					<input type="hidden" name="usersid" value="{usersid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="500" bgcolor="FFFFFF">
					<xsl:if test="not(tenders/tenderid) and not(quoted) and not(errortenders)">
						<tr>
							<td><br/></td>
							<td class="t2">
								<xsl:value-of select="$lng/nothingtoquote"/>
							</td>
						</tr>
					</xsl:if>
					<!-- completed quotes -->
					<xsl:if test="quoted">
						<tr>
							<td><br/></td>
							<td class="t2" colspan="4">
								<xsl:value-of select="$lng/successfullyquoted"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h t2">
								<xsl:value-of select="$lng/tenderitem"/>
							</td>
							<td class="ha t2">
								<xsl:value-of select="$lng/brand"/>
							</td>
							<td class="ha t2">
								<xsl:value-of select="$lng/model"/>
							</td>
							<td class="ha t2">
								<xsl:value-of select="$lng/price"/>
							</td>
						</tr>
						<xsl:for-each select="quoted">
							<tr>
								<td><br/></td>
								<td class="h2b t2">
									<xsl:value-of select="id"/>
								</td>
								<td class="h2c t2">
									<xsl:value-of select="brand"/>
								</td>
								<td class="h2c t2">
									<xsl:value-of select="model"/>
								</td>
								<td class="h2c t2">
									<xsl:value-of select="../localprecurrency"/><xsl:value-of select="price"/><xsl:value-of select="/response/localpostcurrency"/>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:if>
					<!-- tenders to quote on -->
					<xsl:if test="tenders/tenderid">
						<xsl:variable name="attachment" select="attachment"/>
						<xsl:for-each select="tenders">
							<tr>
								<td colspan="8"><br/></td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="h t1">
									<xsl:value-of select="$lng/rfqnumber"/>
								</td>
								<td class="ha t2">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tenderid)"/>
										</xsl:attribute>
										<xsl:value-of select="rfq_number"/>
									</a>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/createdon"/>
								</td>
								<td class="ha t2">
									<xsl:value-of select="created_date"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="created_time"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/closeon"/>
								</td>
								<td class="ha t2">
									<xsl:value-of select="close_date"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="close_time"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/area"/>
								</td>
								<td class="ha t2">
									<xsl:value-of select="areaname"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="hb t1">
									<xsl:value-of select="$lng/user"/>
								</td>
								<td class="hc t2">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',usersid)"/>
										</xsl:attribute>
										<xsl:value-of select="name"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="surname"/>
									</a>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/items"/>
								</td>
								<td class="hc t2">
									<xsl:value-of select="itemcount"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/phonework"/>
								</td>
								<td class="hc t2">
									<xsl:value-of select="phone_work"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/email"/>
								</td>
								<td class="hc t2">
									<xsl:value-of select="email"/>
								</td>
							</tr>
							<xsl:variable name="tenderid" select="tenderid"/>
							<tr>
								<td><br/></td>
								<td colspan="8" class="h2b">
									<table border="0" cellpadding="2" cellspacing="0" bgcolor="FFFFFF">
										<tr>
											<td class="h1 t1">#</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/category"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/brand"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/model"/>
											</td>
											<td class="h1a t1" colspan="4">
												<xsl:value-of select="$lng/description"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/stock"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/valid"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/price"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/noquote"/>
											</td>
										<xsl:if test="$attachment='1'">
											<td class="h1a t1">
												<xsl:value-of select="$lng/attachment"/>
											</td>
										</xsl:if>
											<td class="h1a t1">
												<xsl:value-of select="$lng/ignorequote"/>
											</td>
										</tr>
										<xsl:for-each select="../tenderitems">
											<xsl:if test="tender=$tenderid">
												<xsl:if test="error">
													<tr>
														<td class="h2b e" colspan="13"><xsl:value-of select="error"/></td>
													</tr>
												</xsl:if>
												<tr>
													<td class="h2b t1" valign="top">
														<xsl:value-of select="id"/>
													</td>
													<td class="h2c t2" valign="top">
														<xsl:value-of select="categoryname"/>/<br/>
														<xsl:value-of select="category_subname"/>
														<input type="hidden" name="category_subname[{id}]" value="{category_subname}"/>
													</td>
													<td class="h2c t2" valign="top">
														<xsl:if test="../brand/brandname">
															<select class="t2">
																<xsl:attribute name="name">brandselector[<xsl:value-of select="id"/>]</xsl:attribute>
																<xsl:attribute name="id">brandselector<xsl:value-of select="id"/></xsl:attribute>
																<xsl:attribute name="onchange">changebrand(brand<xsl:value-of select="id"/>,brandselector<xsl:value-of select="id"/>)</xsl:attribute>
																<option value="0"></option>
																<xsl:for-each select="../brand">
																	<option>
																		<xsl:attribute name="value"><xsl:value-of select="brandname"/></xsl:attribute>
																		<xsl:value-of select="brandname"/>
																	</option>
																</xsl:for-each>
															</select>
														</xsl:if>
														<input type="text" class="t2" size="10">
															<xsl:if test="classification!='1'">
																<xsl:attribute name="readonly"/>
																<xsl:attribute name="class">readonly t2</xsl:attribute>
															</xsl:if>
															<xsl:attribute name="value"><xsl:value-of select="brand"/></xsl:attribute>
															<xsl:attribute name="name">brand[<xsl:value-of select="id"/>]</xsl:attribute>
															<xsl:attribute name="id">brand<xsl:value-of select="id"/></xsl:attribute>
														</input>
													</td>
													<td class="h2c t2" valign="top">
														<input type="text" class="t2" size="15">
															<xsl:if test="classification!='1'">
																<xsl:attribute name="readonly"/>
																<xsl:attribute name="class">readonly t2</xsl:attribute>
															</xsl:if>
															<xsl:attribute name="value"><xsl:value-of select="model"/></xsl:attribute>
															<xsl:attribute name="name">model[<xsl:value-of select="id"/>]</xsl:attribute>
															<xsl:attribute name="id">model<xsl:value-of select="id"/></xsl:attribute>
														</input>
													</td>
													<td class="h2c t2" colspan="4" valign="top">
														<textarea class="t2" cols="20" rows="3">
															<xsl:attribute name="name">description[<xsl:value-of select="id"/>]</xsl:attribute>
															<xsl:attribute name="id">description<xsl:value-of select="id"/></xsl:attribute>
															<xsl:value-of select="description"/>
														</textarea>
													</td>
													<td class="h2c t2" valign="top">
														<select class="t2" name="stock[{id}]">
															<option value="0">
																<xsl:value-of select="$lng/available"/>
															</option>
															<option value="1">
																<xsl:if test="stock='1'"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/oneday"/>
															</option>
															<option value="2">
																<xsl:if test="stock='2'"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/twoday"/>
															</option>
															<option value="3">
																<xsl:if test="stock='3'"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/threeday"/>
															</option>
															<option value="7">
																<xsl:if test="stock='7'"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/week"/>
															</option>
															<option value="14">
																<xsl:if test="stock='14'"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/twoweek"/>
															</option>
															<option value="28">
																<xsl:if test="stock='28'"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/fourweek"/>
															</option>
														</select>
													</td>
													<td class="h2c t2" valign="top">
														<select class="t2" name="valid[{id}]">
															<option value="1">
																<xsl:if test="../tendervaliditydefault &lt; 2 and ../tendervaliditydefault &gt; 0"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/oneday"/>
															</option>
															<option value="2">
																<xsl:if test="../tendervaliditydefault &lt; 3 and ../tendervaliditydefault &gt; 1"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/twoday"/>
															</option>
															<option value="3">
																<xsl:if test="../tendervaliditydefault &lt; 4 and ../tendervaliditydefault &gt; 2"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/threeday"/>
															</option>
															<option value="7">
																<xsl:if test="../tendervaliditydefault &lt; 8 and ../tendervaliditydefault &gt; 3"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/week"/>
															</option>
															<option value="14">
																<xsl:if test="../tendervaliditydefault &lt; 15 and ../tendervaliditydefault &gt; 7"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/twoweek"/>
															</option>
															<option value="28">
																<xsl:if test="../tendervaliditydefault &gt; 14"><xsl:attribute name="selected"/></xsl:if>
																<xsl:value-of select="$lng/fourweek"/>
															</option>
														</select>
													</td>
													<td class="h2c t2" valign="top" nowrap="nowrap">
														<xsl:value-of select="../localprecurrency"/>
														<input type="text" class="t2" size="8" value="0.00" name="price[{id}]"/>
														<xsl:value-of select="/response/localpostcurrency"/>k
													</td>
													<td class="h2c t2" valign="top">
														<input type="checkbox" class="t2" name="noquote[{id}]" id="noquote{id}"/>
														<input type="hidden" value="{classification}" name="classification[{id}]" id="type{id}"/>
														<input type="hidden" name="tender[{id}]" value="{tender}"/>
													</td>
												<xsl:if test="$attachment='1'">
													<td class="h2c t2" valign="top">
														<input type="file" class="t2" name="file[{id}]" id="file{id}"/>
													</td>
												</xsl:if>
													<td class="h2c t2" valign="top">
														<input type="checkbox" class="t2" name="ignore[{id}]" id="ignore{id}"/>
													</td>
												</tr>
											</xsl:if>
										</xsl:for-each>
									</table>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td><br/></td>
							<td colspan="8" align="right" class="t1">
								<input type="submit" name="submit" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submitquote"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:if>
					</table>
				</form>
			</div>
			<div id="right">
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
