<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tendersettings"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="settings"/>
					<input type="hidden" name="display_type" value="tender"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="2" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/changedsuccess"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderenable"/>
							<xsl:with-param name="input_name" select="'tenderenable'"/>
							<xsl:with-param name="input_value" select="settings/tenderenable"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tendervaliditystatus"/>
							<xsl:with-param name="input_name" select="'tendervaliditystatus'"/>
							<xsl:with-param name="input_value" select="settings/tendervaliditystatus"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tendervalidityall"/>
							<xsl:with-param name="input_name" select="'tendervalidityall'"/>
							<xsl:with-param name="input_value" select="settings/tendervalidityall"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tendercloseauto"/>
							<xsl:with-param name="input_name" select="'tendercloseauto'"/>
							<xsl:with-param name="input_value" select="settings/tendercloseauto"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderexpireddefault"/>
							<xsl:with-param name="input_name" select="'tenderexpireddefault'"/>
							<xsl:with-param name="input_value" select="settings/tenderexpireddefault"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tendercloseagent"/>
							<xsl:with-param name="input_name" select="'tendercloseagent'"/>
							<xsl:with-param name="input_value" select="settings/tendercloseagent"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tenderclosetime"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="tenderclosetime" size="4" maxlenght="40" class="t2" value="{settings/tenderclosetime}"/>
								<xsl:value-of select="$lng/seconds"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tenderquotetime"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="tenderquotetime" size="4" maxlenght="40" class="t2" value="{settings/tenderquotetime}"/>
								<xsl:value-of select="$lng/seconds"/>
							</td>
						</tr>
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/changetimetitle"/> 
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tendervaliditydefault"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="tendervaliditydefault" size="4" maxlenght="40" class="t2" value="{settings/tendervaliditydefault}"/>
								<xsl:value-of select="$lng/days"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tendervalidityminimum"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="tendervalidityminimum" size="4" maxlenght="40" class="t2" value="{settings/tendervalidityminimum}"/>
								<xsl:value-of select="$lng/days"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tendervaliditymaximum"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="tendervaliditymaximum" size="4" maxlenght="40" class="t2" value="{settings/tendervaliditymaximum}"/>
								<xsl:value-of select="$lng/days"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/timedefault"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="timedefault" size="4" maxlenght="40" class="t2" value="{settings/timedefault}"/>
								<xsl:value-of select="$lng/minutes"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/timemax"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="timemax" size="4" maxlenght="40" class="t2" value="{settings/timemax}"/>
								<xsl:value-of select="$lng/minutes"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/timeincrement"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="timeincrement" size="4" maxlenght="40" class="t2" value="{settings/timeincrement}"/>
								<xsl:value-of select="$lng/minutes"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderdate"/>
							<xsl:with-param name="input_name" select="'tenderdate'"/>
							<xsl:with-param name="input_value" select="settings/tenderdate"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/tenderawardsettings"/>
							</td>
						</tr>						
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderawardcash"/>
							<xsl:with-param name="input_name" select="'tenderawardcash'"/>
							<xsl:with-param name="input_value" select="settings/tenderawardcash"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderawardnontendersupplier"/>
							<xsl:with-param name="input_name" select="'tenderawardnontendersupplier'"/>
							<xsl:with-param name="input_value" select="settings/tenderawardnontendersupplier"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderawardinvalidate"/>
							<xsl:with-param name="input_name" select="'tenderawardinvalidate'"/>
							<xsl:with-param name="input_value" select="settings/tenderawardinvalidate"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>							
						</xsl:call-template>						
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderawardtoself"/>
							<xsl:with-param name="input_name" select="'tenderawardtoself'"/>
							<xsl:with-param name="input_value" select="settings/tenderawardtoself"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>						
						<tr>
							<td align="left" colspan="2" class="h1 t1">
								<xsl:value-of select="$lng/other"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tendercommodity"/>
							<xsl:with-param name="input_name" select="'tendercommodity'"/>
							<xsl:with-param name="input_value" select="settings/tendercommodity"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderbudget"/>
							<xsl:with-param name="input_name" select="'tenderbudget'"/>
							<xsl:with-param name="input_value" select="settings/tenderbudget"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tendercollect"/>
							<xsl:with-param name="input_name" select="'tendercollect'"/>
							<xsl:with-param name="input_value" select="settings/tendercollect"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderquantity"/>
							<xsl:with-param name="input_name" select="'tenderquantity'"/>
							<xsl:with-param name="input_value" select="settings/tenderquantity"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderexcess"/>
							<xsl:with-param name="input_name" select="'tenderexcess'"/>
							<xsl:with-param name="input_value" select="settings/tenderexcess"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tendersalvage"/>
							<xsl:with-param name="input_name" select="'tendersalvage'"/>
							<xsl:with-param name="input_value" select="settings/tendersalvage"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tenderreportnoquotes"/>
							<xsl:with-param name="input_name" select="'tenderreportnoquotes'"/>
							<xsl:with-param name="input_value" select="settings/tenderreportnoquotes"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/tendersuppliersearchmenu"/>
							<xsl:with-param name="input_name" select="'tendersuppliersearchmenu'"/>
							<xsl:with-param name="input_value" select="settings/tendersuppliersearchmenu"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tenderdelivery"/>
							</td>
							<td align="left" class="t2">
								<input name="tendertransportdefault" value="c" type="radio">
									<xsl:if test="settings/tendertransportdefault='c'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/collect"/>
								<input name="tendertransportdefault" value="d" type="radio">
									<xsl:if test="settings/tendertransportdefault='d'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/deliver"/>
								<input name="tendertransportdefault" value="i" type="radio">
									<xsl:if test="settings/tendertransportdefault='i'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/install"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">														   
								<xsl:value-of select="$lng/tendersmslimit"/>
							</td>
							<td align="left" class="t2">
								<input name="tendersmslimit" class="t2" value="{settings/tendersmslimit}" size="2"/>
							</td>
						</tr>
						<tr>
							<td align="right" width="270" colspan="2">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/changesettings"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/tenderinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
