<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<xsl:param name="display" select="/response/display"/>
<xsl:param name="more" select="/response/more"/>
<xsl:param name="type" select="/response/type"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/controlpanel"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/waitingtenders"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="subscriber_approve"/>
					<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="opentenders/rfq_number">
							<tr>
								<td><br/></td>
								<td class="h t1">
									<xsl:value-of select="$lng/rfqnumber"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/rfqreference"/>
								</td>
							<xsl:if test="user/permission &gt; 1">
								<td class="ha t1">
									<xsl:value-of select="$lng/requestor"/>
								</td>
							</xsl:if>
								<td class="ha t1">
									<xsl:value-of select="$lng/location"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/trans"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/createdon"/>
								</td>
							</tr>
							<xsl:for-each select="opentenders">
								<tr>
									<td><br/></td>
									<td class="h2b t2" align="left">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
											</xsl:attribute>
											<xsl:value-of select="rfq_number"/>
										</a>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="rfq_reference"/>
									</td>
								<xsl:if test="../user/permission &gt; 1">
									<td class="h2c t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
											</xsl:attribute>
											<xsl:value-of select="name"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="surname"/>
										</a>
									</td>
								</xsl:if>
									<td class="h2c t2" align="left">
										<xsl:value-of select="statename"/>/<br/>
										<xsl:value-of select="areaname"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:choose>
											<xsl:when test="transport='c'">
												<xsl:value-of select="$lng/collect"/>
											</xsl:when>
											<xsl:when test="transport='d'">
												<xsl:value-of select="$lng/deliver"/>
											</xsl:when>
											<xsl:when test="transport='i'">
												<xsl:value-of select="$lng/install"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
												<xsl:value-of select="'('"/>
												<xsl:value-of select="transport"/>
												<xsl:value-of select="')'"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="created_date"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="created_time"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="../localdisplay"/>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>