<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<xsl:variable name="type" select="tender/type"/>
	<xsl:variable name="rfq_number" select="tender/rfq_number"/>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header"><xsl:value-of select="$lng/tenderrequest"/></div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td class="h t1" colspan="6"><xsl:value-of select="$lng/tenderinfo"/></td>
							<td class="ha t1">
								<input name="print" type="button" value="{$lng/print}" onclick="window.print()" class="t2"/>
							</td>
						</tr>
						<tr>
							<td class="h2b t1" colspan="2"><xsl:value-of select="$lng/rfqnumber"/></td>
							<td class="h2c t2" colspan="2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="rfq_number"/>
								</a>
							</td>
							<td class="h2c t1"><xsl:value-of select="$lng/rfqreference"/></td>
							<td class="h2c t2" colspan="2"><xsl:value-of select="rfq_reference"/></td>
						</tr>
						<tr>
							<td class="h2b t1" colspan="2"><xsl:value-of select="$lng/state"/></td>
							<td class="h2c t2" colspan="2"><xsl:value-of select="state"/></td>
							<td class="h2c t1"><xsl:value-of select="$lng/area"/></td>
							<td class="h2c t2" colspan="2"><xsl:value-of select="area"/></td>
						</tr>
						<tr>
							<td class="h2b t1" colspan="2"><xsl:value-of select="$lng/trans"/></td>
							<td class="h2c t2" colspan="2">
								<xsl:choose>
									<xsl:when test="transport='c'">
										<xsl:value-of select="$lng/collect"/>
									</xsl:when>
									<xsl:when test="transport='d'">
										<xsl:value-of select="$lng/deliver"/>
									</xsl:when>
									<xsl:when test="transport='i'">
										<xsl:value-of select="$lng/install"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/><xsl:value-of select="'('"/><xsl:value-of select="transport"/><xsl:value-of select="')'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="h2c t1"><xsl:value-of select="$lng/closingdate"/></td>
							<td class="h2c t2" colspan="2"><xsl:value-of select="closing"/></td>
						</tr>
						<xsl:if test="item">
							<tr>
								<td class="h1b t1"><xsl:value-of select="$lng/tenderitem"/></td>
								<td class="h1c t1"><xsl:value-of select="$lng/category"/></td>
								<td class="h1c t1"><xsl:value-of select="$lng/brand"/></td>
								<td class="h1c t1"><xsl:value-of select="$lng/model"/></td>
								<td class="h1c t1"><xsl:value-of select="$lng/description"/></td>
								<td class="h1c t1"><xsl:value-of select="$lng/requested"/></td>
								<td class="h1c t1"><xsl:value-of select="$lng/status"/></td>
							</tr>
							<xsl:for-each select="item">
								<tr>
									<td class="h2b t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',id)"/>
											</xsl:attribute>
											<xsl:value-of select="id"/>
										</a>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="category"/><xsl:value-of select="'/'"/>
										<br/>
										<xsl:value-of select="category_sub"/>
									</td>
									<td class="h2c t2"><xsl:value-of select="brand"/></td>
									<td class="h2c t2"><xsl:value-of select="model"/></td>
									<td class="h2c t2"><textarea class="readonly t2" readonly="" cols="40"><xsl:value-of select="description"/></textarea></td>
									<td class="h2c t2">
										<xsl:choose>
											<xsl:when test="../awaiting_approval='1'">
												<xsl:value-of select="'-'"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="requested"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
							<xsl:choose>
								<xsl:when test="error">
									<td class="h2c e"><xsl:value-of select="error"/></td>
								</xsl:when>
								<xsl:otherwise>
									<td class="h2c t2"><xsl:value-of select="$lng/ok"/></td>
								</xsl:otherwise>
							</xsl:choose>
								</tr>
							</xsl:for-each>
						</xsl:if>
				<xsl:choose>
					<xsl:when test="awaiting_approval='1'">
						<tr>
							<td class="t2" colspan="3"><br/></td>
						</tr>
						<tr>
							<td class="t1" colspan="3">
								<xsl:value-of select="$lng/awaitingapproval"/>
							</td>
						</tr>
					</xsl:when>
					<xsl:when test="tender_deleted='1'">
						<tr>
							<td class="t2" colspan="3"><br/></td>
						</tr>
						<tr>
							<td class="t1" colspan="3">
								<xsl:value-of select="$lng/tenderdeleted"/>
							</td>
						</tr>
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<td class="h1b t1" colspan="7"><xsl:value-of select="$lng/requested"/></td>
						</tr>
						<tr>
							<td colspan="7" class="h2b">
								<table border="0" align="center" cellpadding="0" cellspacing="0" width="100%" bgcolor="FFFFFF">
									<xsl:for-each select="supplier[position() mod 4 = 1]">
										<tr>
											<xsl:for-each select=".|following-sibling::supplier[position() &lt; 4]">
												<td align="left">
													<xsl:if test="last()!=4">
														<xsl:attribute name="colspan"><xsl:value-of select="position() - last() + 1"/></xsl:attribute>
													</xsl:if>
													<a target="main">
														<xsl:attribute name="href">
															<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',id)"/>
														</xsl:attribute>
														<xsl:value-of select="name"/>
													</a>
												</td>
											</xsl:for-each>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</tr>
						<tr>
							<td class="t2" colspan="7"><br/></td>
						</tr>
						<tr>
							<td class="t2" colspan="7">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=show_tender_item&amp;tenderid=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/clickaudittrail"/>
								</a>
							</td>
						</tr>
					</xsl:otherwise>
				</xsl:choose>
					</table>
				<xsl:if test="approvaltenders/tenderid">
					<br/>
					<b><xsl:value-of select="$lng/awaitingapproval"/></b>
					<br/><br/>
					<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="h t1"><xsl:value-of select="$lng/rfqnumber"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/rfqreference"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/subscriber"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/createdon"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/location"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/action"/></td>
						</tr>
					<xsl:for-each select="approvaltenders">
						<tr>
							<td><br/></td>
							<td class="h2b t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tenderid)"/>
									</xsl:attribute>
									<xsl:value-of select="rfq_number"/>
								</a>
							</td>
							<td class="h2c t2"><xsl:value-of select="rfq_reference"/></td>
							<td class="h2c t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',usersid)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/><xsl:value-of select="' '"/><xsl:value-of select="surname"/>
								</a>
							</td>
							<td class="h2c t2">
								<xsl:value-of select="created_date"/><br/>
								<xsl:value-of select="created_time"/><xsl:value-of select="../localdisplay"/>
							</td>
							<td class="h2c t2"><xsl:value-of select="statename"/>/<br/><xsl:value-of select="areaname"/></td>
							<td class="h2c t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=tender&amp;function=approve&amp;tenderid=',tenderid)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/approvetender"/>
								</a>
							</td>
						</tr>
					</xsl:for-each>
						<tr>
							<td><br/></td>
						</tr>
					</table>
				</xsl:if>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
