<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- area java script -->
<xsl:include href="../../area/templates/state_script.xsl"/>
<xsl:include href="../../category/templates/category_script.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/suppliersearch"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tendersuppliersearch"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="supplier_search"/>
					<input type="hidden" name="organisationid" value="{organisationid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<tr>
							<td class="h t1" colspan="3">
								<xsl:value-of select="$lng/tendersuppliersearch"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/suppliername"/>
							</td>
							<td class="t1">
								<input type="text" size="12" maxlenght="32" class="t2" name="name"/>
							</td>
							<td class="t1">
								(<xsl:value-of select="$lng/optional"/>)
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td class="t1">
								<xsl:call-template name="state_select"/>
							</td>
							<td class="t1">
								(<xsl:value-of select="$lng/optional"/>)
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td class="t1">
								<xsl:call-template name="area_select"/>
							</td>
							<td class="t1">
								(<xsl:value-of select="$lng/optional"/>)
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/category"/>
							</td>
							<td class="t1">
								<xsl:call-template name="category_select"/>
							</td>
							<td class="t1">
								(<xsl:value-of select="$lng/optional"/>)
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/category_sub"/>
							</td>
							<td class="t1">
								<select name="category_sub" class="t2"/>
							</td>
							<td class="t1">
								(<xsl:value-of select="$lng/optional"/>)
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/suppliers"/>
							</td>
							<td class="t1">
								<select name="panel" class="t2">
									<option value="panel"><xsl:value-of select="$lng/supplierpanel"/></option>
									<option value="all"><xsl:value-of select="$lng/supplierall"/></option>
								</select>
							</td>
							<td class="t1">
								(<xsl:value-of select="$lng/optional"/>)
							</td>
						</tr>
						<tr>
							<td class="t1" align="right" colspan="3">
								<input type="submit" name="search" class="t2">
									<xsl:attribute name="value"><xsl:value-of select="$lng/submit"/></xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/searchinsthead"/>
				</div>
				<div id="right_content">
				<xsl:for-each select="$lng/searchinst">
					<xsl:value-of select="."/><br/>
				</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		<xsl:call-template name="category_script">
			<xsl:with-param name="functionname" select="'changesub'"/>
		</xsl:call-template>
		changesub();
		
		<xsl:call-template name="state_script"/>
		update_state();
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
