<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">
	<td><br/><br/></td>
	<td class="h1 t1">
	<xsl:value-of select="$lng/supplier"/>
	</td>
	<td class="h1a t1">
		<xsl:value-of select="$lng/exclude"/>
	</td>
	<xsl:choose>
		<xsl:when test="supplier">
			<xsl:for-each select="supplier">
				<tr>
					<td><br/><br/></td>
					<td class="h2b t1"><xsl:value-of select="name"/></td>
					<td class="h2c t2" valign="top">
						<input type="checkbox" class="t2" name="supplier_select[{supplierid}]"/>
						<br/>
					</td>
				</tr>	
			</xsl:for-each>
		</xsl:when>	
		<xsl:otherwise>	
			<tr>
				<td><br/><br/></td>
				<td class="h2b t1" colspan="2">
					<xsl:value-of select="$lng/nosuppliers"/>
				</td>	
			</tr>	
		</xsl:otherwise>	
	</xsl:choose>	
</xsl:template>
</xsl:stylesheet>