<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/viewitem"/></title>
		<link rel="stylesheet" type="text/css" href="theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/viewitem"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'tender'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="view_item"/>
					<input type="hidden" name="organisationid" value="{organisationid}"/>
					<input type="hidden" name="itemcount" value="{itemcount}"/>
					<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<tr>
							<td><br/></td>
							<td colspan="4" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/updated"/>
								</xsl:if>
							</td>
						</tr>
			<xsl:choose>
				<xsl:when test="item/price">
						<tr>
							<td><br/></td>
						<xsl:if test="user/classification='3'">
							<td class="h t1">
								<xsl:value-of select="$lng/supplier"/>
							</td>
						</xsl:if>
							<td class="ha t1">
								<xsl:if test="user/classification!='3'">
									<xsl:attribute name="class">h t1</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="$lng/category"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/subcat"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/brand"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/model"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/description"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/stock"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/validuntil"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/price"/>
							</td>
							<td class="ha t1">
								<input type="checkbox" class="t2" id="site" name="invalidateall" onchange="CheckAll(this)"/>
								<xsl:value-of select="$lng/invalidate"/>
							</td>
						</tr>
					<xsl:for-each select="item">
						<tr>
							<td><br/></td>
						<xsl:if test="../user/classification='3'">
							<td class="h2b t2" align="left">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',organisationid)"/>
									</xsl:attribute>
									<xsl:value-of select="organisationname"/>
								</a>
							</td>
						</xsl:if>
							<td class="h2c t2" align="left">
								<xsl:if test="../user/classification!='3'">
									<xsl:attribute name="class">h2b t2</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="categoryname"/>
							</td>
							<td class="h2c t2" align="left">
								<xsl:value-of select="subcategory"/>
							</td>
							<td class="h2c t2" align="left">
								<xsl:value-of select="brand"/>
							</td>
							<td class="h2c t2" align="left">
								<xsl:value-of select="model"/>
							</td>
							<td class="h2c t2" align="left">
								<textarea class="readonly t2" readonly=""><xsl:value-of select="description"/></textarea>
							</td>
							<td class="h2c t2" align="left">
								<xsl:choose>
									<xsl:when test="stock='0'">
										<xsl:value-of select="$lng/available"/>
									</xsl:when>
									<xsl:when test="stock='1'">
										<xsl:value-of select="$lng/oneday"/>
									</xsl:when>
									<xsl:when test="stock='2'">
										<xsl:value-of select="$lng/twoday"/>
									</xsl:when>
									<xsl:when test="stock='3'">
										<xsl:value-of select="$lng/threeday"/>
									</xsl:when>
									<xsl:when test="stock='7'">
										<xsl:value-of select="$lng/week"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="stock"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="h2c t2" align="left">
								<xsl:value-of select="valid_until"/>
							</td>
							<td class="h2c t2" align="left">
								<xsl:value-of select="price"/>
							</td>
							<td class="h2c t2">
								<input type="checkbox" class="t2" name="item[{itemid}]"/>
							</td>
						</tr>
					</xsl:for-each>
						<tr>
							<td><br/></td>
							<td colspan="10" align="right" class="t1">
								<input type="submit" name="invalidate" class="t2">
									<xsl:attribute name="value"><xsl:value-of select="$lng/invalidate"/></xsl:attribute>
								</input>
							</td>
						</tr>
				</xsl:when>
				<xsl:otherwise>
						<tr>
							<td><br/></td>
							<td colspan="4" class="t1">
								<xsl:value-of select="$lng/novaliditems"/>
							</td>
						</tr>
				</xsl:otherwise>
			</xsl:choose>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function CheckAll(parent) {
			var allChildren = document.getElementById(parent.id+'div').getElementsByTagName("input");
			for (var i = 0; i &lt; allChildren.length; i++) {
				allChildren[i].checked = parent.checked;
			}
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
