<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Manager
* @package TenderSystem
* @subpackage theme
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'export'	=> array(),
	'dump'		=> array(),
	'import'	=> array(),
	'accept'	=> array(),
	'theme'		=> array()
);
get_request($fields_request,$action,$error,$cfg);
if(!$_SESSION['ts_id']) {
	// no Session
	xml_generator("theme","error","e1","",$cfg);
} elseif($action['accept']) {
	// field request errors and type
	$fields_request = array (
		'file'		=> array("e5")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		// upload theme
		require(getcwd()."/modules/external/class/dunzip/dUnzip2.inc.php");
		$new_dunzip = new dUnzip2($info['file']);
		$params['extracted'] = count($new_dunzip->getList());
		$new_dunzip->unzipAll(getcwd());
		// display message
		xml_generator("theme","import","",$params,$cfg);
	} else {
		// display message
		xml_generator("theme","error",$error,$params,$cfg);
	}
} elseif($action['import']) {
	$file = $_FILES['file'];
	// must be a zip file
	if(strpos($file['type'],"zip") || strpos($file['name'],".zip")) {
		// upload file
		$upload_dest = upload_file($file,"theme",$cfg);
		// check if uploaded successfully
		if (is_string($upload_dest)) {
			// include unzip class
			require(getcwd()."/modules/external/class/dunzip/dUnzip2.inc.php");
			$new_dunzip = new dUnzip2($upload_dest);
			$params['file'] = $upload_dest;
			$params['file_count'] = count($new_dunzip->getList());
			// get theme info
			$info = unserialize($new_dunzip->getZipInfo("zipfile_comment"));
			if(is_array($info)) {
				$params = array_merge($params,$info);
			}
			$new_dunzip->close();
			xml_generator("theme","import","",$params,$cfg);
		} else {
			// display error
			xml_generator("theme","error",$upload_dest['error'],$params,$cfg);
		}
	} else {
		// must be zip file
		xml_generator("theme","error","e2","",$cfg);
	}
} elseif($action['export'] && $action['theme']) {
	$params['theme'] = $action['theme'];
	xml_generator("theme","export","",$params,$cfg);
} elseif($action['dump'] && $action['theme']) {
	// field request errors and type
	$fields_request = array (
		'creator'		=> array("e7",	REQUEST_ANY,	FORMAT_UCWORDS),
		'description'	=> array("e8"),
		'link'			=> array("",	REQUEST_URL,	FORMAT_NONE,	"e9")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		$info['theme'] = $action['theme'];
		$info['date'] = date("Y-m-d");
		$info['version'] = $cfg['version'];
		$lang_file = getcwd()."/modules/theme/language/".$cfg['language']."/default.xml";
		$info['thememanagaer'] = event_parser('<module_version>','</module_version>',file_get_contents($lang_file));
		// get all the theme files
		$files = examinedir("theme/".$info['theme']) + examinedir("application/include/theme/".$info['theme']);
		// serialize to store in zip info
		$coded_array = serialize($info);
		// include zip class
		require(getcwd()."/modules/external/class/dunzip/dZip.inc.php");
		// create tmp file
		$filename = tempnam("","file.zip");
		$new_dzip = new dZip($filename,TRUE);
		foreach($files as $value) {
			// add files 
			$new_dzip->addFile($value,$value);
		}
		$new_dzip->save($coded_array);
		$filecontent = file_get_contents($filename);
		$filesize = strlen($filecontent);
		// delete tmp file
		unlink($filename);
		if ($filecontent) {
			// set the header and display
			$header_name = "Content-Disposition: attachment; filename=\"".$action['theme']."_".str_replace(".","_",$cfg['version'])."_ts.zip"."\"";
			header($header_name);
			header("Content-Type: application/octet-stream");
			header("Content-Length: ".$filesize);
			header("Pragma: no-cache");
			header("Expires: 0");
			echo $filecontent;
		}
	} else {
		// error
		xml_generator("theme","error",$error,"",$cfg);
	}
} else {
	// missing theme
	xml_generator("theme","error","e3","",$cfg);
}
?>