<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/importtheme"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'theme'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="theme"/>
					<input type="hidden" name="function" value="manager"/>
					<input type="hidden" name="file" value="{file}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
						</tr>
					<xsl:if test="extracted">
						<tr>
							<td align="left" class="t1" colspan="4">
								<xsl:value-of select="$lng/extracted"/>:<xsl:value-of select="extracted"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="file">
						<tr>
							<td align="left" class="h t1" colspan="4">
								<xsl:value-of select="$lng/themeinfo"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/name"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="theme"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/creator"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="creator"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/file_count"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="file_count"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/date"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="date"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/des"/>
							</td>
							<td align="left" class="t2" colspan="3">
								<xsl:value-of select="description"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/exportversion"/>
							</td>
							<td align="left" class="e">
								<xsl:choose>
									<xsl:when test="version">
										<xsl:if test="version=footer/version">
											<xsl:attribute name="class">t2</xsl:attribute>
										</xsl:if>
										<xsl:value-of select="version"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/thememanager"/>
							</td>
							<td align="left" class="e">
								<xsl:choose>
									<xsl:when test="thememanagaer">
										<xsl:if test="thememanagaer=$lng/module_version">
											<xsl:attribute name="class">t2</xsl:attribute>
										</xsl:if>
										<xsl:value-of select="thememanagaer"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td align="right" colspan="4" class="t1">
								<input type="submit" name="accept" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/import"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
