<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/thememanager"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'theme'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="theme"/>
					<input type="hidden" name="function" value="manager"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td align="left" class="h t1" colspan="2">
								<xsl:value-of select="$lng/themes"/>
							</td>
						</tr>
					<xsl:if test="theme">
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/export"/>
							</td>
							<td align="right" class="t2">
								<select name="theme" class="t2">
									<option value=""><xsl:value-of select="$lng/selecttheme"/></option>
									<xsl:for-each select="theme">
										<option value="{.}"><xsl:value-of select="."/></option>
									</xsl:for-each>
								</select>
								<input type="submit" name="export" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/export"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/import"/>
							</td>
							<td align="right" class="t2">
								<input type="file" name="file" class="t2"/>
								<input type="submit" name="import" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/import"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
