<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create user
* @package TenderSystem
* @subpackage user
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'createuser'	=> array()
);
get_request($fields_request,$action,$error,$cfg);
if($action['createuser']) {
	// field request errors and type 
	$fields_request = array (
		'organisationid'	=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e17"),
		'branchid'			=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e18"),
		'username'			=> array("e3",	REQUEST_ANY,	FORMAT_USERNAME),
		'name'				=> array("e4",	REQUEST_ANY,	FORMAT_UCWORDS),
		'surname'			=> array("e5",	REQUEST_ANY,	FORMAT_UCWORDS),
		'phone_prefix'		=> array("e4",	REQUEST_NUMBER,	FORMAT_NONE,	"e19"),
		'phone_work'		=> array("e7",	REQUEST_PHONE,	FORMAT_PHONE,	"e20"),
		'phone_fax'			=> array("e8",	REQUEST_PHONE,	FORMAT_PHONE,	"e21"),
		'phone_mobile'		=> array("e9",	REQUEST_PHONE,	FORMAT_PHONE,	"e22"),
		'email'				=> array("e10",	REQUEST_EMAIL,	FORMAT_NONE,	"e23"),
		'preference'		=> array("e11",	REQUEST_CHAR,	FORMAT_NONE,	"e24"),
		'permission'		=> array("e12",	REQUEST_NUMBER,	FORMAT_NONE,	"e25"),
		'theme'				=> array("e13",	REQUEST_THEME,	FORMAT_NONE,	"e26"),
		'lang'				=> array("e14",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
		'mandate'			=> array("",	REQUEST_MONEY,	FORMAT_MONEY,	"e28"),
		'classification'	=> array("e16",	REQUEST_NUMBER,	FORMAT_NONE,	"e30"),
		'administrator'		=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e29"),
		'additional'		=> array(),
		'emailimages'		=> array(),
		'skype'				=> array(),
		'date_of_birth'		=> array(),
		'im_contact'		=> array(),
		'instant_messager'	=> array()
	);
	// get data
	get_request($fields_request,$currentinfo[0],$error,$cfg);
	// check if need mandate
	if($currentinfo[0]['classification'] == "2" && $currentinfo[0]['mandate'] == "")  {
		// missing mandate
		$error[] = "e15";
	}
	// check for branch id
	if($currentinfo[0]['classification'] != "3" && $currentinfo[0]['branchid'] == "")  {
		// missing branch id
		$error[] = "e2";
	}
	// check for organisation id
	if($currentinfo[0]['classification'] != "3" && $currentinfo[0]['organisationid'] == "")  {
		// missing organisation id
		$error[] = "e1";
	}
	// get the themes
	$params['theme'] = get_themes();
	// get the languages
	$params['language'] = get_languages();
	// check for errors
	if($error) {
		$params['module'] = "user";
		$params['function'] = "create";
		$params['classification'] = $currentinfo[0]['classification'];
		$params['organisationid'] = $currentinfo[0]['organisationid'];
		$params['branchid'] = $currentinfo[0]['branchid'];
		$params['currentinfo'] = $currentinfo;
		$params['errors'] = $error;
		$params['show'] = TRUE;
		// send the message to app
		send_message($params,$cfg);
	} else {
		$params['module'] = "user";
		$params['function'] = "create";
		$params['organisationid'] = $currentinfo[0]['organisationid'];
		$params['branchid'] = $currentinfo[0]['branchid'];
		$params['currentinfo'] = $currentinfo;
		// send the message to app
		send_message($params,$cfg);
	}
} else {
	// field request errors and type 
	$fields_request = array (
		'organisationid'	=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e17"),
		'branchid'			=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e18"),
		'classification'	=> array("e16",	REQUEST_NUMBER,	FORMAT_NONE,	"e30")
	);
	// get data
	if(get_request($fields_request,$info[0],$error,$cfg)) {
		$info[0]['lang'] = $cfg['language'];
		$info[0]['theme'] = $cfg['theme'];
		$info[0]['mandate'] = "0.00";
		$params = array(
			'module'			=> "user",
			'function'			=> "create",
			'classification'	=> $info[0]['classification'],
			'organisationid'	=> $info[0]['organisationid'],
			'branchid'			=> $info[0]['branchid'],
			'currentinfo'		=> $info,
			'show'				=> TRUE
		);
		// get the themes
		$params['theme'] = get_themes();
		// get the languages
		$params['language'] = get_languages();
		// send the message to app
		send_message($params,$cfg);
	} else {
		// error
		xml_generator("user","error",$error,"",$cfg);
	}
}
?>