<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* User profile
* @package TenderSystem
* @subpackage user
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'changeuser'	=> array()
);
get_request($fields_request,$action,$error,$cfg);
if($action['changeuser']) {
	// field request errors and type 
	$fields_request = array (
		'id'				=> array("e31",	REQUEST_NUMBER,	FORMAT_NONE,	"e32"),
		'phone_prefix'		=> array("e4",	REQUEST_NUMBER,	FORMAT_NONE,	"e19"),
		'phone_work'		=> array("e7",	REQUEST_PHONE,	FORMAT_PHONE,	"e20"),
		'phone_fax'			=> array("e8",	REQUEST_PHONE,	FORMAT_PHONE,	"e21"),
		'phone_mobile'		=> array("e9",	REQUEST_PHONE,	FORMAT_PHONE,	"e22"),
		'email'				=> array("e10",	REQUEST_EMAIL,	FORMAT_NONE,	"e23"),
		'preference'		=> array("e11",	REQUEST_CHAR,	FORMAT_NONE,	"e24"),
		'permission'		=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e25"),
		'theme'				=> array("e13",	REQUEST_THEME,	FORMAT_NONE,	"e26"),
		'language'			=> array("e14",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
		'mandate'			=> array("",	REQUEST_MONEY,	FORMAT_MONEY,	"e28"),
		'branch'			=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e18"),
		'administrator'		=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e29"),
		'additional'		=> array(),
		'emailimages'		=> array(),
		'status'			=> array(),
		'skype'				=> array(),
		'date_of_birth'		=> array(),
		'im_contact'		=> array(),
		'instant_messager'	=> array(),
		'theme_refresh'		=> array()
	);
	// get data
	if(get_request($fields_request,$update,$error,$cfg)) {
		// remove empty fields
		foreach($update as $key => $value) {
			if($value === "") {
				unset($update[$key]);	
			}
		}
		// addition column fields, added by other modules
		if(is_array($update['additional'])) {
			foreach($update['additional'] as $key => $value) {
				$update[$key] = $value;	
			}
			unset($update['additional']);
		}
		$id = $update['id'];
		unset($update['id']);
		$params = array(
			'module'	=> 'user',
			'function'	=> 'profile',
			'update'	=> $update,
			'id'		=> $id
		);
		// unset and reset user theme
		if ($update['theme_refresh']) {
			unset($_SESSION['ts_theme']);
			unset($update['theme_refresh']);
			$_SESSION['ts_theme'] = $update['theme'];
		}
	} else {
		$params = array(
			'module'	=> 'user',
			'function'	=> 'profile',
			'id'		=> $update['id'],
			'error'		=> $error
		);
	}
	// get the themes
	$params['theme'] = get_themes();
	// get the themes
	$params['language'] = get_languages();
	// send the message to app
	send_message($params,$cfg);
} else {
	// field request errors and type 
	$fields_request = array (
		'id'	=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e32")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		// set parameters
		$params = array(
			'module'	=> 'user',
			'function'	=> 'profile',
			'id'		=> $info['id']
		);
		// get the themes
		$params['theme'] =  get_themes();
		// get the lanugage
		$params['language'] = get_languages();
		// send the message to app
		send_message($params,$cfg);
	} else {
		xml_generator("user","error",$error,"",$cfg,$conn);	
	}
}
?>