<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<xsl:param name="display" select="/response/display"/>
<xsl:param name="more" select="/response/more"/>
<xsl:param name="type" select="/response/type"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/controlpanel"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	<xsl:if test="session">
			<script>
		<xsl:choose>
			<xsl:when test="offsite">
				window.location.href = "index.php";
			</xsl:when>
			<xsl:otherwise>
				parent.menu.location.reload();
			</xsl:otherwise>
		</xsl:choose>
			</script>
	</xsl:if>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/controlpanel"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'user'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="module"/>
					<input type="hidden" name="function" value="function"/>
					<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>			
							<td align="left" class="t1">
								<xsl:value-of select="$lng/welcome"/><xsl:value-of select="' '"/><xsl:value-of select="user/name"/><br/><br/>
							</td>
						</tr>
						<tr>
							<td><br/></td>			
							<td align="left" class="t">
						<xsl:choose>
							<xsl:when test="user/classification='3'">
								<xsl:for-each select="$lng/adminmessage">
									<xsl:value-of select="."/><br/>
								</xsl:for-each>
							</xsl:when>
							<xsl:when test="user/classification='2'">
								<xsl:for-each select="$lng/subscribermessage">
									<xsl:value-of select="."/><br/>
								</xsl:for-each>
							</xsl:when>
							<xsl:when test="user/classification='1'">
								<xsl:for-each select="$lng/agentmessage">
									<xsl:value-of select="."/><br/>
								</xsl:for-each>
							</xsl:when>
						</xsl:choose>
								<br/>
							</td>
						</tr>
					<xsl:if test="control_notice">
						<tr>
							<td><br/></td>			
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/notices"/>
								<br/>
							</td>
						</tr>
						<xsl:for-each select="control_notice">
						<tr>
							<td></td>
							<td align="left" class="t2">
								<xsl:if test="class">
									<xsl:attribute name="class"><xsl:value-of select="class"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="prename">
									<xsl:value-of select="prename"/>
								</xsl:if>
								<a href="{frame}.php?module={module}&amp;function={function}">
							<xsl:choose>
								<xsl:when test="remote_link">
									<xsl:attribute name="target">blank</xsl:attribute>
									<xsl:attribute name="href"><xsl:value-of select="remote_link"/></xsl:attribute>
								</xsl:when>
								<xsl:when test="frame and module and function">
									<xsl:attribute name="href"><xsl:value-of select="frame"/>.php?module=<xsl:value-of select="module"/>&amp;function=<xsl:value-of select="function"/></xsl:attribute>
								</xsl:when>
							</xsl:choose>
									<xsl:value-of select="name"/>
								</a>
							</td>
						</tr>
						</xsl:for-each>
						<tr><td><br/></td></tr>
					</xsl:if>
					<xsl:if test="control_information">
						<tr>
							<td><br/></td>			
							<td align="left" class="h1 t1">
								<xsl:value-of select="$lng/info"/>
								<br/>
							</td>
						</tr>
						<xsl:for-each select="control_information">
						<tr>
							<td></td>
							<td align="left" class="t2">
								<xsl:if test="class">
									<xsl:attribute name="class"><xsl:value-of select="class"/></xsl:attribute>
								</xsl:if>
								<xsl:if test="prename">
									<xsl:value-of select="prename"/>
								</xsl:if>
								<a href="{frame}.php?module={module}&amp;function={function}">
							<xsl:choose>
								<xsl:when test="remote_link">
									<xsl:attribute name="target">blank</xsl:attribute>
									<xsl:attribute name="href"><xsl:value-of select="remote_link"/></xsl:attribute>
								</xsl:when>
								<xsl:when test="frame and module and function">
									<xsl:attribute name="href"><xsl:value-of select="frame"/>.php?module=<xsl:value-of select="module"/>&amp;function=<xsl:value-of select="function"/></xsl:attribute>
								</xsl:when>
							</xsl:choose>
								<xsl:if test="class">
									<xsl:attribute name="class"><xsl:value-of select="class"/></xsl:attribute>
								</xsl:if>
									<xsl:value-of select="name"/>
								</a>
							</td>
						</tr>
						</xsl:for-each>
					</xsl:if>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/manual"/>
				</div>
				<div id="right_content">
				<xsl:if test="user/classification!='2'">
					<a href="./manuals/{$language}/supplier_manual.pdf">
						<img src="./theme/{$theme}/icon/pdf.gif" border="0"/>
						<xsl:value-of select="' '"/><xsl:value-of select="$lng/agentmanual"/>
					</a>
					<br/>
				</xsl:if>
				<xsl:if test="user/classification!='1'">
					<a href="./manuals/{$language}/user_manual.pdf">
						<img src="./theme/{$theme}/icon/pdf.gif" border="0"/>
						<xsl:value-of select="' '"/><xsl:value-of select="$lng/subscribermanual"/>
					</a>
					<br/>
				</xsl:if>
				<xsl:if test="user/classification='3'">
					<a href="./manuals/{$language}/admin_manual.pdf">
						<img src="./theme/{$theme}/icon/pdf.gif" border="0"/>
						<xsl:value-of select="' '"/><xsl:value-of select="$lng/adminmanual"/>
					</a>
					<br/>
				</xsl:if>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		<xsl:if test="next_module!='' and next_function!=''">
			parent.main.location.href="main.php?module=<xsl:value-of select="next_module"/>&amp;function=<xsl:value-of select="next_function"/>";
		</xsl:if>
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>