<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<xsl:param name="display" select="/response/display"/>
<xsl:param name="more" select="/response/more"/>
<xsl:param name="type" select="/response/type"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/controlpanel"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	<xsl:if test="session">
			<script>
		<xsl:choose>
			<xsl:when test="offsite">
				window.location.href = "index.php";
			</xsl:when>
			<xsl:otherwise>
				parent.menu.location.reload();
			</xsl:otherwise>
		</xsl:choose>
			</script>
	</xsl:if>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/controlpanel"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'user'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="module"/>
					<input type="hidden" name="function" value="function"/>
					<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>			
							<td align="left" colspan="7" class="t1">
								<xsl:value-of select="$lng/welcome"/><xsl:value-of select="' '"/><xsl:value-of select="user/name"/><br/><br/>
							</td>
						</tr>
					<xsl:if test="removeinstall">
						<tr>
							<td><br/></td>
							<td align="left" colspan="7" class="e">
								<a href="main.php?module=loader&amp;function=remove&amp;dir={removeinstall}" class="e">
									<xsl:value-of select="$lng/removeinstallmodule"/>
								</a>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="firstlogin">
						<tr>
							<td><br/></td>
							<td align="left" colspan="7" class="t1">
								<a href="http://www.tendersystem.com/register.php" target="blank">
									<xsl:value-of select="$lng/registerattendersystem"/>
								</a>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td><br/></td>			
							<td align="left" colspan="7" class="t">
								<xsl:for-each select="$lng/adminmessage">
									<xsl:value-of select="."/><br/>
								</xsl:for-each>
								<br/>
							</td>
						</tr>
				<xsl:if test="approvaltenders/tenderid">
						<tr>
							<td><br/></td>
							<td class="h t1" colspan='5'>
								<xsl:value-of select="$lng/tenderawaitingapproval"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h1b t1"><xsl:value-of select="$lng/rfqnumber"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/subscriber"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/createdon"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/area"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/status"/></td>
						</tr>
					<xsl:for-each select="approvaltenders">
						<tr>
							<td><br/></td>
							<td class="h2b t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tenderid)"/>
									</xsl:attribute>
									<xsl:value-of select="rfq_number"/>
								</a>
							</td>
							<td class="h2c t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',usersid)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/><xsl:value-of select="' '"/><xsl:value-of select="surname"/>
								</a>
							</td>
							<td class="h2c t2"><xsl:value-of select="created_date"/></td>
							<td class="h2c t2"><xsl:value-of select="areaname"/></td>
							<td class="h2c t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=tender&amp;function=approve&amp;tenderid=',tenderid)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/approve"/>
								</a>
							</td>
						</tr>
					</xsl:for-each>
						<tr>
							<td><br/></td>
						</tr>
				</xsl:if>
				<xsl:if test="approvalorganisation">
						<tr>
							<td><br/></td>
							<td class="h t1" colspan='6'>
								<xsl:value-of select="$lng/organisationawaitingapproval"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/organisation"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/type"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/createdby"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/email"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/phonemobile"/>
							</td>
						</tr>
						<xsl:for-each select="approvalorganisation">
							<tr>
								 <td><br/></td>
								<td class="h2b t2" align="center">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',./organisationid)"/>
										</xsl:attribute>
										<xsl:value-of select="organisationname"/>
									</a>
								</td>
								<td class="h2c t2" align="center">
									<xsl:choose>
										<xsl:when test="./classification='1'">
											<xsl:value-of select="$lng/supplier"/>
										</xsl:when>
										<xsl:when test="./classification='2'">
											<xsl:value-of select="$lng/company"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$lng/unknown"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="h2c t2" align="center">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./rep_user_id)"/>
										</xsl:attribute>
										<xsl:value-of select="repname"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="repsurname"/>
									</a>
								</td>
								<td class="h2c t2" align="center">
									<a href="mailto:{repemail}">
										<xsl:value-of select="repemail"/>
									</a>
								</td>
								<td class="h2c t2" align="center">
									<a>
										<xsl:attribute name="href">
											<xsl:value-of select="'callto://+'"/>
											<xsl:value-of select="repphone_prefix"/>
											<xsl:number value="repphone_work" format="1"/>
										</xsl:attribute>
										<xsl:value-of select="repphone_work"/>
									</a>
								</td>
								<td class="h2c t2" align="center">
									<a>
										<xsl:attribute name="href">
											<xsl:value-of select="'callto://+'"/>
											<xsl:value-of select="repphone_prefix"/>
											<xsl:number value="repphone_mobile" format="1"/>
										</xsl:attribute>
										<xsl:value-of select="repphone_mobile"/>
									</a>
								</td>
							</tr>
						</xsl:for-each>
						<tr><td><br/></td></tr>
					</xsl:if>
						<tr>
							<td><br/></td>
							<td class="h t1" colspan="7"><xsl:value-of select="$lng/lastlogin"/></td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h1b t1"><xsl:value-of select="$lng/fullname"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/date"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/idle"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/usertype"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/ipaddress"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/browser"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/status"/></td>
						</tr>
						<xsl:if test="login">
							<xsl:variable name="usersid" select="user/usersid"/>
							<xsl:for-each select="login">
								<tr>
									<td><br/></td>
									<td class="h2b">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',usersid)"/>
											</xsl:attribute>
											<xsl:choose>
												<xsl:when test="$usersid=usersid">
													<xsl:value-of select="$lng/you"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="name"/>
													<xsl:value-of select="' '"/>
													<xsl:value-of select="surname"/>
												</xsl:otherwise>
											</xsl:choose>
										</a>
									</td>
									<td class="h2c"><xsl:value-of select="created_on"/></td>
								<xsl:if test="idle!='--'">
									<td class="h2c" align="right"><xsl:value-of select="idle"/></td>
								</xsl:if>
								<xsl:if test="idle='--'">
									<td class="h2c" align="center"><xsl:value-of select="idle"/></td>
								</xsl:if>
									<td class="h2c">
										<xsl:choose>
											<xsl:when test="classification='3'">
												<xsl:value-of select="$lng/admin"/>
											</xsl:when>
											<xsl:when test="classification='1'">
												<xsl:value-of select="$lng/agent"/>
											</xsl:when>
											<xsl:when test="classification='2'">
												<xsl:value-of select="$lng/subscriber"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
												<xsl:value-of select="' ('"/>
												<xsl:value-of select="classification"/>
												<xsl:value-of select="')'"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c">
										<a href="http://ws.arin.net/cgi-bin/whois.pl?queryinput={ip_address}">
											<xsl:value-of select="ip_address"/>
										</a>
									</td>
									<xsl:if test="browser!='--'">
										<td class="h2c" align="right"><xsl:value-of select="browser"/></td>
									</xsl:if>
									<xsl:if test="browser='--'">
										<td class="h2c" align="center"><xsl:value-of select="browser"/></td>
									</xsl:if>
									<td class="h2c">
										<xsl:choose>
											<xsl:when test="status='1'">
												<xsl:choose>
													<xsl:when test="expired='1'">
														<xsl:value-of select="$lng/expired"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$lng/active"/>
													</xsl:otherwise>
												</xsl:choose>		
											</xsl:when>
											<xsl:when test="status='0'">
												<xsl:value-of select="$lng/logout"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td><br/></td>
								<td class="h2b" colspan="7">
									<xsl:if test="$display &gt; 0">
										<xsl:variable name="previous" select="$display - 1"/>
										<a href="main.php?module=user&amp;function=control&amp;displaypage={$previous}">
											<img src="./theme/{$theme}/icon/left.gif" border="0" alt="Previous" hspace="1" align="absmiddle"/>
										</a>
									</xsl:if>
									<xsl:if test="$more='1'">
										<xsl:variable name="next" select="$display + 1"/>
										<a href="main.php?module=user&amp;function=control&amp;displaypage={$next}">
											<img src="./theme/{$theme}/icon/right.gif" border="0" alt="Next" hspace="1" align="absmiddle" />
										</a>
									</xsl:if>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/manual"/>
				</div>
				<div id="right_content">
					<a href="./manuals/{$language}/supplier_manual.pdf">
						<img src="./theme/{$theme}/icon/pdf.gif" border="0"/>
						<xsl:value-of select="' '"/><xsl:value-of select="$lng/agentmanual"/>
					</a>
					<br/>
					<a href="./manuals/{$language}/user_manual.pdf">
						<img src="./theme/{$theme}/icon/pdf.gif" border="0"/>
						<xsl:value-of select="' '"/><xsl:value-of select="$lng/subscribermanual"/>
					</a>
					<br/>
					<a href="./manuals/{$language}/admin_manual.pdf">
						<img src="./theme/{$theme}/icon/pdf.gif" border="0"/>
						<xsl:value-of select="' '"/><xsl:value-of select="$lng/adminmanual"/>
					</a>
					<br/>
					<a href="./manuals/{$language}/install_manual.pdf">
						<img src="./theme/{$theme}/icon/pdf.gif" border="0"/>
						<xsl:value-of select="' '"/><xsl:value-of select="$lng/installmanual"/>
					</a>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>