<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/countries.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>
<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<link rel="stylesheet" type="text/css" media="all" href="./theme/{$theme}/style_calendar.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/createagent"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'user'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="user"/>
					<input type="hidden" name="function" value="create"/>
					<input type="hidden" name="classification" value="1"/>
					<input type="hidden" name="organisationid" value="{organisationid}"/>
					<input type="hidden" name="branchid" value="{branchid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="4" class="h t1">
								<xsl:value-of select="$lng/info"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/firstname"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="name" class="t2" value="{currentinfo/name}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/surname"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="surname" class="t2" value="{currentinfo/surname}" onchange="update_username()"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/username"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="username" class="t2" value="{currentinfo/username}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phoneprefix"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:call-template name="countries">
									<xsl:with-param name="selectname" select="'phone_prefix'"/>
									<xsl:with-param name="message" select="$lng/dialcode"/>
									<xsl:with-param name="optionvalue" select="'dialcode'"/>
									<xsl:with-param name="optioncontent" select="'all'"/>
									<xsl:with-param name="optionselected" select="currentinfo/phone_prefix"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="phone_work" class="t2" value="{currentinfo/phone_work}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonefax"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="phone_fax" class="t2" value="{currentinfo/phone_fax}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonemobile"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="phone_mobile" class="t2" value="{currentinfo/phone_mobile}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/email"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="email" class="t2" value="{currentinfo/email}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/notification"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="preference" class="t2">
									<option value="m">
										<xsl:value-of select="$lng/emailn"/>
									</option>
									<option value="n">
										<xsl:if test="currentinfo/preference='n'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/emailandsms"/>
									</option>
									<option value="0">
										<xsl:if test="currentinfo/preference='0'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/none"/>
									</option>
								</select>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/permlevel"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="permission" class="t2">
									<xsl:if test="user/classification='3' or user/permission &gt;= '2'">
										<option value="2">
											<xsl:if test="currentinfo/permission='2'">
												<xsl:attribute name="selected"/>
											</xsl:if>
											<xsl:value-of select="$lng/superlevel"/>
										</option>
									</xsl:if>
									<xsl:if test="user/classification='3' or user/permission &gt;= '1'">
										<option value="1">
											<xsl:if test="currentinfo/permission='1'">
												<xsl:attribute name="selected"/>
											</xsl:if>
											<xsl:value-of select="$lng/normallevel"/>
										</option>
									</xsl:if>		
								</select>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/dateofbirth"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="date_of_birth" id="date_of_birth" class="t2" value="{currentinfo/date_of_birth}" size="10"/>
							</td>
							<td align="right" class="t2">
								<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_date_of_birth" style="cursor: pointer; border: 0px;" alt="Date selector" />
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/skype"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="skype" class="t2" value="{currentinfo/skype}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/instantmessager"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="instant_messager" class="t2">
									<option value="YAHOO">
										<xsl:if test="currentinfo/instant_messager='YAHOO'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/yahoomessager"/>
									</option>
									<option value="ICQ">
										<xsl:if test="currentinfo/instant_messager='ICQ'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/icqmessager"/>
									</option>
									<option value="MSN">
										<xsl:if test="currentinfo/instant_messager='MSN'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/msnmessager"/>
									</option>
									<option value="GOOGLE">
										<xsl:if test="currentinfo/instant_messager='GOOGLE'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/googletalk"/>
									</option>
								</select>
								<input type="text" name="im_contact" class="t2" value="{currentinfo/im_contact}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/theme"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="theme" class="t2">
							<xsl:for-each select="theme">
								<xsl:variable name="theme" select="."/>
									<option value="{$theme}">
										<xsl:if test="$theme=../currentinfo/theme">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$theme"/>
									</option>
							</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/language"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="lang" class="t2">
							<xsl:for-each select="language">
								<xsl:variable name="selectlang" select="."/>
									<option value="{$selectlang}">
										<xsl:if test="$selectlang=../currentinfo/lang">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:call-template name="language_value">
											<xsl:with-param name="iso" select="$selectlang"/>
										</xsl:call-template>
									</option>
							</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/emailimages"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="emailimages" class="t2">
									<option value="P">
										<xsl:if test="currentinfo/emailimages='P'"><xsl:attribute name="selected"/></xsl:if>
										<xsl:value-of select="$lng/preferpictures"/>
									</option>
									<option value="W">
										<xsl:if test="currentinfo/emailimages='W'"><xsl:attribute name="selected"/></xsl:if>
										<xsl:value-of select="$lng/preferwords"/>
									</option>
									<option value="B">
										<xsl:if test="currentinfo/emailimages='B'"><xsl:attribute name="selected"/></xsl:if>
										<xsl:value-of select="$lng/preferpandw"/>
									</option>
								</select>
							</td>
						</tr>
						<xsl:call-template name="additional"/>
						<tr>
							<td align="right" width="270" colspan="2">
								<input type="submit" name="createuser" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/instructions"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/createinst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>
	
	<script type="text/javascript">
		function update_username() {
			document.report.username.value = document.report.name.value.toLowerCase() + document.report.surname.value[0].toLowerCase();
		}
		
		Calendar.setup({inputField:"date_of_birth",ifFormat:"%Y-%m-%d",button:"trigger_date_of_birth",singleClick:true});
	</script>
</body>
</html> 

</xsl:template>

<xsl:template name="additional">
 <xsl:if test="userinfo/additional">
		<xsl:for-each select="userinfo/additional">
			<xsl:variable name="current" select="current"/>
			<tr>
				<td ><br/></td>
				<td align="left" class="t1">
					<xsl:value-of select="name"/>
				</td>
				<td align="left" colspan="2" class="t2">
	<xsl:choose>
		<xsl:when test="type='select' or type='Select' or type='SELECT'">
			<select name="additional[{column}]" class="t2">
				<xsl:for-each select="option">
					<option value="{value}">
						<xsl:if test="$current=value">
							<xsl:attribute name="selected"/>
						</xsl:if>
						<xsl:value-of select="name"/>
					</option>
				</xsl:for-each>
			</select>
		</xsl:when>								
		<xsl:otherwise>
			<input name="additional[{column}]" value="{$current}" class="t2">
				<xsl:if test="size">
					<xsl:attribute name="size"><xsl:value-of select="size"/></xsl:attribute>
				</xsl:if>
			</input>
		</xsl:otherwise>
	</xsl:choose>
				</td> 
			</tr>
		</xsl:for-each>  
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
