<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Template -->
<xsl:template name="profile">
	<xsl:param name="without_firstname" select="''"/>
	<xsl:param name="without_surname" select="''"/>
	<xsl:param name="without_permission" select="''"/>
	<xsl:param name="without_phoneprefix" select="''"/>
	<xsl:param name="without_phonework" select="''"/>
	<xsl:param name="without_phonefax" select="''"/>
	<xsl:param name="without_phonemobile" select="''"/>
	<xsl:param name="without_email" select="''"/>
	<xsl:param name="without_dateofbirth" select="''"/>
	<xsl:param name="without_skype" select="''"/>
	<xsl:param name="without_instantmessager" select="''"/>
	<xsl:param name="without_theme" select="''"/>
	<xsl:param name="without_language" select="''"/>
	<xsl:param name="without_notification" select="''"/>
	<xsl:param name="without_mandate" select="''"/>
	<xsl:param name="without_emailimages" select="''"/>
	<xsl:param name="without_admin" select="''"/>
	<xsl:param name="without_createdon" select="''"/>
	<xsl:param name="without_createdby" select="''"/>
	<xsl:param name="without_deletedon" select="''"/>
	<xsl:param name="without_deletedby" select="''"/>
	<xsl:param name="without_status" select="''"/>
	<xsl:param name="without_branchname" select="''"/>
	<xsl:param name="without_branchphonework" select="''"/>
	<xsl:param name="without_branchphonefax" select="''"/>
	<xsl:param name="without_branchemail" select="''"/>
	<xsl:param name="without_organisationname" select="''"/>
	<xsl:param name="without_transactionmin" select="''"/>
	<xsl:param name="without_transactionfee" select="''"/>
	<xsl:param name="without_userfee" select="''"/>
	<xsl:param name="without_messagefee" select="''"/>
	<xsl:param name="without_branchtitle" select="''"/>
	<xsl:param name="without_orgtitle" select="''"/>
	<xsl:if test="deleted='1'">
		<tr>
			<td colspan="4" class="t1">
				<xsl:value-of select="$lng/deleted"/>
			</td>
		</tr>
	</xsl:if>
	<xsl:if test="created='1'">
		<tr>
			<td colspan="4" class="t1">
				<xsl:value-of select="$lng/createduser"/>
			</td>
		</tr>
	</xsl:if>
	<xsl:if test="updated='1'">
		<tr>
			<td colspan="4" class="t1">
				<xsl:value-of select="$lng/updated"/>
			</td>
		</tr>
	</xsl:if>
	<tr>
		<td colspan="4" class="h t1">
			<xsl:value-of select="$lng/info"/>:
			<xsl:value-of select="userinfo/name"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="userinfo/surname"/>
		</td>
	</tr>
	<xsl:if test="$without_firstname!='yes'">
		<xsl:call-template name="firstname"/>
	</xsl:if>
	<xsl:if test="$without_surname!='yes'">
		<xsl:call-template name="surname"/>
	</xsl:if>
	<xsl:if test="$without_permission!='yes'">
		<xsl:call-template name="permission"/>
	</xsl:if>
	<xsl:if test="$without_phoneprefix!='yes'">
		<xsl:call-template name="phoneprefix"/>
	</xsl:if>
	<xsl:if test="$without_phonework!='yes'">
		<xsl:call-template name="phonework"/>
	</xsl:if>
	<xsl:if test="$without_phonefax!='yes'">
		<xsl:call-template name="phonefax"/>
	</xsl:if>
	<xsl:if test="$without_phonemobile!='yes'">
		<xsl:call-template name="phonemobile"/>
	</xsl:if>
	<xsl:if test="$without_email!='yes'">
		<xsl:call-template name="email"/>
	</xsl:if>
	<xsl:if test="$without_dateofbirth!='yes'">
		<xsl:call-template name="dateofbirth"/>
	</xsl:if>
	<xsl:if test="$without_skype!='yes'">
		<xsl:call-template name="skype"/>
	</xsl:if>
	<xsl:if test="$without_instantmessager!='yes'">
		<xsl:call-template name="instantmessager"/>
	</xsl:if>
	<xsl:if test="$without_theme!='yes'">
		<xsl:call-template name="theme"/>
	</xsl:if>
	<xsl:if test="$without_language!='yes'">
		<xsl:call-template name="language"/>
	</xsl:if>
	<xsl:if test="$without_notification!='yes'">
		<xsl:call-template name="notification"/>
	</xsl:if>
	<xsl:if test="$without_mandate!='yes'">
		<xsl:call-template name="mandate"/>
	</xsl:if>
	<xsl:if test="$without_emailimages!='yes'">
		<xsl:call-template name="emailimages"/>
	</xsl:if>
	<!-- addtional things add -->
	<xsl:call-template name="additional"/>
	<xsl:if test="$without_admin!='yes'">
		<xsl:call-template name="admin"/>
	</xsl:if>
	<xsl:if test="$without_createdon!='yes'">
		<xsl:call-template name="createdon"/>
	</xsl:if>
	<xsl:if test="$without_createdby!='yes'">
		<xsl:call-template name="createdby"/>
	</xsl:if>
	<xsl:if test="$without_status!='yes'">
		<xsl:call-template name="status"/>
	</xsl:if>
	<xsl:if test="$without_deletedon!='yes'">
		<xsl:call-template name="deletedon"/>
	</xsl:if>
	<xsl:if test="$without_deletedby!='yes'">
		<xsl:call-template name="deletedby"/>
	</xsl:if>
	<xsl:if test="editable='1'">
		<tr>
			<td align="right" width="270" colspan="4">
				<input type="submit" name="changeuser" class="t2">
					<xsl:attribute name="value">
						<xsl:value-of select="$lng/submit"/>
					</xsl:attribute>
				</input>
				<xsl:if test="userinfo/id!=user/usersid">
					<input type="checkbox" name="status" class="t2" onchange="alertremove()" value="0"/>
					<xsl:value-of select="$lng/delete"/>
				</xsl:if>
				<xsl:if test="userinfo/id=user/usersid">
					<input type="hidden" name="theme_refresh" value="TRUE"/>
				</xsl:if>
			</td>
		</tr>
	</xsl:if>
	<tr>
		<td colspan="2"><br/></td>
	</tr>
	<xsl:if test="$without_branchtitle!='yes'">
		<xsl:call-template name="branchtitle"/>
	</xsl:if>
	<xsl:if test="$without_branchname!='yes'">
		<xsl:call-template name="branchname"/>
	</xsl:if>
	<xsl:if test="$without_branchphonework!='yes'">
		<xsl:call-template name="branchphonework"/>
	</xsl:if>
	<xsl:if test="$without_branchphonefax!='yes'">
		<xsl:call-template name="branchphonefax"/>
	</xsl:if>
	<xsl:if test="$without_branchemail!='yes'">
		<xsl:call-template name="branchemail"/>
	</xsl:if>
	<tr>
		<td colspan="2"><br/></td>
	</tr>
	<xsl:if test="$without_orgtitle!='yes'">
		<xsl:call-template name="orgtitle"/>
	</xsl:if>
	<xsl:if test="$without_organisationname!='yes'">
		<xsl:call-template name="organisationname"/>
	</xsl:if>
	<xsl:if test="$without_transactionmin!='yes'">
		<xsl:call-template name="transactionmin"/>
	</xsl:if>
	<xsl:if test="$without_transactionfee!='yes'">
		<xsl:call-template name="transactionfee"/>
	</xsl:if>
	<xsl:if test="$without_userfee!='yes'">
		<xsl:call-template name="userfee"/>
	</xsl:if>
	<xsl:if test="$without_messagefee!='yes'">
		<xsl:call-template name="messagefee"/>
	</xsl:if>
</xsl:template>

<xsl:template name="branchtitle">
	<tr>
		<td colspan="4" class="h t1">
			<xsl:value-of select="$lng/branchinfo"/>:
			<a target="main">
				<xsl:attribute name="href">
					<xsl:value-of select="concat('./main.php?module=branch&amp;function=profile&amp;id=',userinfo/branchid)"/>
				</xsl:attribute>
				<xsl:value-of select="userinfo/branchname"/>
			</a>
		</td>
	</tr>
</xsl:template>

<xsl:template name="orgtitle">
	<tr>
		<td colspan="4" class="h t1">
			<xsl:value-of select="$lng/organisationinfo"/>:
			<a target="main">
				<xsl:attribute name="href">
					<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',userinfo/organisationid)"/>
				</xsl:attribute>
				<xsl:value-of select="userinfo/organisationname"/>
			</a>
		</td>
	</tr>
</xsl:template>

<xsl:template name="organisationname">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/organisationname"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<a target="main">
				<xsl:attribute name="href">
					<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',userinfo/organisationid)"/>
				</xsl:attribute>
				<xsl:value-of select="userinfo/organisationname"/>
			</a>
		</td>
	</tr>
</xsl:template>

<xsl:template name="transactionmin">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/transactionmin"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:value-of select="localprecurrency"/><xsl:value-of select="userinfo/transaction_min"/><xsl:value-of select="/response/localpostcurrency"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="transactionfee">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/transactionfee"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:value-of select="userinfo/transaction_fee"/><xsl:value-of select="'%'"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="userfee">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/userfee"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:value-of select="localprecurrency"/><xsl:value-of select="userinfo/user_fee"/><xsl:value-of select="/response/localpostcurrency"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="messagefee">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/messagefee"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:value-of select="localprecurrency"/><xsl:value-of select="userinfo/sms_fee"/><xsl:value-of select="/response/localpostcurrency"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="branchname">
	<tr>
		<td><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/branchname"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<a target="main">
				<xsl:attribute name="href">
					<xsl:value-of select="concat('./main.php?module=branch&amp;function=profile&amp;id=',userinfo/branchid)"/>
				</xsl:attribute>
				<xsl:value-of select="userinfo/branchname"/>
			</a>
		</td>

	</tr>
	<xsl:if test="editable='1' and admineditable='1' and (user/classification='3' or user/permission &gt; 2)">
		<tr>
			<td><br/></td>
			<td align="left" class="t1">
				<xsl:value-of select="$lng/changebranch"/>
			</td>
			<td align="left" colspan="2" class="t2">
				<select name="branch" class="t2">
					<xsl:for-each select="branch">
						<option value="{branchid}">
							<xsl:if test="../userinfo/branchid=branchid">
								<xsl:attribute name="selected"/>
							</xsl:if>
							<xsl:value-of select="branchname"/>
						</option>
					</xsl:for-each>
				</select>
			</td>
		</tr>
	</xsl:if>
</xsl:template>

<xsl:template name="branchphonework">
	<xsl:call-template name="phonenumber">
		<xsl:with-param name="name" select="$lng/phonework"/>
		<xsl:with-param name="number" select="userinfo/branchphone_work"/>
		<xsl:with-param name="phoneprefix" select="userinfo/branchphone_prefix"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="branchphonefax">
	<xsl:call-template name="phonenumber">
		<xsl:with-param name="name" select="$lng/phonefax"/>
		<xsl:with-param name="number" select="userinfo/branchphone_fax"/>
		<xsl:with-param name="phoneprefix" select="userinfo/branchphone_prefix"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="branchemail">
	<xsl:call-template name="emailtemplate">
		<xsl:with-param name="name" select="$lng/email"/>
		<xsl:with-param name="address" select="userinfo/branchemail"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="createdby">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/createdby"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<a target="main">
				<xsl:attribute name="href">
					<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',userinfo/creatorid)"/>
				</xsl:attribute>
				<xsl:value-of select="userinfo/creatorname"/>
				<xsl:value-of select="' '"/>
				<xsl:value-of select="userinfo/creatorsurname"/>
			</a>
		</td>
	</tr>
</xsl:template>
	
<xsl:template name="deletedby">
	<xsl:if test="userinfo/status='0'">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/deletedby"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<a target="main">
				<xsl:attribute name="href">
					<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',userinfo/deleterid)"/>
				</xsl:attribute>
				<xsl:value-of select="userinfo/deletername"/>
				<xsl:value-of select="' '"/>
				<xsl:value-of select="userinfo/deletersurname"/>
			</a>
		</td>
	</tr>
	</xsl:if>
</xsl:template>

<xsl:template name="status">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/status"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:choose>
				<xsl:when test="userinfo/status='2'">
					<xsl:value-of select="$lng/passwordactive"/>
				</xsl:when>
				<xsl:when test="userinfo/status='1'">
					<xsl:value-of select="$lng/active"/>
				</xsl:when>
				<xsl:when test="userinfo/status='0'">
					<xsl:value-of select="$lng/deleted"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$lng/unknown"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</tr>
</xsl:template>

<xsl:template name="notification">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/notification"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:if test="editable='0'">
				<xsl:choose>
					<xsl:when test="userinfo/preference='0'">
						<xsl:value-of select="$lng/none"/>
					</xsl:when>
					<xsl:when test="userinfo/preference='m'">
						<xsl:value-of select="$lng/email"/>
					</xsl:when>
					<xsl:when test="userinfo/preference='n'">
						<xsl:value-of select="$lng/emailandsms"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$lng/unknown"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="editable='1'">
				<select name="preference" class="t2">
					<option value="0">
						<xsl:value-of select="$lng/none"/>
					</option>
					<option value="m">
						<xsl:if test="userinfo/preference='m'">
							<xsl:attribute name="selected">selected</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="$lng/email"/>
					</option>
					<option value="n">
						<xsl:if test="userinfo/preference='n'">
							<xsl:attribute name="selected">selected</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="$lng/emailandsms"/>
					</option>
				</select>
			</xsl:if>
		</td>
	</tr>
</xsl:template>

<xsl:template name="admin">
	 <tr>
		<td><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/admin"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:if test="editable='0' or admineditable='0'">
				<a target="main">
					<xsl:attribute name="href">
						<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',userinfo/adminid)"/>
					</xsl:attribute>
					<xsl:value-of select="userinfo/adminname"/>
					<xsl:value-of select="' '"/>
					<xsl:value-of select="userinfo/adminsurname"/>
				</a>
			</xsl:if>
			<xsl:if test="editable='1' and admineditable='1'">
				<select name="administrator" class="t2">
					<xsl:for-each select="users">
						<option value="{usersid}">
							<xsl:if test="../userinfo/adminid=usersid">
								<xsl:attribute name="selected"/>
							</xsl:if>
							<xsl:value-of select="name"/>
							<xsl:value-of select="' '"/>
							<xsl:value-of select="surname"/>
						</option>
					</xsl:for-each>
				</select>
			</xsl:if>
		</td>
	</tr>
</xsl:template>

<xsl:template name="createdon">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/createdon"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:value-of select="userinfo/created_date"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="userinfo/created_time"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="localdisplay"/>
		</td>
	</tr>
</xsl:template>
	
<xsl:template name="deletedon">
	<xsl:if test="userinfo/status='0'">
		<tr>
			<td ><br/></td>
			<td align="left" class="t1">
				<xsl:value-of select="$lng/deletedon"/>
			</td>
			<td align="left" colspan="2" class="t2">
				<xsl:value-of select="userinfo/deleted_date"/>
				<xsl:value-of select="' '"/>
				<xsl:value-of select="userinfo/deleted_time"/>
				<xsl:value-of select="' '"/>
				<xsl:value-of select="localdisplay"/>
			</td>
		</tr>
	</xsl:if>
</xsl:template>

<xsl:template name="mandate">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/mandate"/>
		</td>
		<td align="left" class="t2">
			<xsl:value-of select="localprecurrency"/>
			<input type="text" name="mandate" class="t2" size="8">
				<xsl:attribute name="value">
					<xsl:value-of select="userinfo/mandate"/>
				</xsl:attribute>
				<xsl:if test="admineditable='0'">
					<xsl:attribute name="readonly"/>
					<xsl:attribute name="class">readonly t2</xsl:attribute>
				</xsl:if>
			</input>
			<xsl:value-of select="/response/localpostcurrency"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="theme">
	<tr>
		<td><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/theme"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:if test="editable='0'">
				<xsl:value-of select="userinfo/theme"/>
			</xsl:if>
			<xsl:if test="editable='1'">
				<select name="theme" class="t2">
					<xsl:for-each select="availabletheme">
						<option>
							<xsl:if test="../userinfo/theme=.">
								<xsl:attribute name="selected">selected</xsl:attribute>
							</xsl:if>
							<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
							<xsl:value-of select="."/>
						</option>
					</xsl:for-each>
				</select>
			</xsl:if>
		</td>
	</tr>
</xsl:template>

<xsl:template name="language">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/language"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:if test="editable='0'">
				<xsl:value-of select="userinfo/language"/>
			</xsl:if>
			<xsl:if test="editable='1'">
				<select name="language" class="t2">
					<xsl:for-each select="availablelang">
						<option>
							<xsl:if test="../userinfo/language=.">
								<xsl:attribute name="selected">selected</xsl:attribute>
							</xsl:if>
							<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
							<xsl:call-template name="language_value">
								<xsl:with-param name="iso" select="."/>
							</xsl:call-template>
						</option>
					</xsl:for-each>
				</select>
			</xsl:if>
		</td>
	</tr>
</xsl:template>

<xsl:template name="email">
	<xsl:call-template name="emailtemplate">
		<xsl:with-param name="name" select="$lng/email"/>
		<xsl:with-param name="inputname" select="'email'"/>
		<xsl:with-param name="address" select="userinfo/email"/>
		<xsl:with-param name="editable" select="editable"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="emailtemplate">
	<xsl:param name="name" select="''"/>
	<xsl:param name="inputname" select="''"/>
	<xsl:param name="address" select="''"/>
	<xsl:param name="editable" select="'0'"/>
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$name"/>
		</td>
		<td align="left" class="t2">
			<input type="text" name="{$inputname}" class="t2" size="30" value="{$address}">
				<xsl:if test="$editable='0'">
					<xsl:attribute name="readonly"/>
					<xsl:attribute name="class">readonly t2</xsl:attribute>
				</xsl:if>
			</input>
		</td>
		<td align="right"  class="t1">
			<a href="mailto:{$address}">
				<img src="./theme/{$theme}/icon/mail_replay.gif" border="0" alt="{$lng/email}" title="{$lng/email}"/>
			</a>
		</td>
	</tr>
</xsl:template>

<xsl:template name="phonefax">
	<xsl:call-template name="phonenumber">
		<xsl:with-param name="name" select="$lng/phonefax"/>
		<xsl:with-param name="inputname" select="'phone_fax'"/>
		<xsl:with-param name="number" select="userinfo/phone_fax"/>
		<xsl:with-param name="phoneprefix" select="userinfo/phone_prefix"/>
		<xsl:with-param name="editable" select="editable"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="phonemobile">
	<xsl:call-template name="phonenumber">
		<xsl:with-param name="name" select="$lng/phonemobile"/>
		<xsl:with-param name="inputname" select="'phone_mobile'"/>
		<xsl:with-param name="number" select="userinfo/phone_mobile"/>
		<xsl:with-param name="phoneprefix" select="userinfo/phone_prefix"/>
		<xsl:with-param name="editable" select="editable"/>
		<xsl:with-param name="sms" select="'1'"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="phonework">
	<xsl:call-template name="phonenumber">
		<xsl:with-param name="name" select="$lng/phonework"/>
		<xsl:with-param name="inputname" select="'phone_work'"/>
		<xsl:with-param name="number" select="userinfo/phone_work"/>
		<xsl:with-param name="phoneprefix" select="userinfo/phone_prefix"/>
		<xsl:with-param name="editable" select="editable"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="phonenumber">
	<xsl:param name="name" select="''"/>
	<xsl:param name="inputname" select="''"/>
	<xsl:param name="number" select="''"/>
	<xsl:param name="phoneprefix" select="''"/>
	<xsl:param name="editable" select="'0'"/>
	<xsl:param name="sms" select="'0'"/>
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$name"/>
		</td>
		<td align="left" class="t2">
			<input type="text" name="{$inputname}" class="t2" value="{$number}">
				<xsl:if test="$editable='0'">
					<xsl:attribute name="readonly"/>
					<xsl:attribute name="class">readonly t2</xsl:attribute>
				</xsl:if>
			</input>
		</td>
		<td align="right"  class="t1">
			<xsl:if test="$sms='1' and user/classification='3'">
				<a>
					<xsl:attribute name="href">./main.php?module=messenger&amp;function=utilities&amp;usersid=<xsl:value-of select="userinfo/id"/></xsl:attribute>
					<img src="./theme/{$theme}/icon/sms.gif" border="0" alt="{$lng/sms}" title="{$lng/sms}"/>
				</a>
			</xsl:if>
			<a>
				<xsl:attribute name="href">
					<xsl:value-of select="'callto://+'"/>
					<xsl:value-of select="$phoneprefix"/>
					<xsl:number value="$number" format="1"/>
				</xsl:attribute>
				<img src="./theme/{$theme}/icon/call.gif" border="0" alt="{$lng/call}" title="{$lng/call}"/>
			</a>
		</td>
	</tr>
</xsl:template>

<xsl:template name="phoneprefix">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/phoneprefix"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:if test="editable='1'">
				<xsl:call-template name="countries">
					<xsl:with-param name="selectname" select="'phone_prefix'"/>
					<xsl:with-param name="message" select="$lng/dialcode"/>
					<xsl:with-param name="optionvalue" select="'dialcode'"/>
					<xsl:with-param name="optioncontent" select="'all'"/>
					<xsl:with-param name="optionselected" select="userinfo/phone_prefix"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="editable='0'">
				<xsl:value-of select="userinfo/phone_prefix"/>
			</xsl:if>
		</td>
	</tr>
</xsl:template>

<xsl:template name="permission">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/permlevel"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:if test="editable='0' or admineditable='0'">
				<xsl:if test="userinfo/classification='2'">
					<xsl:choose>
						<xsl:when test="userinfo/permission='4'">
							<xsl:value-of select="$lng/orglevel"/>
						</xsl:when>
						<!--
						<xsl:when test="userinfo/permission='3'">
							<xsl:value-of select="$lng/statelevel"/>
						</xsl:when> -->
						<xsl:when test="userinfo/permission='2'">
							<xsl:value-of select="$lng/branchlevel"/>
						</xsl:when>
						<xsl:when test="userinfo/permission='1'">
							<xsl:value-of select="$lng/normallevel"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$lng/unknown"/>
						</xsl:otherwise>									
					</xsl:choose>
				</xsl:if>
				<xsl:if test="userinfo/classification!='2'">
					<xsl:choose>
						<xsl:when test="userinfo/permission='2'">
							<xsl:value-of select="$lng/superlevel"/>
						</xsl:when>
						<xsl:when test="userinfo/permission='1'">
							<xsl:value-of select="$lng/normallevel"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$lng/unknown"/>
						</xsl:otherwise>									
					</xsl:choose>
				</xsl:if>
			</xsl:if>
			<xsl:if test="editable='1' and admineditable='1'">
				<xsl:if test="userinfo/classification='2'">
					<select name="permission" class="t2">
						<xsl:if test="user/permission >= 4 or user/classification = 3">
							<option value="4">
								<xsl:if test="userinfo/permission='4'">
									<xsl:attribute name="selected"/>
								</xsl:if>
								<xsl:value-of select="$lng/orglevel"/>
							</option>
						</xsl:if>
						<!--
						<xsl:if test="user/permission >= 3 or user/classification = 3">
							<option value="3">
								<xsl:if test="userinfo/permission='3'">
									<xsl:attribute name="selected"/>
								</xsl:if>
								<xsl:value-of select="$lng/statelevel"/>
							</option>
						</xsl:if> -->
						<xsl:if test="user/permission >= 2 or user/classification = 3">
							<option value="2">
								<xsl:if test="userinfo/permission='2'">
									<xsl:attribute name="selected"/>
								</xsl:if>
								<xsl:value-of select="$lng/branchlevel"/>
							</option>
						</xsl:if>
						<xsl:if test="user/permission >= 1 or user/classification = 3">
							<option value="1">
								<xsl:if test="userinfo/permission='1'">
									<xsl:attribute name="selected"/>
								</xsl:if>
								<xsl:value-of select="$lng/normallevel"/>
							</option>
						</xsl:if>
					</select>
				</xsl:if>
				<xsl:if test="userinfo/classification!='2'">
					<select name="permission" class="t2">
						<xsl:if test="user/permission >= 2 or user/classification = 3">
							<option value="2">
								<xsl:if test="userinfo/permission='2'">
									<xsl:attribute name="selected"/>
								</xsl:if>
								<xsl:value-of select="$lng/superlevel"/>
							</option>
						</xsl:if>
						<xsl:if test="user/permission >= 1 or user/classification = 3">
							<option value="1">
								<xsl:if test="userinfo/permission='1'">
									<xsl:attribute name="selected"/>
								</xsl:if>
								<xsl:value-of select="$lng/normallevel"/>
							</option>
						</xsl:if>
					</select>
				</xsl:if>
			</xsl:if>
		</td>
	</tr>
</xsl:template>

<xsl:template name="surname">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/surname"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:value-of select="userinfo/surname"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="firstname">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/firstname"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<xsl:value-of select="userinfo/name"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="skype">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/skype"/>
		</td>
		<td align="left" colspan="2" class="t2">
			<input type="text" name="skype" class="t2" value="{userinfo/skype}">
				<xsl:if test="editable='0'">
					<xsl:attribute name="readonly"/>
					<xsl:attribute name="class">t2 readonly</xsl:attribute>
				</xsl:if>
			</input>
		</td>
	</tr>
</xsl:template>
	
<xsl:template name="dateofbirth">
	<tr>
		<td ><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/dateofbirth"/>
		</td>
		<td align="left" class="t2">
			<input type="text" name="date_of_birth" id="date_of_birth" class="t2" value="{userinfo/date_of_birth}">
				<xsl:if test="editable='0'">
					<xsl:attribute name="readonly"/>
					<xsl:attribute name="class">t2 readonly</xsl:attribute>
				</xsl:if>
			</input>
		</td>
		<td align="right" class="t2">
			<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_date_of_birth" style="cursor: pointer; border: 0px;" alt="Date selector" />
		</td>
	</tr>
</xsl:template>
	
<xsl:template name="instantmessager">
	<tr>
		<td><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/instantmessager"/>
		</td>
		<td align="left" colspan="2" class="t2">
		<xsl:if test="editable='1'">
			<select name="instant_messager" class="t2">
				<option value="YAHOO">
					<xsl:if test="userinfo/instant_messager='YAHOO'">
						<xsl:attribute name="selected"/>
					</xsl:if>
					<xsl:value-of select="$lng/yahoomessager"/>
				</option>
				<option value="ICQ">
					<xsl:if test="userinfo/instant_messager='ICQ'">
						<xsl:attribute name="selected"/>
					</xsl:if>
					<xsl:value-of select="$lng/icqmessager"/>
				</option>
				<option value="MSN">
					<xsl:if test="userinfo/instant_messager='MSN'">
						<xsl:attribute name="selected"/>
					</xsl:if>
					<xsl:value-of select="$lng/msnmessager"/>
				</option>
				<option value="GOOGLE">
					<xsl:if test="userinfo/instant_messager='GOOGLE'">
						<xsl:attribute name="selected"/>
					</xsl:if>
					<xsl:value-of select="$lng/googletalk"/>
				</option>
			</select>
		</xsl:if>
		<xsl:if test="editable='0'">
			<xsl:choose>
				<xsl:when test="userinfo/instant_messager='YAHOO'">
					<xsl:value-of select="$lng/yahoomessager"/>
				</xsl:when>
				<xsl:when test="userinfo/instant_messager='ICQ'">
					<xsl:value-of select="$lng/icqmessager"/>
				</xsl:when>
				<xsl:when test="userinfo/instant_messager='MSN'">
					<xsl:value-of select="$lng/msnmessager"/>
				</xsl:when>
				<xsl:when test="userinfo/instant_messager='GOOGLE'">
					<xsl:value-of select="$lng/googletalk"/>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
			<input type="text" name="im_contact" class="t2" value="{userinfo/im_contact}">
				<xsl:if test="editable='0'">
					<xsl:attribute name="readonly"/>
					<xsl:attribute name="class">t2 readonly</xsl:attribute>
				</xsl:if>
			</input>
		</td>
	</tr>
</xsl:template>
	
<xsl:template name="emailimages">
	<tr>
		<td><br/></td>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/emailimages"/>
		</td>
		<td align="left" colspan="2" class="t2">
		<xsl:if test="editable='1'">
			<select name="emailimages" class="t2">
				<option value="P">
					<xsl:if test="userinfo/emailimages='P'">
						<xsl:attribute name="selected"/>
					</xsl:if>
					<xsl:value-of select="$lng/preferpictures"/>
				</option>
				<option value="W">
					<xsl:if test="userinfo/emailimages='W'">
						<xsl:attribute name="selected"/>
					</xsl:if>
					<xsl:value-of select="$lng/preferwords"/>
				</option>
				<option value="B">
					<xsl:if test="userinfo/emailimages='B'">
						<xsl:attribute name="selected"/>
					</xsl:if>
					<xsl:value-of select="$lng/preferpandw"/>
				</option>
			</select>
		</xsl:if>
		<xsl:if test="editable='0'">
			<xsl:choose>
				<xsl:when test="userinfo/emailimages='W'">
					<xsl:value-of select="$lng/preferwords"/>
				</xsl:when>
				<xsl:when test="userinfo/emailimages='P'">
					<xsl:value-of select="$lng/preferpictures"/>
				</xsl:when>
				<xsl:when test="userinfo/emailimages='B'">
					<xsl:value-of select="$lng/preferpandw"/>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		</td>
	</tr>
</xsl:template>

<xsl:template name="additional">
 <xsl:if test="userinfo/additional">
	 	<xsl:variable name="editable" select="editable"/>
		<xsl:for-each select="userinfo/additional">
			<xsl:variable name="current" select="current"/>
			<tr>
				<td ><br/></td>
				<td align="left" class="t1">
					<xsl:value-of select="name"/>
				</td>
				<td align="left" colspan="2" class="t2">
	<xsl:choose>
		<xsl:when test="type='select' or type='Select' or type='SELECT'">
			<xsl:if test="$editable='0'">
				<xsl:for-each select="option">
					<xsl:if test="value=$current">
						<xsl:value-of select="name"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="$editable='1'">
				<select name="additional[{column}]" class="t2">
					<xsl:for-each select="option">
						<option value="{value}">
							<xsl:if test="$current=value">
								<xsl:attribute name="selected"/>
							</xsl:if>
							<xsl:value-of select="name"/>
						</option>
					</xsl:for-each>
				</select>
			</xsl:if>
		</xsl:when>								
		<xsl:otherwise>
			<xsl:if test="$editable='0'">
				<xsl:value-of select="$current"/>
			</xsl:if>
			<xsl:if test="$editable='1'">
				<input name="additional[{column}]" value="{$current}" class="t2">
					<xsl:if test="size">
						<xsl:attribute name="size"><xsl:value-of select="size"/></xsl:attribute>
					</xsl:if>
				</input>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
				</td> 
			</tr>
		</xsl:for-each>  
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
