<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/countries.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>
<xsl:include href="./profile.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/adminprofile"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<link rel="stylesheet" type="text/css" media="all" href="./theme/{$theme}/style_calendar.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/adminprofile"/> (<xsl:value-of select="userinfo/name"/><xsl:value-of select="' '"/><xsl:value-of select="userinfo/surname"/>)
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'user'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="user"/>
					<input type="hidden" name="function" value="profile"/>
					<input type="hidden" name="id" value="{userinfo/id}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:call-template name="profile">
							<xsl:with-param name="without_mandate" select="'yes'"/>
							<xsl:with-param name="without_orgtitle" select="'yes'"/>
							<xsl:with-param name="without_organisationname" select="'yes'"/>
							<xsl:with-param name="without_transactionmin" select="'yes'"/>
							<xsl:with-param name="without_transactionfee" select="'yes'"/>
							<xsl:with-param name="without_userfee" select="'yes'"/>
							<xsl:with-param name="without_messagefee" select="'yes'"/>
							<xsl:with-param name="without_admin" select="'yes'"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/editinfo"/>
				</div>
				<div id="right_content">
					<xsl:if test="editable='1'">
						<xsl:value-of select="$lng/freetoedit"/>
					</xsl:if>
					<xsl:if test="editable='0'">
						<xsl:value-of select="$lng/notfreetoedit"/>
					</xsl:if>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>
	
	<script type="text/javascript">
		Calendar.setup({inputField:"date_of_birth",ifFormat:"%Y-%m-%d",button:"trigger_date_of_birth",singleClick:true});
		function alertremove() {	
			var del = document.report.deleteusers.checked;
			if(del) {
				if(!confirm("<xsl:value-of select="$lng/alertdelete"/>")) {
					document.report.deleteusers.checked = false;
				}
			}
		}
		<xsl:if test="created='1' or deleted='1'">
			parent.left.location.reload();
		</xsl:if>
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
