<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/searchusers"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/searchusers"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'user'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="user"/>
					<input type="hidden" name="function" value="search"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							 <td><br/></td>
							<td class="h t1" align="left">
								<xsl:value-of select="$lng/fullname"/>
							</td>
							<td class="ha t1" align="left">
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td class="ha t1" align="left">
								<xsl:value-of select="$lng/email"/>
							</td>
							<td class="ha t1" align="left">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td class="ha t1" align="left">
								<xsl:value-of select="$lng/branchname"/>
							</td>
							<td class="ha t1" align="left">
								<xsl:value-of select="$lng/organisationname"/>
							</td>
							<xsl:if test="user/classification='3'">
								<td class="ha t1" align="left">
									<xsl:value-of select="$lng/resetpassword"/>
								</td>
							</xsl:if>
						</tr>
						<xsl:for-each select="users">
							<tr>
								<td><br/></td>
								<td class="h2b t2" align="left">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
										</xsl:attribute>
										<xsl:value-of select="name"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="surname"/>
									</a>
								</td>
								<td class="h2c t2" align="left">
									<a>
										<xsl:attribute name="href">
											<xsl:value-of select="'callto://+'"/>
											<xsl:value-of select="phone_prefix"/>
											<xsl:number value="phone_work" format="1"/>
										</xsl:attribute>
										<xsl:value-of select="phone_work"/>
									</a>
								</td>
								<td class="h2c t2" align="left">
								<xsl:if test="email">
									<a href="mailto:{email}">
										<xsl:value-of select="email"/>
									</a>
								</xsl:if>
								</td>
								<td class="h2c t2" align="left">
									<xsl:choose>
										<xsl:when test="status='2'">
											<xsl:value-of select="$lng/passwordactive"/>
										</xsl:when>
										<xsl:when test="status='1'">
											<xsl:value-of select="$lng/active"/>
										</xsl:when>
										<xsl:when test="status='0'">
											<xsl:value-of select="$lng/deleted"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$lng/unknown"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="h2c t2" align="left">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=branch&amp;function=profile&amp;id=',./branchid)"/>
										</xsl:attribute>
										<xsl:value-of select="branchname"/>
									</a>
								</td>
								<td class="h2c t2" align="left">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',./organisationid)"/>
										</xsl:attribute>
										<xsl:value-of select="organisationname"/>
									</a>
								</td>
								<xsl:if test="../user/classification='3'">
									<td class="h2c t2" align="left">
										<xsl:if test="../user/usersid!=usersid">
											<a href="#" onClick="password_reset('{username}','{email}','{name}','{surname}')">
												<xsl:value-of select="$lng/reset"/>
											</a>
										</xsl:if>
									</td>
								</xsl:if>
							</tr>
						</xsl:for-each>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script language="javascript">
		function password_reset(username,email,name,surname) {
				if(confirm("<xsl:value-of select="$lng/passwordconfirm"/> "+name+" "+surname)) {
					parent.main.location.href = "main.php?module=password&amp;function=reset&amp;username="+username+"&amp;email="+email;		
				}
		}
</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
