<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Upgrade repository generator
* @package TenderSystem
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// load required files
require('modules/generic/generic.php');

$xml = '<?xml version="1.0" encoding="UTF-8"?>'."\n";
$xml.= "<upgrades>\n";
$directories = list_directories("modules");
foreach($directories as $value) {
	$loader = array();
	include($value."/_loader.php");
	if(!empty($loader)) {
		$xml.= "<upgrade location=\"".$value."\">\n";
		$xml.=xmlencode_array($loader,2)."\n";
		$xml.="<download>
			<type>sourceforge</type>
			<base>http://prdownloads.sourceforge.net/tendersystem/</base>
			<file>".str_replace("modules/","",$value).str_replace(".","_","_".$cfg['version']."-".$loader['module']['version'])."_ts.zip</file>
			<md5_file></md5_file>
			<sha1_file></sha1_file>
		</download>"."\n";
		$xml.="</upgrade>\n\n";
	}
}
$xml.= "</upgrades>\n";
echo $xml;

function xmlencode_array($array,$c=0) {
	$first = TRUE;
	$result = "";
	foreach ($array as $key => $value) {
		if(is_array($value)) {
			$result.= "<".$key.">\n";
			$result.= xmlencode_array($value,$c+1);
			$result.= "</".$key.">\n";
		} else {
			$result.= "<".$key.">".$value."</".$key.">\n";
		}
	}
	return $result;
}
?>