<?php

/**
 * PowerBB Engine - The Engine Helps You To Create Bulletin Board System.
 */

/**
 * @package 	: 	PowerBBAdsense (Adsenses)
 * @author 		: 	MSHRAQ abu-rakan (xxx_abu_rakan_xxx@hotmail.com)
 * @start 		: 	7/12/2009 , 03:25 AM
 */


class PowerBBAdsense
{
	var $id;
	var $Engine;

	function PowerBBAdsense($Engine)
	{
		$this->Engine = $Engine;
	}

 	/**
 	 * Insert new Adsense
 	 *
 	 * @param :
 	 *			Oh :O it's a long list
 	 */
 	function InsertAdsense($param)
 	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$query = $this->Engine->records->Insert($this->Engine->table['adsense'],$param['field']);

		if ($param['get_id'])
		{
			$this->id = $this->Engine->DB->sql_insert_id();
		}

		return ($query) ? true : false;
 	}


	function DeleteAdsense($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['table'] = $this->Engine->table['adsense'];

		$del = $this->Engine->records->Delete($param);

		return ($del) ? true : false;
	}

	/**
	 * Get the list of Adsense
	 *
	 * $param =
	 *			array(	'sql_statment'	=>	'complete SQL statement',
	 *					'proc'			=>	true // When you want proccess the outputs
	 *					);
	 *
	 * @return :
	 *				array -> of information
	 *				false -> when found no information
	 */
	function GetAdsenseList($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 	= 	'*';
 		$param['from'] 		= 	$this->Engine->table['adsense'];

		$rows = $this->Engine->records->GetList($param);

		return $rows;
	}

	/**
	 * Get Adsense info
	 *
	 * $param =
	 *			array(	'id'	=>	'the id of Supermemberlogs');
	 *
	 * @return :
	 *			array -> of information
	 *			false -> when found no information
	 */
	function GetAdsenseInfo($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 	= 	'*';
		$param['from'] 		= 	$this->Engine->table['adsense'];

		$rows = $this->Engine->records->GetInfo($param);

 	 	return $rows;
	}


	 function UpdateAdsense($param)
 	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$query = $this->Engine->records->Update($this->Engine->table['adsense'],$param['field'],$param['where']);

		return ($query) ? true : false;
 	}

}

?>
